/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Quotient
implements ScalarFunction {
    private static final String FUNCTION_NAME = "quotient";
    private static final Quotient INSTANCE = new Quotient();

    private Quotient() {
    }

    public static Quotient getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        if (list.get(0).isNull() || list.get(1).isNull() || ((NumberValue)list.get(1)).getValue() == 0.0) {
            return NumberValue.getNullValue();
        }
        double d = ((NumberValue)list.get(0)).getValue() / ((NumberValue)list.get(1)).getValue();
        return new NumberValue(d);
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 2) {
            throw new InvalidQueryException("The function quotient requires 2 parmaeters ");
        }
        for (ValueType valueType : list) {
            if (valueType == ValueType.NUMBER) continue;
            throw new InvalidQueryException("Can't perform the function quotient on values that are not numbers");
        }
    }

    @Override
    public String toQueryString(List<String> list) {
        return "(" + list.get(0) + " / " + list.get(1) + ")";
    }
}

