/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Upper
implements ScalarFunction {
    private static final String FUNCTION_NAME = "upper";
    private static final Upper INSTANCE = new Upper();

    private Upper() {
    }

    public static Upper getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        return new TextValue(((TextValue)list.get(0)).getValue().toUpperCase());
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.TEXT;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 1) {
            throw new InvalidQueryException("upper requires 1 parmaeter");
        }
        if (list.get(0) != ValueType.TEXT) {
            throw new InvalidQueryException("upper takes a text parameter");
        }
    }

    @Override
    public String toQueryString(List<String> list) {
        return "upper(" + list.get(0) + ")";
    }
}

