/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CsvRenderer {
    private CsvRenderer() {
    }

    public static CharSequence renderDataTable(DataTable dataTable, ULocale uLocale, String string) {
        if (string == null) {
            string = ",";
        }
        if (dataTable.getColumnDescriptions().isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        for (ColumnDescription columnDescription : list) {
            stringBuilder.append(CsvRenderer.escapeString(columnDescription.getLabel())).append(string);
        }
        Map<ValueType, ValueFormatter> map = ValueFormatter.createDefaultFormatters(uLocale);
        int n = stringBuilder.length();
        stringBuilder.replace(n - 1, n, "\n");
        List<TableRow> list2 = dataTable.getRows();
        for (TableRow tableRow : list2) {
            List<TableCell> list3 = tableRow.getCells();
            for (TableCell tableCell : list3) {
                String string2 = tableCell.getFormattedValue();
                if (string2 == null) {
                    string2 = ((ValueFormatter)map.get((Object)tableCell.getType())).format(tableCell.getValue());
                }
                if (tableCell.isNull()) {
                    stringBuilder.append("null");
                } else {
                    ValueType valueType = tableCell.getType();
                    if (string2.indexOf(44) > -1 || valueType.equals((Object)ValueType.TEXT)) {
                        stringBuilder.append(CsvRenderer.escapeString(string2));
                    } else {
                        stringBuilder.append(string2);
                    }
                }
                stringBuilder.append(string);
            }
            n = stringBuilder.length();
            stringBuilder.replace(n - 1, n, "\n");
        }
        return stringBuilder.toString();
    }

    private static String escapeString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(StringUtils.replace((String)string, (String)"\"", (String)"\"\""));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static String renderCsvError(ResponseStatus responseStatus) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error: ").append(responseStatus.getReasonType().getMessageForReasonType(null));
        stringBuilder.append(". ").append(responseStatus.getDescription());
        return CsvRenderer.escapeString(stringBuilder.toString());
    }
}

