/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.testing;

import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.json.Cookie;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlRequestTransport
implements RequestTransport {
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final URL url;

    public UrlRequestTransport(URL url) {
        this.url = url;
        String proto = url.getProtocol().toLowerCase();
        if (!proto.equals("http") && !proto.equals("https")) {
            throw new IllegalArgumentException("Only http and https URLs supported");
        }
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(String payload, RequestTransport.TransportReceiver receiver) {
        HttpURLConnection connection;
        block17: {
            block16: {
                connection = null;
                try {
                    try {
                        connection = (HttpURLConnection)this.url.openConnection();
                        this.configureConnection(connection);
                        OutputStream out = connection.getOutputStream();
                        out.write(payload.getBytes("UTF-8"));
                        out.close();
                        int status = connection.getResponseCode();
                        if (status != 200) {
                            ServerFailure failure = new ServerFailure(status + " " + connection.getResponseMessage());
                            receiver.onTransportFailure(failure);
                            Object var15_10 = null;
                            if (connection == null) return;
                            connection.disconnect();
                            return;
                        }
                        List<String> cookieHeaders = connection.getHeaderFields().get("Set-Cookie");
                        if (cookieHeaders != null) {
                            for (String header : cookieHeaders) {
                                try {
                                    String path;
                                    JSONObject cookie = Cookie.toJSONObject((String)header);
                                    String name = cookie.getString("name");
                                    String value = cookie.getString("value");
                                    String domain = cookie.optString("Domain");
                                    if (domain != null && !this.url.getHost().endsWith(domain) || (path = cookie.optString("Path")) != null && !this.url.getPath().startsWith(path)) continue;
                                    this.cookies.put(name, value);
                                }
                                catch (JSONException ignored) {}
                            }
                        }
                        String encoding = connection.getContentEncoding();
                        InputStream in = connection.getInputStream();
                        if ("gzip".equalsIgnoreCase(encoding)) {
                            in = new GZIPInputStream(in);
                        } else if ("deflate".equalsIgnoreCase(encoding)) {
                            in = new InflaterInputStream(in);
                        } else if (encoding != null) {
                            receiver.onTransportFailure(new ServerFailure("Unknown server encoding " + encoding));
                            break block16;
                        }
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        byte[] buffer = new byte[4096];
                        int read = in.read(buffer);
                        while (read != -1) {
                            bytes.write(buffer, 0, read);
                            read = in.read(buffer);
                        }
                        in.close();
                        String received = new String(bytes.toByteArray(), "UTF-8");
                        receiver.onTransportSuccess(received);
                        break block17;
                    }
                    catch (IOException e) {
                        ServerFailure failure = new ServerFailure(e.getMessage(), e.getClass().getName(), null, true);
                        receiver.onTransportFailure(failure);
                        Object var15_13 = null;
                        if (connection == null) return;
                        connection.disconnect();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    if (connection == null) throw throwable;
                    connection.disconnect();
                    throw throwable;
                }
            }
            Object var15_11 = null;
            if (connection == null) return;
            connection.disconnect();
            return;
        }
        Object var15_12 = null;
        if (connection == null) return;
        connection.disconnect();
    }

    protected void configureConnection(HttpURLConnection connection) throws IOException {
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Host", this.url.getHost());
        connection.setRequestProperty("User-Agent", UrlRequestTransport.class.getCanonicalName());
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(60000);
        if (!this.cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needsSemi = false;
            for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                if (needsSemi) {
                    sb.append("; ");
                } else {
                    needsSemi = true;
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            connection.setRequestProperty("Cookie", sb.toString());
        }
    }
}

