/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.impl;

import com.google.web.bindery.requestfactory.vm.impl.OperationKey;

public class OperationData {
    private String clientMethodDescriptor;
    private String domainMethodDescriptor;
    private String methodName;
    private String requestContextBinaryName;

    OperationData() {
    }

    public String getClientMethodDescriptor() {
        return this.clientMethodDescriptor;
    }

    public String getDomainMethodDescriptor() {
        return this.domainMethodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getRequestContext() {
        return this.requestContextBinaryName;
    }

    public String toString() {
        String string = this.getRequestContext();
        String string2 = this.getMethodName();
        String string3 = this.getDomainMethodDescriptor();
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("::").append(string2).append(string3).toString();
    }

    public static class Builder {
        OperationData d = new OperationData();

        public OperationData build() {
            OperationData toReturn = this.d;
            this.d = null;
            if (toReturn.clientMethodDescriptor != null) {
                toReturn.clientMethodDescriptor = OperationKey.stripReturnType(toReturn.clientMethodDescriptor);
            }
            if (toReturn.domainMethodDescriptor != null) {
                toReturn.domainMethodDescriptor = OperationKey.stripReturnType(toReturn.domainMethodDescriptor);
            }
            return toReturn;
        }

        public Builder withClientMethodDescriptor(String clientMethodDescriptor) {
            this.d.clientMethodDescriptor = clientMethodDescriptor;
            return this;
        }

        public Builder withDomainMethodDescriptor(String domainMethodDescriptor) {
            this.d.domainMethodDescriptor = domainMethodDescriptor;
            return this;
        }

        public Builder withMethodName(String methodName) {
            this.d.methodName = methodName;
            return this;
        }

        public Builder withRequestContext(String requestContext) {
            this.d.requestContextBinaryName = requestContext;
            return this;
        }
    }
}

