/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared;

import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodexHelper;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCodex {
    private static final Set<Class<?>> ALL_VALUE_TYPES;
    private static final Map<Class<?>, Type> TYPES_BY_CLASS;

    public static boolean canDecode(Class<?> clazz) {
        if (ValueCodex.findType(clazz) != null) {
            return true;
        }
        return ValueCodexHelper.canDecode(clazz);
    }

    public static <T> T decode(Class<T> clazz, Splittable split) {
        if (split == null || split == Splittable.NULL) {
            return null;
        }
        return (T)ValueCodex.getTypeOrDie(clazz).decode(clazz, split);
    }

    @Deprecated
    public static <T> T decode(Class<T> clazz, String string) {
        throw new UnsupportedOperationException();
    }

    public static Splittable encode(Class<?> clazz, Object obj) {
        if (obj == null) {
            return Splittable.NULL;
        }
        return ValueCodex.getTypeOrDie(clazz).encode(obj);
    }

    public static Splittable encode(Object obj) {
        if (obj == null) {
            return Splittable.NULL;
        }
        Type t = ValueCodex.findType(obj.getClass());
        if (t == null) {
            for (Type maybe : Type.values()) {
                if (!maybe.canUpcast(obj)) continue;
                t = maybe;
                break;
            }
        }
        if (t == null) {
            throw new UnsupportedOperationException(obj.getClass().getName());
        }
        return t.encode(obj);
    }

    public static Set<Class<?>> getAllValueTypes() {
        return ALL_VALUE_TYPES;
    }

    public static Object getUninitializedFieldValue(Class<?> clazz) {
        Type type = ValueCodex.getTypeOrDie(clazz);
        if (clazz.equals(type.getPrimitiveType())) {
            return type.getDefaultValue();
        }
        return null;
    }

    private static <T> Type findType(Class<T> clazz) {
        if (clazz.isEnum()) {
            return Type.ENUM;
        }
        return TYPES_BY_CLASS.get(clazz);
    }

    private static <T> Type getTypeOrDie(Class<T> clazz) {
        Type toReturn = ValueCodex.findType(clazz);
        if (toReturn == null) {
            throw new UnsupportedOperationException(clazz.getName());
        }
        return toReturn;
    }

    static {
        HashMap temp = new HashMap();
        for (Type t : Type.values()) {
            temp.put(t.getType(), t);
            if (t.getPrimitiveType() == null) continue;
            temp.put(t.getPrimitiveType(), t);
        }
        ALL_VALUE_TYPES = Collections.unmodifiableSet(temp.keySet());
        TYPES_BY_CLASS = Collections.unmodifiableMap(temp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        BIG_DECIMAL((Class)BigDecimal.class){

            @Override
            public boolean canUpcast(Object value) {
                return value instanceof BigDecimal;
            }

            @Override
            public BigDecimal decode(Class<?> clazz, Splittable value) {
                return new BigDecimal(value.asString());
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((BigDecimal)value).toString());
            }
        }
        ,
        BIG_INTEGER((Class)BigInteger.class){

            @Override
            public boolean canUpcast(Object value) {
                return value instanceof BigInteger;
            }

            @Override
            public BigInteger decode(Class<?> clazz, Splittable value) {
                return new BigInteger(value.asString());
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((BigInteger)value).toString());
            }
        }
        ,
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE, (Object)false){

            @Override
            public Boolean decode(Class<?> clazz, Splittable value) {
                return value.asBoolean();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create((Boolean)value);
            }
        }
        ,
        BYTE((Class)Byte.class, (Class)Byte.TYPE, (Object)0){

            @Override
            public Byte decode(Class<?> clazz, Splittable value) {
                return (byte)value.asNumber();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((Byte)value).byteValue());
            }
        }
        ,
        CHARACTER((Class)Character.class, (Class)Character.TYPE, (Object)Character.valueOf('\u0000')){

            @Override
            public Character decode(Class<?> clazz, Splittable value) {
                return Character.valueOf(value.asString().charAt(0));
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(String.valueOf((Character)value));
            }
        }
        ,
        DATE((Class)Date.class){

            @Override
            public boolean canUpcast(Object value) {
                return value instanceof Date;
            }

            @Override
            public Date decode(Class<?> clazz, Splittable value) {
                if (value.isNumber()) {
                    return new Date((long)value.asNumber());
                }
                return StringQuoter.tryParseDate(value.asString());
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(String.valueOf(((Date)value).getTime()));
            }
        }
        ,
        DOUBLE((Class)Double.class, (Class)Double.TYPE, (Object)0.0){

            @Override
            public Double decode(Class<?> clazz, Splittable value) {
                return value.asNumber();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create((Double)value);
            }
        }
        ,
        ENUM((Class)Enum.class){

            @Override
            public boolean canUpcast(Object value) {
                return value instanceof Enum;
            }

            @Override
            public Enum<?> decode(Class<?> clazz, Splittable value) {
                return (Enum)clazz.getEnumConstants()[(int)value.asNumber()];
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((Enum)value).ordinal());
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE, (Object)Float.valueOf(0.0f)){

            @Override
            public Float decode(Class<?> clazz, Splittable value) {
                return Float.valueOf((float)value.asNumber());
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((Float)value).floatValue());
            }
        }
        ,
        INTEGER((Class)Integer.class, (Class)Integer.TYPE, (Object)0){

            @Override
            public Integer decode(Class<?> clazz, Splittable value) {
                return (int)value.asNumber();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((Integer)value).intValue());
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE, (Object)0L){

            @Override
            public Long decode(Class<?> clazz, Splittable value) {
                if (value.isNumber()) {
                    return (long)value.asNumber();
                }
                return Long.parseLong(value.asString());
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(String.valueOf((Long)value));
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE, (Object)0){

            @Override
            public Short decode(Class<?> clazz, Splittable value) {
                return (short)value.asNumber();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create(((Short)value).shortValue());
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public String decode(Class<?> clazz, Splittable value) {
                return value.asString();
            }

            @Override
            public Splittable encode(Object value) {
                return StringQuoter.create((String)value);
            }
        }
        ,
        SPLITTABLE((Class)Splittable.class){

            @Override
            public Splittable decode(Class<?> clazz, Splittable value) {
                return value;
            }

            @Override
            public Splittable encode(Object value) {
                return (Splittable)value;
            }
        }
        ,
        VOID((Class)Void.class, (Class)Void.TYPE, (Object)null){

            @Override
            public Void decode(Class<?> clazz, Splittable value) {
                return null;
            }

            @Override
            public Splittable encode(Object value) {
                return null;
            }
        };

        private final Object defaultValue;
        private final Class<?> type;
        private final Class<?> primitiveType;

        private Type(Class<?> objectType) {
            this(objectType, null, null);
        }

        private Type(Class<?> objectType, Class<?> primitiveType, Object defaultValue) {
            this.type = objectType;
            this.primitiveType = primitiveType;
            this.defaultValue = defaultValue;
        }

        public boolean canUpcast(Object value) {
            return false;
        }

        public abstract Object decode(Class<?> var1, Splittable var2);

        public abstract Splittable encode(Object var1);

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Class<?> getPrimitiveType() {
            return this.primitiveType;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

