/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.server.DeadEntityException;
import com.google.web.bindery.requestfactory.server.ReportableException;
import com.google.web.bindery.requestfactory.server.RequestState;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class Resolver {
    private IdentityHashMap<BaseProxy, Resolution> clientObjectsToResolutions = new IdentityHashMap();
    private final Map<ResolutionKey, Resolution> resolved = new HashMap<ResolutionKey, Resolution>();
    private final ServiceLayer service;
    private final RequestState state;
    private Set<Resolution> toProcess = new LinkedHashSet<Resolution>();
    private int syntheticId;

    static int index(String path) {
        int idx = path.lastIndexOf(91);
        if (idx == -1) {
            return -1;
        }
        return Integer.parseInt(path.substring(idx + 1, path.lastIndexOf(93)));
    }

    static boolean matchesPropertyRef(Set<String> propertyRefs, String newPrefix) {
        return propertyRefs.contains("*") || propertyRefs.contains(newPrefix.replaceAll("\\[\\d+\\]", ""));
    }

    static String snipIndex(String path) {
        int idx = path.lastIndexOf(91);
        if (idx == -1) {
            return path;
        }
        return path.substring(0, idx);
    }

    private static Set<String> expandPropertyRefs(Set<String> refs) {
        if (refs == null) {
            return Collections.emptySet();
        }
        TreeSet<String> toReturn = new TreeSet<String>();
        for (String raw : refs) {
            int idx = raw.length();
            while (idx >= 0) {
                toReturn.add(raw.substring(0, idx));
                idx = raw.lastIndexOf(46, idx - 1);
            }
        }
        return toReturn;
    }

    Resolver(RequestState state) {
        this.state = state;
        this.service = state.getServiceLayer();
    }

    public Object resolveClientValue(Object domainValue, Type assignableTo, Set<String> propertyRefs) {
        Resolution toReturn = this.resolveClientValue(domainValue, assignableTo);
        if (toReturn == null) {
            return null;
        }
        this.addPathsToResolution(toReturn, "", Resolver.expandPropertyRefs(propertyRefs));
        while (!this.toProcess.isEmpty()) {
            ArrayList<Resolution> working = new ArrayList<Resolution>(this.toProcess);
            this.toProcess.clear();
            for (Resolution resolution : working) {
                if (!resolution.hasWork()) continue;
                AutoBean bean = AutoBeanUtils.getAutoBean((BaseProxy)resolution.getClientObject());
                bean.accept(new PropertyResolver(resolution));
            }
        }
        return toReturn.getClientObject();
    }

    public Object resolveDomainValue(Object maybeEntityProxy, boolean detectDeadEntities) {
        if (maybeEntityProxy instanceof BaseProxy) {
            AutoBean bean = AutoBeanUtils.getAutoBean((BaseProxy)maybeEntityProxy);
            Object domain = bean.getTag("domainObject");
            if (domain == null && detectDeadEntities) {
                throw new ReportableException(new DeadEntityException("The requested entity is not available on the server"));
            }
            return domain;
        }
        if (maybeEntityProxy instanceof Collection) {
            AbstractCollection accumulator;
            if (maybeEntityProxy instanceof List) {
                accumulator = new ArrayList();
            } else if (maybeEntityProxy instanceof Set) {
                accumulator = new HashSet();
            } else {
                throw new ReportableException("Unsupported collection type " + maybeEntityProxy.getClass().getName());
            }
            for (Object o : (Collection)maybeEntityProxy) {
                accumulator.add(this.resolveDomainValue(o, detectDeadEntities));
            }
            return accumulator;
        }
        return maybeEntityProxy;
    }

    private void addPathsToResolution(Resolution resolution, String prefix, Set<String> propertyRefs) {
        if (propertyRefs.isEmpty()) {
            return;
        }
        if (resolution.getResolutionKey() != null) {
            assert (resolution.getClientObject() instanceof BaseProxy) : "Expecting BaseProxy, found " + resolution.getClientObject().getClass().getCanonicalName();
            resolution.addPaths(prefix, propertyRefs);
            if (resolution.hasWork()) {
                this.toProcess.add(resolution);
            }
            return;
        }
        if (resolution.getClientObject() instanceof Collection) {
            Collection collection = (Collection)resolution.getClientObject();
            for (Object obj : collection) {
                Resolution subResolution = this.clientObjectsToResolutions.get(obj);
                if (subResolution == null) continue;
                this.addPathsToResolution(subResolution, prefix, propertyRefs);
            }
            return;
        }
        assert (false) : "Should not add paths to client type " + resolution.getClientObject().getClass().getCanonicalName();
    }

    private Resolution makeResolution(Object domainValue) {
        assert (!this.state.isEntityType(domainValue.getClass()) && !this.state.isValueType(domainValue.getClass())) : "Not a simple value type";
        return new Resolution(domainValue);
    }

    private Resolution makeResolution(ResolutionKey key, BaseProxy clientObject) {
        Resolution resolution = this.resolved.get(key);
        if (resolution == null) {
            resolution = new Resolution(key, clientObject);
            this.clientObjectsToResolutions.put(clientObject, resolution);
            this.toProcess.add(resolution);
            this.resolved.put(key, resolution);
        }
        return resolution;
    }

    private <T extends BaseProxy> Resolution resolveClientProxy(Object domainEntity, Class<T> proxyType, ResolutionKey key) {
        Object domainVersion;
        if (domainEntity == null) {
            return null;
        }
        SimpleProxyId<Object> id = this.state.getStableId(domainEntity);
        boolean isEntityProxy = this.state.isEntityType(proxyType);
        if (id == null || id.isEphemeral()) {
            Splittable flatValue;
            Object domainId;
            if (isEntityProxy) {
                domainId = this.service.getId(domainEntity);
                domainVersion = this.service.getVersion(domainEntity);
            } else {
                domainId = null;
                domainVersion = null;
            }
            if (id == null) {
                if (domainId == null) {
                    id = this.state.getIdFactory().allocateSyntheticId(proxyType, ++this.syntheticId);
                } else {
                    flatValue = this.state.flatten(domainId);
                    id = this.state.getIdFactory().getId(proxyType, flatValue.getPayload(), 0);
                }
            } else if (domainId != null) {
                flatValue = this.state.flatten(domainId);
                id.setServerId(flatValue.getPayload());
            }
        } else {
            domainVersion = isEntityProxy ? this.service.getVersion(domainEntity) : null;
        }
        AutoBean<?> bean = this.state.getBeanForPayload(id, domainEntity);
        bean.setTag("inResponse", true);
        if (domainVersion != null) {
            Splittable flatVersion = this.state.flatten(domainVersion);
            bean.setTag("version", SimpleRequestProcessor.toBase64(flatVersion.getPayload()));
        }
        BaseProxy clientObject = (BaseProxy)bean.as();
        return this.makeResolution(key, clientObject);
    }

    private Resolution resolveClientValue(Object domainValue, Type clientType) {
        boolean anyType;
        if (domainValue == null) {
            return new Resolution(null);
        }
        boolean bl = anyType = clientType == null;
        if (anyType) {
            clientType = Object.class;
        }
        Class<?> assignableTo = TypeUtils.ensureBaseType((Type)clientType);
        ResolutionKey key = new ResolutionKey(domainValue, (Type)clientType);
        Resolution previous = this.resolved.get(key);
        if (previous != null && assignableTo.isInstance(previous.getClientObject())) {
            return previous;
        }
        Class<?> returnClass = this.service.resolveClientType(domainValue.getClass(), assignableTo, true);
        if (anyType) {
            assignableTo = returnClass;
        }
        if (ValueCodex.canDecode(returnClass)) {
            return this.makeResolution(domainValue);
        }
        boolean isProxy = BaseProxy.class.isAssignableFrom(returnClass);
        boolean isId = EntityProxyId.class.isAssignableFrom(returnClass);
        if (isProxy || isId) {
            Class<BaseProxy> proxyClass = returnClass.asSubclass(BaseProxy.class);
            return this.resolveClientProxy(domainValue, proxyClass, key);
        }
        if (Collection.class.isAssignableFrom(returnClass)) {
            AbstractCollection accumulator;
            if (List.class.isAssignableFrom(returnClass)) {
                accumulator = new ArrayList();
            } else if (Set.class.isAssignableFrom(returnClass)) {
                accumulator = new HashSet();
            } else {
                throw new ReportableException("Unsupported collection type" + returnClass.getName());
            }
            Type elementType = TypeUtils.getSingleParameterization(Collection.class, new Type[]{clientType});
            for (Object o : (Collection)domainValue) {
                accumulator.add(this.resolveClientValue(o, elementType).getClientObject());
            }
            return this.makeResolution(accumulator);
        }
        throw new ReportableException("Unsupported domain type " + returnClass.getCanonicalName());
    }

    private static class ResolutionKey {
        private final Object domainObject;
        private final int hashCode;
        private final Type requestedType;

        public ResolutionKey(Object domainObject, Type requestedType) {
            this.domainObject = domainObject;
            this.requestedType = requestedType;
            this.hashCode = System.identityHashCode(domainObject) * 13 + requestedType.hashCode() * 7;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResolutionKey)) {
                return false;
            }
            ResolutionKey other = (ResolutionKey)o;
            if (this.domainObject != other.domainObject) {
                return false;
            }
            return this.requestedType.equals(other.requestedType);
        }

        public Object getDomainObject() {
            return this.domainObject;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.domainObject.toString() + " => " + this.requestedType.toString();
        }
    }

    private static class Resolution {
        private static final SortedSet<String> EMPTY = Collections.unmodifiableSortedSet(new TreeSet());
        private final Object clientObject;
        private boolean needsSimpleValues;
        private SortedSet<String> toResolve = EMPTY;
        private final SortedSet<String> resolved = new TreeSet<String>();
        private final ResolutionKey key;

        public Resolution(Object simpleValue) {
            assert (!(simpleValue instanceof Resolution));
            this.clientObject = simpleValue;
            this.key = null;
        }

        public Resolution(ResolutionKey key, BaseProxy clientObject) {
            this.clientObject = clientObject;
            this.key = key;
            this.needsSimpleValues = true;
        }

        public void addPaths(String prefix, Collection<String> requestedPaths) {
            if (this.clientObject == null) {
                return;
            }
            if (this.toResolve == EMPTY) {
                this.toResolve = new TreeSet<String>();
            }
            prefix = prefix.isEmpty() ? prefix : prefix + ".";
            int prefixLength = prefix.length();
            for (String path : requestedPaths) {
                if (path.startsWith(prefix)) {
                    this.toResolve.add(path.substring(prefixLength));
                    continue;
                }
                if (!path.startsWith("*.")) continue;
                this.toResolve.add(path.substring("*.".length()));
            }
            this.toResolve.removeAll(this.resolved);
            if (this.toResolve.isEmpty()) {
                this.toResolve = EMPTY;
            }
        }

        public Object getClientObject() {
            return this.clientObject;
        }

        public ResolutionKey getResolutionKey() {
            return this.key;
        }

        public boolean hasWork() {
            return this.needsSimpleValues || !this.toResolve.isEmpty();
        }

        public boolean needsSimpleValues() {
            return this.needsSimpleValues;
        }

        public SortedSet<String> takeWork() {
            this.needsSimpleValues = false;
            SortedSet<String> toReturn = this.toResolve;
            this.resolved.addAll(toReturn);
            this.toResolve = EMPTY;
            return toReturn;
        }
    }

    private class PropertyResolver
    extends AutoBeanVisitor {
        private final Object domainEntity;
        private final boolean isOwnerValueProxy;
        private final boolean needsSimpleValues;
        private final Set<String> propertyRefs;

        private PropertyResolver(Resolution resolution) {
            ResolutionKey key = resolution.getResolutionKey();
            this.domainEntity = key.getDomainObject();
            this.isOwnerValueProxy = Resolver.this.state.isValueType(TypeUtils.ensureBaseType(key.requestedType));
            this.needsSimpleValues = resolution.needsSimpleValues();
            this.propertyRefs = resolution.takeWork();
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            boolean shouldSend;
            Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
            boolean bl = shouldSend = this.isOwnerValueProxy || Resolver.matchesPropertyRef(this.propertyRefs, propertyName) || elementType != null && ValueCodex.canDecode(elementType);
            if (!shouldSend) {
                return false;
            }
            Object domainValue = Resolver.this.service.getProperty(this.domainEntity, propertyName);
            if (domainValue == null) {
                return false;
            }
            Type type = elementType == null ? ctx.getType() : new CollectionType(ctx.getType(), elementType);
            Resolution resolution = Resolver.this.resolveClientValue(domainValue, type);
            Resolver.this.addPathsToResolution(resolution, propertyName, this.propertyRefs);
            ctx.set(resolution.getClientObject());
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            if (this.needsSimpleValues) {
                value = Resolver.this.service.getProperty(this.domainEntity, propertyName);
                ctx.set(value);
            }
            return false;
        }
    }

    private static class CollectionType
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Class<?> elementType;

        private CollectionType(Class<?> rawType, Class<?> elementType) {
            this.rawType = rawType;
            this.elementType = elementType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollectionType)) {
                return false;
            }
            CollectionType other = (CollectionType)o;
            return this.rawType.equals(other.rawType) && this.elementType.equals(other.elementType);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.elementType};
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return this.rawType.hashCode() * 13 + this.elementType.hashCode() * 7;
        }
    }
}

