/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.vm.impl.ProxyAutoBean;
import com.google.web.bindery.autobean.vm.impl.SimpleBeanHandler;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public enum BeanMethod {
    OBJECT{

        @Override
        public String inferName(Method method) {
            throw new UnsupportedOperationException();
        }

        @Override
        Object invoke(SimpleBeanHandler<?> handler, Method method, Object[] args) throws Throwable {
            if (CALL.matches(handler, method)) {
                return CALL.invoke(handler, method, args);
            }
            return method.invoke(handler, args);
        }

        @Override
        boolean matches(SimpleBeanHandler<?> handler, Method method) {
            return method.getDeclaringClass().equals(Object.class);
        }
    }
    ,
    GET{

        @Override
        public String inferName(Method method) {
            Class<?> returnType;
            String name = method.getName();
            if (name.startsWith(BeanMethod.IS_PREFIX) && !method.isAnnotationPresent(AutoBean.PropertyName.class) && (Boolean.TYPE.equals(returnType = method.getReturnType()) || Boolean.class.equals(returnType))) {
                return BeanMethod.decapitalize(name.substring(2));
            }
            return super.inferName(method);
        }

        @Override
        Object invoke(SimpleBeanHandler<?> handler, Method method, Object[] args) {
            String propertyName = this.inferName(method);
            Object toReturn = handler.getBean().getOrReify(propertyName);
            if (toReturn == null && method.getReturnType().isPrimitive()) {
                toReturn = TypeUtils.getDefaultPrimitiveValue(method.getReturnType());
            }
            return toReturn;
        }

        @Override
        boolean matches(SimpleBeanHandler<?> handler, Method method) {
            Class<?> returnType = method.getReturnType();
            if (method.getParameterTypes().length != 0 || Void.TYPE.equals(returnType)) {
                return false;
            }
            String name = method.getName();
            if ((Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType)) && (name.startsWith(BeanMethod.IS_PREFIX) && name.length() > 2 || name.startsWith(BeanMethod.HAS_PREFIX) && name.length() > 3)) {
                return true;
            }
            return name.startsWith(BeanMethod.GET_PREFIX) && name.length() > 3;
        }
    }
    ,
    SET{

        @Override
        Object invoke(SimpleBeanHandler<?> handler, Method method, Object[] args) {
            handler.getBean().setProperty(this.inferName(method), args[0]);
            return null;
        }

        @Override
        boolean matches(SimpleBeanHandler<?> handler, Method method) {
            String name = method.getName();
            return name.startsWith(BeanMethod.SET_PREFIX) && name.length() > 3 && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
        }
    }
    ,
    SET_BUILDER{

        @Override
        Object invoke(SimpleBeanHandler<?> handler, Method method, Object[] args) {
            ProxyAutoBean<?> bean = handler.getBean();
            bean.setProperty(this.inferName(method), args[0]);
            return bean.as();
        }

        @Override
        boolean matches(SimpleBeanHandler<?> handler, Method method) {
            String name = method.getName();
            return name.startsWith(BeanMethod.SET_PREFIX) && name.length() > 3 && method.getParameterTypes().length == 1 && method.getReturnType().isAssignableFrom(method.getDeclaringClass());
        }
    }
    ,
    CALL{

        @Override
        public String inferName(Method method) {
            throw new UnsupportedOperationException();
        }

        @Override
        Object invoke(SimpleBeanHandler<?> handler, Method method, Object[] args) throws Throwable {
            Method found;
            if (args == null) {
                args = EMPTY_OBJECT;
            }
            if ((found = 5.findMethod(handler, method)) != null) {
                Object[] realArgs = new Object[args.length + 1];
                realArgs[0] = handler.getBean();
                System.arraycopy(args, 0, realArgs, 1, args.length);
                return found.invoke(null, realArgs);
            }
            String string = String.valueOf(method.toGenericString());
            throw new RuntimeException(string.length() != 0 ? "Could not find category implementation of ".concat(string) : new String("Could not find category implementation of "));
        }

        @Override
        boolean matches(SimpleBeanHandler<?> handler, Method method) {
            return handler.getBean().isWrapper() || !handler.getBean().getConfiguration().getCategories().isEmpty() && 5.findMethod(handler, method) != null;
        }
    };

    public static final String GET_PREFIX = "get";
    public static final String HAS_PREFIX = "has";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    private static final Object[] EMPTY_OBJECT;

    static Method findMethod(SimpleBeanHandler<?> handler, Method method) {
        Class<?>[] declaredParams = method.getParameterTypes();
        Class[] searchParams = new Class[declaredParams.length + 1];
        searchParams[0] = AutoBean.class;
        System.arraycopy(declaredParams, 0, searchParams, 1, declaredParams.length);
        Class<?> autoBeanType = handler.getBean().getType();
        for (Class<?> clazz : handler.getBean().getConfiguration().getCategories()) {
            try {
                Method found = clazz.getMethod(method.getName(), searchParams);
                if (!Modifier.isStatic(found.getModifiers())) continue;
                Class<?> foundAutoBean = TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(AutoBean.class, found.getGenericParameterTypes()[0]));
                if (!foundAutoBean.isAssignableFrom(autoBeanType)) continue;
                return found;
            }
            catch (NoSuchMethodException expected) {
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        int length = name.length();
        if (length == 0 || length > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(Character.toLowerCase(name.charAt(0)));
        sb.append(name.substring(1));
        return sb.toString();
    }

    public String inferName(Method method) {
        AutoBean.PropertyName prop = method.getAnnotation(AutoBean.PropertyName.class);
        if (prop != null) {
            return prop.value();
        }
        return BeanMethod.decapitalize(method.getName().substring(3));
    }

    public boolean matches(Method method) {
        return this.matches(null, method);
    }

    abstract Object invoke(SimpleBeanHandler<?> var1, Method var2, Object[] var3) throws Throwable;

    abstract boolean matches(SimpleBeanHandler<?> var1, Method var2);

    static {
        EMPTY_OBJECT = new Object[0];
    }
}

