/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.ArrayStamper;
import javaemul.internal.JsUtils;
import javaemul.internal.NativeArray;
import jsinterop.annotations.JsType;

public class ArrayHelper {
    public static final int ARRAY_PROCESS_BATCH_SIZE = 10000;

    public static <T> T[] clone(T[] array, int fromIndex, int toIndex) {
        Object[] result = ArrayHelper.unsafeClone(array, fromIndex, toIndex);
        return ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static Object[] unsafeClone(Object array, int fromIndex, int toIndex) {
        return ArrayHelper.asNativeArray(array).slice(fromIndex, toIndex);
    }

    public static <T> T[] createFrom(T[] array, int length) {
        return ArrayStamper.stampJavaTypeInfo(new NativeArray(length), array);
    }

    public static int getLength(Object array) {
        return ArrayHelper.asNativeArray((Object)array).length;
    }

    public static void setLength(Object array, int length) {
        ArrayHelper.asNativeArray((Object)array).length = length;
    }

    public static void removeFrom(Object array, int index, int deleteCount) {
        ArrayHelper.asNativeArray(array).splice(index, deleteCount, new Object[0]);
    }

    public static void insertTo(Object array, int index, Object value) {
        ArrayHelper.asNativeArray(array).splice(index, 0, value);
    }

    public static void insertTo(Object array, int index, Object[] values) {
        ArrayHelper.copy(values, 0, array, index, values.length, false);
    }

    public static void copy(Object array, int srcOfs, Object dest, int destOfs, int len) {
        ArrayHelper.copy(array, srcOfs, dest, destOfs, len, true);
    }

    private static void copy(Object src, int srcOfs, Object dest, int destOfs, int len, boolean overwrite) {
        if (src == dest) {
            src = ArrayHelper.unsafeClone(src, srcOfs, srcOfs + len);
            srcOfs = 0;
        }
        NativeArray destArray = ArrayHelper.asNativeArray(dest);
        int batchStart = srcOfs;
        int end = srcOfs + len;
        while (batchStart < end) {
            int batchEnd = Math.min(batchStart + 10000, end);
            len = batchEnd - batchStart;
            Object[] spliceArgs = ArrayHelper.unsafeClone(src, batchStart, batchEnd);
            ArrayHelper.asNativeArray(spliceArgs).splice(0, 0, destOfs, overwrite ? len : 0);
            ArrayHelper.getSpliceFunction().apply(destArray, spliceArgs);
            batchStart = batchEnd;
            destOfs += len;
        }
    }

    private static NativeFunction getSpliceFunction() {
        throw new RuntimeException("Cannot call native method");
    }

    public static NativeArray asNativeArray(Object array) {
        return (NativeArray)JsUtils.uncheckedCast(array);
    }

    @JsType(isNative=true, name="Function", namespace="<global>")
    private static class NativeFunction {
        private NativeFunction() {
        }

        public String apply(Object object, Object[] objectArray) {
            throw new RuntimeException("Cannot call native method");
        }
    }
}

