// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * This statement creates a user-defined function:
 *   CREATE [TEMP] FUNCTION [IF NOT EXISTS] &lt;name_path&gt; (&lt;arg_list&gt;)
 *     [RETURNS &lt;return_type&gt;] [SQL SECURITY &lt;sql_security&gt;]
 *     [&lt;determinism_level&gt;]
 *     [[LANGUAGE &lt;language&gt;] [AS &lt;code&gt; | AS ( &lt;function_expression&gt; )]
 *      | REMOTE [WITH CONNECTION &lt;connection&gt;]]
 *     [OPTIONS (&lt;option_list&gt;)]
 *   &lt;name_path&gt; is the identifier path of the function.
 *   &lt;has_explicit_return_type&gt; is true iff RETURNS clause is present.
 *   &lt;return_type&gt; is the return type for the function, which can be any
 *          valid ZetaSQL type, including ARRAY or STRUCT. It is inferred
 *          from &lt;function_expression&gt; if not explicitly set.
 *          TODO: Deprecate and remove this. The return type is
 *          already specified by the &lt;signature&gt;.
 *   &lt;argument_name_list&gt; The names of the function arguments.
 *   &lt;signature&gt; is the FunctionSignature of the created function, with all
 *          options.  This can be used to create a Function to load into a
 *          Catalog for future queries.
 *   &lt;is_aggregate&gt; is true if this is an aggregate function.  All arguments
 *          are assumed to be aggregate input arguments that may vary for
 *          every row.
 *   &lt;language&gt; is the programming language used by the function. This field
 *          is set to 'SQL' for SQL functions and 'REMOTE' for remote
 *          functions and otherwise to the language name specified in the
 *          LANGUAGE clause. This field is set to 'REMOTE' iff &lt;is_remote&gt; is
 *          set to true.
 *   &lt;code&gt; is a string literal that contains the function definition.  Some
 *          engines may allow this argument to be omitted for certain types
 *          of external functions. This will always be set for SQL functions.
 *   &lt;aggregate_expression_list&gt; is a list of SQL aggregate functions to
 *          compute prior to computing the final &lt;function_expression&gt;.
 *          See below.
 *   &lt;function_expression&gt; is the resolved SQL expression invoked for the
 *          function. This will be unset for external language functions. For
 *          non-template SQL functions, this is a resolved representation of
 *          the expression in &lt;code&gt;.
 *   &lt;option_list&gt; has engine-specific directives for modifying functions.
 *   &lt;sql_security&gt; is the declared security mode for the function. Values
 *          include 'INVOKER', 'DEFINER'.
 *   &lt;determinism_level&gt; is the declared determinism level of the function.
 *          Values are 'DETERMINISTIC', 'NOT DETERMINISTIC', 'IMMUTABLE',
 *          'STABLE', 'VOLATILE'.
 *   &lt;is_remote&gt; is true if this is an remote function. It is true iff its
 *          &lt;language&gt; is set to 'REMOTE'.
 *   &lt;connection&gt; is the identifier path of the connection object. It can be
 *          only set when &lt;is_remote&gt; is true.
 * Note that &lt;function_expression&gt; and &lt;code&gt; are both marked as IGNORABLE
 * because an engine could look at either one (but might not look at both).
 * An engine must look at one (and cannot ignore both, unless the function is
 * remote) to be semantically valid, but there is currently no way to enforce
 * that.
 * For aggregate functions, &lt;is_aggregate&gt; will be true.
 * Aggregate functions will only occur if LanguageOptions has
 * FEATURE_CREATE_AGGREGATE_FUNCTION enabled.
 * Arguments to aggregate functions must have
 * &lt;FunctionSignatureArgumentTypeOptions::is_not_aggregate&gt; true or false.
 * Non-aggregate arguments must be passed constant values only.
 * For SQL aggregate functions, there will be both an
 * &lt;aggregate_expression_list&gt;, with aggregate expressions to compute first,
 * and then a final &lt;function_expression&gt; to compute on the results
 * of the aggregates.  Each aggregate expression is a
 * ResolvedAggregateFunctionCall, and may reference any input arguments.
 * Each ResolvedComputedColumn in &lt;aggregate_expression_list&gt; gives the
 * aggregate expression a column id.  The final &lt;function_expression&gt; can
 * reference these created aggregate columns, and any input arguments
 * with &lt;argument_kind&gt;=NOT_AGGREGATE.
 * For example, with
 *   CREATE TEMP FUNCTION my_avg(x) = (SUM(x) / COUNT(x));
 * we would have an &lt;aggregate_expression_list&gt; with
 *   agg1#1 := SUM(ResolvedArgumentRef(x))
 *   agg2#2 := COUNT(ResolvedArgumentRef(x))
 * and a &lt;function_expression&gt;
 *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2)
 * For example, with
 *   CREATE FUNCTION scaled_avg(x,y NOT AGGREGATE) = (SUM(x) / COUNT(x) * y);
 * we would have an &lt;aggregate_expression_list&gt; with
 *   agg1#1 := SUM(ResolvedArgumentRef(x))
 *   agg2#2 := COUNT(ResolvedArgumentRef(x))
 * and a &lt;function_expression&gt;
 *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2) * ResolvedArgumentRef(y)
 * When resolving a query that calls an aggregate UDF, the query will
 * have a ResolvedAggregateScan that invokes the UDF function.  The engine
 * should remove the UDF aggregate function from the &lt;aggregate_list&gt;, and
 * instead compute the additional aggregates from the
 * UDF's &lt;aggregate_expression_list&gt;, and then add an additional Project
 * to compute the final &lt;function_expression&gt;, which should produce the
 * value for the original ResolvedAggregateScan's computed column for the
 * UDF.  Some rewrites of the ResolvedColumn references inside the UDF will
 * be required.  TODO If using ResolvedColumns makes this renaming
 * too complicated, we could switch to use ResolvedArgumentRefs, or
 * something new.
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedCreateFunctionStmtProto}
 */
public final class ResolvedCreateFunctionStmtProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedCreateFunctionStmtProto)
    ResolvedCreateFunctionStmtProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedCreateFunctionStmtProto.newBuilder() to construct.
  private ResolvedCreateFunctionStmtProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedCreateFunctionStmtProto() {
    argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    language_ = "";
    code_ = "";
    aggregateExpressionList_ = java.util.Collections.emptyList();
    optionList_ = java.util.Collections.emptyList();
    sqlSecurity_ = 0;
    determinismLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ResolvedCreateFunctionStmtProto();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedCreateFunctionStmtProto.class, com.google.zetasql.ResolvedCreateFunctionStmtProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedCreateStatementProto parent_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   * @return Whether the parent field is set.
   */
  @java.lang.Override
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   * @return The parent.
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedCreateStatementProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }

  public static final int HAS_EXPLICIT_RETURN_TYPE_FIELD_NUMBER = 13;
  private boolean hasExplicitReturnType_;
  /**
   * <code>optional bool has_explicit_return_type = 13;</code>
   * @return Whether the hasExplicitReturnType field is set.
   */
  @java.lang.Override
  public boolean hasHasExplicitReturnType() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional bool has_explicit_return_type = 13;</code>
   * @return The hasExplicitReturnType.
   */
  @java.lang.Override
  public boolean getHasExplicitReturnType() {
    return hasExplicitReturnType_;
  }

  public static final int RETURN_TYPE_FIELD_NUMBER = 3;
  private com.google.zetasql.ZetaSQLType.TypeProto returnType_;
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   * @return Whether the returnType field is set.
   */
  @java.lang.Override
  public boolean hasReturnType() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   * @return The returnType.
   */
  @java.lang.Override
  public com.google.zetasql.ZetaSQLType.TypeProto getReturnType() {
    return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
  }
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder getReturnTypeOrBuilder() {
    return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
  }

  public static final int ARGUMENT_NAME_LIST_FIELD_NUMBER = 11;
  private com.google.protobuf.LazyStringList argumentNameList_;
  /**
   * <code>repeated string argument_name_list = 11;</code>
   * @return A list containing the argumentNameList.
   */
  public com.google.protobuf.ProtocolStringList
      getArgumentNameListList() {
    return argumentNameList_;
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   * @return The count of argumentNameList.
   */
  public int getArgumentNameListCount() {
    return argumentNameList_.size();
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   * @param index The index of the element to return.
   * @return The argumentNameList at the given index.
   */
  public java.lang.String getArgumentNameList(int index) {
    return argumentNameList_.get(index);
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   * @param index The index of the value to return.
   * @return The bytes of the argumentNameList at the given index.
   */
  public com.google.protobuf.ByteString
      getArgumentNameListBytes(int index) {
    return argumentNameList_.getByteString(index);
  }

  public static final int SIGNATURE_FIELD_NUMBER = 10;
  private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_;
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   * @return Whether the signature field is set.
   */
  @java.lang.Override
  public boolean hasSignature() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   * @return The signature.
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }

  public static final int IS_AGGREGATE_FIELD_NUMBER = 8;
  private boolean isAggregate_;
  /**
   * <code>optional bool is_aggregate = 8;</code>
   * @return Whether the isAggregate field is set.
   */
  @java.lang.Override
  public boolean hasIsAggregate() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <code>optional bool is_aggregate = 8;</code>
   * @return The isAggregate.
   */
  @java.lang.Override
  public boolean getIsAggregate() {
    return isAggregate_;
  }

  public static final int LANGUAGE_FIELD_NUMBER = 4;
  private volatile java.lang.Object language_;
  /**
   * <code>optional string language = 4;</code>
   * @return Whether the language field is set.
   */
  @java.lang.Override
  public boolean hasLanguage() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <code>optional string language = 4;</code>
   * @return The language.
   */
  @java.lang.Override
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        language_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string language = 4;</code>
   * @return The bytes for language.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_FIELD_NUMBER = 5;
  private volatile java.lang.Object code_;
  /**
   * <code>optional string code = 5;</code>
   * @return Whether the code field is set.
   */
  @java.lang.Override
  public boolean hasCode() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <code>optional string code = 5;</code>
   * @return The code.
   */
  @java.lang.Override
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        code_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string code = 5;</code>
   * @return The bytes for code.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGGREGATE_EXPRESSION_LIST_FIELD_NUMBER = 9;
  private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> aggregateExpressionList_;
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getAggregateExpressionListList() {
    return aggregateExpressionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
      getAggregateExpressionListOrBuilderList() {
    return aggregateExpressionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  @java.lang.Override
  public int getAggregateExpressionListCount() {
    return aggregateExpressionList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedComputedColumnProto getAggregateExpressionList(int index) {
    return aggregateExpressionList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getAggregateExpressionListOrBuilder(
      int index) {
    return aggregateExpressionList_.get(index);
  }

  public static final int FUNCTION_EXPRESSION_FIELD_NUMBER = 6;
  private com.google.zetasql.AnyResolvedExprProto functionExpression_;
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   * @return Whether the functionExpression field is set.
   */
  @java.lang.Override
  public boolean hasFunctionExpression() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   * @return The functionExpression.
   */
  @java.lang.Override
  public com.google.zetasql.AnyResolvedExprProto getFunctionExpression() {
    return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
  }
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   */
  @java.lang.Override
  public com.google.zetasql.AnyResolvedExprProtoOrBuilder getFunctionExpressionOrBuilder() {
    return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
  }

  public static final int OPTION_LIST_FIELD_NUMBER = 7;
  private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_;
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
      getOptionListOrBuilderList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  @java.lang.Override
  public int getOptionListCount() {
    return optionList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
    return optionList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
      int index) {
    return optionList_.get(index);
  }

  public static final int SQL_SECURITY_FIELD_NUMBER = 12;
  private int sqlSecurity_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
   * @return Whether the sqlSecurity field is set.
   */
  @java.lang.Override public boolean hasSqlSecurity() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
   * @return The sqlSecurity.
   */
  @java.lang.Override public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
    @SuppressWarnings("deprecation")
    com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
    return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
  }

  public static final int DETERMINISM_LEVEL_FIELD_NUMBER = 14;
  private int determinismLevel_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
   * @return Whether the determinismLevel field is set.
   */
  @java.lang.Override public boolean hasDeterminismLevel() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
   * @return The determinismLevel.
   */
  @java.lang.Override public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel getDeterminismLevel() {
    @SuppressWarnings("deprecation")
    com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel.valueOf(determinismLevel_);
    return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel.DETERMINISM_UNSPECIFIED : result;
  }

  public static final int IS_REMOTE_FIELD_NUMBER = 15;
  private boolean isRemote_;
  /**
   * <code>optional bool is_remote = 15;</code>
   * @return Whether the isRemote field is set.
   */
  @java.lang.Override
  public boolean hasIsRemote() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <code>optional bool is_remote = 15;</code>
   * @return The isRemote.
   */
  @java.lang.Override
  public boolean getIsRemote() {
    return isRemote_;
  }

  public static final int CONNECTION_FIELD_NUMBER = 16;
  private com.google.zetasql.ResolvedConnectionProto connection_;
  /**
   * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
   * @return Whether the connection field is set.
   */
  @java.lang.Override
  public boolean hasConnection() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
   * @return The connection.
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedConnectionProto getConnection() {
    return connection_ == null ? com.google.zetasql.ResolvedConnectionProto.getDefaultInstance() : connection_;
  }
  /**
   * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedConnectionProtoOrBuilder getConnectionOrBuilder() {
    return connection_ == null ? com.google.zetasql.ResolvedConnectionProto.getDefaultInstance() : connection_;
  }

  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedCreateFunctionStmtProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This statement creates a user-defined function:
   *   CREATE [TEMP] FUNCTION [IF NOT EXISTS] &lt;name_path&gt; (&lt;arg_list&gt;)
   *     [RETURNS &lt;return_type&gt;] [SQL SECURITY &lt;sql_security&gt;]
   *     [&lt;determinism_level&gt;]
   *     [[LANGUAGE &lt;language&gt;] [AS &lt;code&gt; | AS ( &lt;function_expression&gt; )]
   *      | REMOTE [WITH CONNECTION &lt;connection&gt;]]
   *     [OPTIONS (&lt;option_list&gt;)]
   *   &lt;name_path&gt; is the identifier path of the function.
   *   &lt;has_explicit_return_type&gt; is true iff RETURNS clause is present.
   *   &lt;return_type&gt; is the return type for the function, which can be any
   *          valid ZetaSQL type, including ARRAY or STRUCT. It is inferred
   *          from &lt;function_expression&gt; if not explicitly set.
   *          TODO: Deprecate and remove this. The return type is
   *          already specified by the &lt;signature&gt;.
   *   &lt;argument_name_list&gt; The names of the function arguments.
   *   &lt;signature&gt; is the FunctionSignature of the created function, with all
   *          options.  This can be used to create a Function to load into a
   *          Catalog for future queries.
   *   &lt;is_aggregate&gt; is true if this is an aggregate function.  All arguments
   *          are assumed to be aggregate input arguments that may vary for
   *          every row.
   *   &lt;language&gt; is the programming language used by the function. This field
   *          is set to 'SQL' for SQL functions and 'REMOTE' for remote
   *          functions and otherwise to the language name specified in the
   *          LANGUAGE clause. This field is set to 'REMOTE' iff &lt;is_remote&gt; is
   *          set to true.
   *   &lt;code&gt; is a string literal that contains the function definition.  Some
   *          engines may allow this argument to be omitted for certain types
   *          of external functions. This will always be set for SQL functions.
   *   &lt;aggregate_expression_list&gt; is a list of SQL aggregate functions to
   *          compute prior to computing the final &lt;function_expression&gt;.
   *          See below.
   *   &lt;function_expression&gt; is the resolved SQL expression invoked for the
   *          function. This will be unset for external language functions. For
   *          non-template SQL functions, this is a resolved representation of
   *          the expression in &lt;code&gt;.
   *   &lt;option_list&gt; has engine-specific directives for modifying functions.
   *   &lt;sql_security&gt; is the declared security mode for the function. Values
   *          include 'INVOKER', 'DEFINER'.
   *   &lt;determinism_level&gt; is the declared determinism level of the function.
   *          Values are 'DETERMINISTIC', 'NOT DETERMINISTIC', 'IMMUTABLE',
   *          'STABLE', 'VOLATILE'.
   *   &lt;is_remote&gt; is true if this is an remote function. It is true iff its
   *          &lt;language&gt; is set to 'REMOTE'.
   *   &lt;connection&gt; is the identifier path of the connection object. It can be
   *          only set when &lt;is_remote&gt; is true.
   * Note that &lt;function_expression&gt; and &lt;code&gt; are both marked as IGNORABLE
   * because an engine could look at either one (but might not look at both).
   * An engine must look at one (and cannot ignore both, unless the function is
   * remote) to be semantically valid, but there is currently no way to enforce
   * that.
   * For aggregate functions, &lt;is_aggregate&gt; will be true.
   * Aggregate functions will only occur if LanguageOptions has
   * FEATURE_CREATE_AGGREGATE_FUNCTION enabled.
   * Arguments to aggregate functions must have
   * &lt;FunctionSignatureArgumentTypeOptions::is_not_aggregate&gt; true or false.
   * Non-aggregate arguments must be passed constant values only.
   * For SQL aggregate functions, there will be both an
   * &lt;aggregate_expression_list&gt;, with aggregate expressions to compute first,
   * and then a final &lt;function_expression&gt; to compute on the results
   * of the aggregates.  Each aggregate expression is a
   * ResolvedAggregateFunctionCall, and may reference any input arguments.
   * Each ResolvedComputedColumn in &lt;aggregate_expression_list&gt; gives the
   * aggregate expression a column id.  The final &lt;function_expression&gt; can
   * reference these created aggregate columns, and any input arguments
   * with &lt;argument_kind&gt;=NOT_AGGREGATE.
   * For example, with
   *   CREATE TEMP FUNCTION my_avg(x) = (SUM(x) / COUNT(x));
   * we would have an &lt;aggregate_expression_list&gt; with
   *   agg1#1 := SUM(ResolvedArgumentRef(x))
   *   agg2#2 := COUNT(ResolvedArgumentRef(x))
   * and a &lt;function_expression&gt;
   *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2)
   * For example, with
   *   CREATE FUNCTION scaled_avg(x,y NOT AGGREGATE) = (SUM(x) / COUNT(x) * y);
   * we would have an &lt;aggregate_expression_list&gt; with
   *   agg1#1 := SUM(ResolvedArgumentRef(x))
   *   agg2#2 := COUNT(ResolvedArgumentRef(x))
   * and a &lt;function_expression&gt;
   *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2) * ResolvedArgumentRef(y)
   * When resolving a query that calls an aggregate UDF, the query will
   * have a ResolvedAggregateScan that invokes the UDF function.  The engine
   * should remove the UDF aggregate function from the &lt;aggregate_list&gt;, and
   * instead compute the additional aggregates from the
   * UDF's &lt;aggregate_expression_list&gt;, and then add an additional Project
   * to compute the final &lt;function_expression&gt;, which should produce the
   * value for the original ResolvedAggregateScan's computed column for the
   * UDF.  Some rewrites of the ResolvedColumn references inside the UDF will
   * be required.  TODO If using ResolvedColumns makes this renaming
   * too complicated, we could switch to use ResolvedArgumentRefs, or
   * something new.
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedCreateFunctionStmtProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedCreateFunctionStmtProto)
      com.google.zetasql.ResolvedCreateFunctionStmtProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedCreateFunctionStmtProto.class, com.google.zetasql.ResolvedCreateFunctionStmtProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedCreateFunctionStmtProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getReturnTypeFieldBuilder();
        getSignatureFieldBuilder();
        getAggregateExpressionListFieldBuilder();
        getFunctionExpressionFieldBuilder();
        getOptionListFieldBuilder();
        getConnectionFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      hasExplicitReturnType_ = false;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (returnTypeBuilder_ == null) {
        returnType_ = null;
      } else {
        returnTypeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      if (signatureBuilder_ == null) {
        signature_ = null;
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      isAggregate_ = false;
      bitField0_ = (bitField0_ & ~0x00000020);
      language_ = "";
      bitField0_ = (bitField0_ & ~0x00000040);
      code_ = "";
      bitField0_ = (bitField0_ & ~0x00000080);
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
      } else {
        aggregateExpressionListBuilder_.clear();
      }
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = null;
      } else {
        functionExpressionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
      } else {
        optionListBuilder_.clear();
      }
      sqlSecurity_ = 0;
      bitField0_ = (bitField0_ & ~0x00000800);
      determinismLevel_ = 0;
      bitField0_ = (bitField0_ & ~0x00001000);
      isRemote_ = false;
      bitField0_ = (bitField0_ & ~0x00002000);
      if (connectionBuilder_ == null) {
        connection_ = null;
      } else {
        connectionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedCreateFunctionStmtProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto build() {
      com.google.zetasql.ResolvedCreateFunctionStmtProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto buildPartial() {
      com.google.zetasql.ResolvedCreateFunctionStmtProto result = new com.google.zetasql.ResolvedCreateFunctionStmtProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        if (parentBuilder_ == null) {
          result.parent_ = parent_;
        } else {
          result.parent_ = parentBuilder_.build();
        }
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.hasExplicitReturnType_ = hasExplicitReturnType_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        if (returnTypeBuilder_ == null) {
          result.returnType_ = returnType_;
        } else {
          result.returnType_ = returnTypeBuilder_.build();
        }
        to_bitField0_ |= 0x00000004;
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        argumentNameList_ = argumentNameList_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.argumentNameList_ = argumentNameList_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        if (signatureBuilder_ == null) {
          result.signature_ = signature_;
        } else {
          result.signature_ = signatureBuilder_.build();
        }
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.isAggregate_ = isAggregate_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        to_bitField0_ |= 0x00000020;
      }
      result.language_ = language_;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        to_bitField0_ |= 0x00000040;
      }
      result.code_ = code_;
      if (aggregateExpressionListBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          aggregateExpressionList_ = java.util.Collections.unmodifiableList(aggregateExpressionList_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.aggregateExpressionList_ = aggregateExpressionList_;
      } else {
        result.aggregateExpressionList_ = aggregateExpressionListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        if (functionExpressionBuilder_ == null) {
          result.functionExpression_ = functionExpression_;
        } else {
          result.functionExpression_ = functionExpressionBuilder_.build();
        }
        to_bitField0_ |= 0x00000080;
      }
      if (optionListBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          optionList_ = java.util.Collections.unmodifiableList(optionList_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.optionList_ = optionList_;
      } else {
        result.optionList_ = optionListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        to_bitField0_ |= 0x00000100;
      }
      result.sqlSecurity_ = sqlSecurity_;
      if (((from_bitField0_ & 0x00001000) != 0)) {
        to_bitField0_ |= 0x00000200;
      }
      result.determinismLevel_ = determinismLevel_;
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.isRemote_ = isRemote_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        if (connectionBuilder_ == null) {
          result.connection_ = connection_;
        } else {
          result.connection_ = connectionBuilder_.build();
        }
        to_bitField0_ |= 0x00000800;
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedCreateStatementProto parent_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     * @return Whether the parent field is set.
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     * @return The parent.
     */
    public com.google.zetasql.ResolvedCreateStatementProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedCreateStatementProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedCreateStatementProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private boolean hasExplicitReturnType_ ;
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     * @return Whether the hasExplicitReturnType field is set.
     */
    @java.lang.Override
    public boolean hasHasExplicitReturnType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     * @return The hasExplicitReturnType.
     */
    @java.lang.Override
    public boolean getHasExplicitReturnType() {
      return hasExplicitReturnType_;
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     * @param value The hasExplicitReturnType to set.
     * @return This builder for chaining.
     */
    public Builder setHasExplicitReturnType(boolean value) {
      bitField0_ |= 0x00000002;
      hasExplicitReturnType_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     * @return This builder for chaining.
     */
    public Builder clearHasExplicitReturnType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      hasExplicitReturnType_ = false;
      onChanged();
      return this;
    }

    private com.google.zetasql.ZetaSQLType.TypeProto returnType_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder> returnTypeBuilder_;
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     * @return Whether the returnType field is set.
     */
    public boolean hasReturnType() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     * @return The returnType.
     */
    public com.google.zetasql.ZetaSQLType.TypeProto getReturnType() {
      if (returnTypeBuilder_ == null) {
        return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
      } else {
        return returnTypeBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder setReturnType(com.google.zetasql.ZetaSQLType.TypeProto value) {
      if (returnTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        returnType_ = value;
        onChanged();
      } else {
        returnTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder setReturnType(
        com.google.zetasql.ZetaSQLType.TypeProto.Builder builderForValue) {
      if (returnTypeBuilder_ == null) {
        returnType_ = builderForValue.build();
        onChanged();
      } else {
        returnTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder mergeReturnType(com.google.zetasql.ZetaSQLType.TypeProto value) {
      if (returnTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0) &&
            returnType_ != null &&
            returnType_ != com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance()) {
          returnType_ =
            com.google.zetasql.ZetaSQLType.TypeProto.newBuilder(returnType_).mergeFrom(value).buildPartial();
        } else {
          returnType_ = value;
        }
        onChanged();
      } else {
        returnTypeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder clearReturnType() {
      if (returnTypeBuilder_ == null) {
        returnType_ = null;
        onChanged();
      } else {
        returnTypeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public com.google.zetasql.ZetaSQLType.TypeProto.Builder getReturnTypeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReturnTypeFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder getReturnTypeOrBuilder() {
      if (returnTypeBuilder_ != null) {
        return returnTypeBuilder_.getMessageOrBuilder();
      } else {
        return returnType_ == null ?
            com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
      }
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder> 
        getReturnTypeFieldBuilder() {
      if (returnTypeBuilder_ == null) {
        returnTypeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder>(
                getReturnType(),
                getParentForChildren(),
                isClean());
        returnType_ = null;
      }
      return returnTypeBuilder_;
    }

    private com.google.protobuf.LazyStringList argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureArgumentNameListIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        argumentNameList_ = new com.google.protobuf.LazyStringArrayList(argumentNameList_);
        bitField0_ |= 0x00000008;
       }
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @return A list containing the argumentNameList.
     */
    public com.google.protobuf.ProtocolStringList
        getArgumentNameListList() {
      return argumentNameList_.getUnmodifiableView();
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @return The count of argumentNameList.
     */
    public int getArgumentNameListCount() {
      return argumentNameList_.size();
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param index The index of the element to return.
     * @return The argumentNameList at the given index.
     */
    public java.lang.String getArgumentNameList(int index) {
      return argumentNameList_.get(index);
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param index The index of the value to return.
     * @return The bytes of the argumentNameList at the given index.
     */
    public com.google.protobuf.ByteString
        getArgumentNameListBytes(int index) {
      return argumentNameList_.getByteString(index);
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param index The index to set the value at.
     * @param value The argumentNameList to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentNameList(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param value The argumentNameList to add.
     * @return This builder for chaining.
     */
    public Builder addArgumentNameList(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param values The argumentNameList to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgumentNameList(
        java.lang.Iterable<java.lang.String> values) {
      ensureArgumentNameListIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, argumentNameList_);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearArgumentNameList() {
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     * @param value The bytes of the argumentNameList to add.
     * @return This builder for chaining.
     */
    public Builder addArgumentNameListBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }

    private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> signatureBuilder_;
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     * @return Whether the signature field is set.
     */
    public boolean hasSignature() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     * @return The signature.
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
      if (signatureBuilder_ == null) {
        return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      } else {
        return signatureBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder setSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signature_ = value;
        onChanged();
      } else {
        signatureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder setSignature(
        com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder builderForValue) {
      if (signatureBuilder_ == null) {
        signature_ = builderForValue.build();
        onChanged();
      } else {
        signatureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder mergeSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0) &&
            signature_ != null &&
            signature_ != com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance()) {
          signature_ =
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.newBuilder(signature_).mergeFrom(value).buildPartial();
        } else {
          signature_ = value;
        }
        onChanged();
      } else {
        signatureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder clearSignature() {
      if (signatureBuilder_ == null) {
        signature_ = null;
        onChanged();
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder getSignatureBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSignatureFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
      if (signatureBuilder_ != null) {
        return signatureBuilder_.getMessageOrBuilder();
      } else {
        return signature_ == null ?
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> 
        getSignatureFieldBuilder() {
      if (signatureBuilder_ == null) {
        signatureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder>(
                getSignature(),
                getParentForChildren(),
                isClean());
        signature_ = null;
      }
      return signatureBuilder_;
    }

    private boolean isAggregate_ ;
    /**
     * <code>optional bool is_aggregate = 8;</code>
     * @return Whether the isAggregate field is set.
     */
    @java.lang.Override
    public boolean hasIsAggregate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     * @return The isAggregate.
     */
    @java.lang.Override
    public boolean getIsAggregate() {
      return isAggregate_;
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     * @param value The isAggregate to set.
     * @return This builder for chaining.
     */
    public Builder setIsAggregate(boolean value) {
      bitField0_ |= 0x00000020;
      isAggregate_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearIsAggregate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      isAggregate_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object language_ = "";
    /**
     * <code>optional string language = 4;</code>
     * @return Whether the language field is set.
     */
    public boolean hasLanguage() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional string language = 4;</code>
     * @return The language.
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          language_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string language = 4;</code>
     * @return The bytes for language.
     */
    public com.google.protobuf.ByteString
        getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string language = 4;</code>
     * @param value The language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguage(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
      language_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearLanguage() {
      bitField0_ = (bitField0_ & ~0x00000040);
      language_ = getDefaultInstance().getLanguage();
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 4;</code>
     * @param value The bytes for language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
      language_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     * <code>optional string code = 5;</code>
     * @return Whether the code field is set.
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional string code = 5;</code>
     * @return The code.
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          code_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string code = 5;</code>
     * @return The bytes for code.
     */
    public com.google.protobuf.ByteString
        getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string code = 5;</code>
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
      code_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000080);
      code_ = getDefaultInstance().getCode();
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 5;</code>
     * @param value The bytes for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
      code_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> aggregateExpressionList_ =
      java.util.Collections.emptyList();
    private void ensureAggregateExpressionListIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        aggregateExpressionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedComputedColumnProto>(aggregateExpressionList_);
        bitField0_ |= 0x00000100;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> aggregateExpressionListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getAggregateExpressionListList() {
      if (aggregateExpressionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregateExpressionList_);
      } else {
        return aggregateExpressionListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public int getAggregateExpressionListCount() {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.size();
      } else {
        return aggregateExpressionListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto getAggregateExpressionList(int index) {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.get(index);
      } else {
        return aggregateExpressionListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder setAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.set(index, value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder setAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(index, value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAllAggregateExpressionList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedComputedColumnProto> values) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, aggregateExpressionList_);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder clearAggregateExpressionList() {
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder removeAggregateExpressionList(int index) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.remove(index);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder getAggregateExpressionListBuilder(
        int index) {
      return getAggregateExpressionListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getAggregateExpressionListOrBuilder(
        int index) {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.get(index);  } else {
        return aggregateExpressionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
         getAggregateExpressionListOrBuilderList() {
      if (aggregateExpressionListBuilder_ != null) {
        return aggregateExpressionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregateExpressionList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addAggregateExpressionListBuilder() {
      return getAggregateExpressionListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addAggregateExpressionListBuilder(
        int index) {
      return getAggregateExpressionListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto.Builder> 
         getAggregateExpressionListBuilderList() {
      return getAggregateExpressionListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
        getAggregateExpressionListFieldBuilder() {
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder>(
                aggregateExpressionList_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        aggregateExpressionList_ = null;
      }
      return aggregateExpressionListBuilder_;
    }

    private com.google.zetasql.AnyResolvedExprProto functionExpression_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> functionExpressionBuilder_;
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     * @return Whether the functionExpression field is set.
     */
    public boolean hasFunctionExpression() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     * @return The functionExpression.
     */
    public com.google.zetasql.AnyResolvedExprProto getFunctionExpression() {
      if (functionExpressionBuilder_ == null) {
        return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
      } else {
        return functionExpressionBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder setFunctionExpression(com.google.zetasql.AnyResolvedExprProto value) {
      if (functionExpressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        functionExpression_ = value;
        onChanged();
      } else {
        functionExpressionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder setFunctionExpression(
        com.google.zetasql.AnyResolvedExprProto.Builder builderForValue) {
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = builderForValue.build();
        onChanged();
      } else {
        functionExpressionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder mergeFunctionExpression(com.google.zetasql.AnyResolvedExprProto value) {
      if (functionExpressionBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0) &&
            functionExpression_ != null &&
            functionExpression_ != com.google.zetasql.AnyResolvedExprProto.getDefaultInstance()) {
          functionExpression_ =
            com.google.zetasql.AnyResolvedExprProto.newBuilder(functionExpression_).mergeFrom(value).buildPartial();
        } else {
          functionExpression_ = value;
        }
        onChanged();
      } else {
        functionExpressionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder clearFunctionExpression() {
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = null;
        onChanged();
      } else {
        functionExpressionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto.Builder getFunctionExpressionBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFunctionExpressionFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public com.google.zetasql.AnyResolvedExprProtoOrBuilder getFunctionExpressionOrBuilder() {
      if (functionExpressionBuilder_ != null) {
        return functionExpressionBuilder_.getMessageOrBuilder();
      } else {
        return functionExpression_ == null ?
            com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> 
        getFunctionExpressionFieldBuilder() {
      if (functionExpressionBuilder_ == null) {
        functionExpressionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder>(
                getFunctionExpression(),
                getParentForChildren(),
                isClean());
        functionExpression_ = null;
      }
      return functionExpressionBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_ =
      java.util.Collections.emptyList();
    private void ensureOptionListIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        optionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>(optionList_);
        bitField0_ |= 0x00000400;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> optionListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
      if (optionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(optionList_);
      } else {
        return optionListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public int getOptionListCount() {
      if (optionListBuilder_ == null) {
        return optionList_.size();
      } else {
        return optionListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);
      } else {
        return optionListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.set(index, value);
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(index, value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addAllOptionList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedOptionProto> values) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, optionList_);
        onChanged();
      } else {
        optionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder clearOptionList() {
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        optionListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder removeOptionList(int index) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.remove(index);
        onChanged();
      } else {
        optionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder getOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
        int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);  } else {
        return optionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
         getOptionListOrBuilderList() {
      if (optionListBuilder_ != null) {
        return optionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(optionList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder() {
      return getOptionListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto.Builder> 
         getOptionListBuilderList() {
      return getOptionListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> 
        getOptionListFieldBuilder() {
      if (optionListBuilder_ == null) {
        optionListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder>(
                optionList_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        optionList_ = null;
      }
      return optionListBuilder_;
    }

    private int sqlSecurity_ = 0;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     * @return Whether the sqlSecurity field is set.
     */
    @java.lang.Override public boolean hasSqlSecurity() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     * @return The sqlSecurity.
     */
    @java.lang.Override
    public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
      @SuppressWarnings("deprecation")
      com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
      return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     * @param value The sqlSecurity to set.
     * @return This builder for chaining.
     */
    public Builder setSqlSecurity(com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      sqlSecurity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     * @return This builder for chaining.
     */
    public Builder clearSqlSecurity() {
      bitField0_ = (bitField0_ & ~0x00000800);
      sqlSecurity_ = 0;
      onChanged();
      return this;
    }

    private int determinismLevel_ = 0;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
     * @return Whether the determinismLevel field is set.
     */
    @java.lang.Override public boolean hasDeterminismLevel() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
     * @return The determinismLevel.
     */
    @java.lang.Override
    public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel getDeterminismLevel() {
      @SuppressWarnings("deprecation")
      com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel.valueOf(determinismLevel_);
      return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel.DETERMINISM_UNSPECIFIED : result;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
     * @param value The determinismLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDeterminismLevel(com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.DeterminismLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      determinismLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.DeterminismLevel determinism_level = 14;</code>
     * @return This builder for chaining.
     */
    public Builder clearDeterminismLevel() {
      bitField0_ = (bitField0_ & ~0x00001000);
      determinismLevel_ = 0;
      onChanged();
      return this;
    }

    private boolean isRemote_ ;
    /**
     * <code>optional bool is_remote = 15;</code>
     * @return Whether the isRemote field is set.
     */
    @java.lang.Override
    public boolean hasIsRemote() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <code>optional bool is_remote = 15;</code>
     * @return The isRemote.
     */
    @java.lang.Override
    public boolean getIsRemote() {
      return isRemote_;
    }
    /**
     * <code>optional bool is_remote = 15;</code>
     * @param value The isRemote to set.
     * @return This builder for chaining.
     */
    public Builder setIsRemote(boolean value) {
      bitField0_ |= 0x00002000;
      isRemote_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool is_remote = 15;</code>
     * @return This builder for chaining.
     */
    public Builder clearIsRemote() {
      bitField0_ = (bitField0_ & ~0x00002000);
      isRemote_ = false;
      onChanged();
      return this;
    }

    private com.google.zetasql.ResolvedConnectionProto connection_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedConnectionProto, com.google.zetasql.ResolvedConnectionProto.Builder, com.google.zetasql.ResolvedConnectionProtoOrBuilder> connectionBuilder_;
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     * @return Whether the connection field is set.
     */
    public boolean hasConnection() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     * @return The connection.
     */
    public com.google.zetasql.ResolvedConnectionProto getConnection() {
      if (connectionBuilder_ == null) {
        return connection_ == null ? com.google.zetasql.ResolvedConnectionProto.getDefaultInstance() : connection_;
      } else {
        return connectionBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public Builder setConnection(com.google.zetasql.ResolvedConnectionProto value) {
      if (connectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connection_ = value;
        onChanged();
      } else {
        connectionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public Builder setConnection(
        com.google.zetasql.ResolvedConnectionProto.Builder builderForValue) {
      if (connectionBuilder_ == null) {
        connection_ = builderForValue.build();
        onChanged();
      } else {
        connectionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public Builder mergeConnection(com.google.zetasql.ResolvedConnectionProto value) {
      if (connectionBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0) &&
            connection_ != null &&
            connection_ != com.google.zetasql.ResolvedConnectionProto.getDefaultInstance()) {
          connection_ =
            com.google.zetasql.ResolvedConnectionProto.newBuilder(connection_).mergeFrom(value).buildPartial();
        } else {
          connection_ = value;
        }
        onChanged();
      } else {
        connectionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public Builder clearConnection() {
      if (connectionBuilder_ == null) {
        connection_ = null;
        onChanged();
      } else {
        connectionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public com.google.zetasql.ResolvedConnectionProto.Builder getConnectionBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getConnectionFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    public com.google.zetasql.ResolvedConnectionProtoOrBuilder getConnectionOrBuilder() {
      if (connectionBuilder_ != null) {
        return connectionBuilder_.getMessageOrBuilder();
      } else {
        return connection_ == null ?
            com.google.zetasql.ResolvedConnectionProto.getDefaultInstance() : connection_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedConnectionProto connection = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedConnectionProto, com.google.zetasql.ResolvedConnectionProto.Builder, com.google.zetasql.ResolvedConnectionProtoOrBuilder> 
        getConnectionFieldBuilder() {
      if (connectionBuilder_ == null) {
        connectionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedConnectionProto, com.google.zetasql.ResolvedConnectionProto.Builder, com.google.zetasql.ResolvedConnectionProtoOrBuilder>(
                getConnection(),
                getParentForChildren(),
                isClean());
        connection_ = null;
      }
      return connectionBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedCreateFunctionStmtProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedCreateFunctionStmtProto)
  private static final com.google.zetasql.ResolvedCreateFunctionStmtProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedCreateFunctionStmtProto();
  }

  public static com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedCreateFunctionStmtProto>() {
    @java.lang.Override
    public ResolvedCreateFunctionStmtProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(
                builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

