// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * This scan represents a call to a table-valued function (TVF). Each TVF
 * returns an entire output relation instead of a single scalar value. The
 * enclosing query may refer to the TVF as if it were a table subquery. The
 * TVF may accept scalar arguments and/or other input relations.
 * Scalar arguments work the same way as arguments for non-table-valued
 * functions: in the resolved AST, their types are equal to the required
 * argument types specified in the function signature.
 * The function signature may also include relation arguments, and any such
 * relation argument may specify a required schema. If such a required schema
 * is present, then in the resolved AST, the ResolvedScan for each relational
 * ResolvedFunctionArgument is guaranteed to have the same number of columns
 * as the required schema, and the provided columns match position-wise with
 * the required columns. Each provided column has the same name and type as
 * the corresponding required column.
 * If AnalyzerOptions::prune_unused_columns is true, the &lt;column_list&gt; and
 * &lt;column_index_list&gt; will include only columns that were referenced
 * in the user query. (SELECT * counts as referencing all columns.)
 * Pruning has no effect on value tables (the value is never pruned).
 * &lt;column_list&gt; is a set of new ResolvedColumns created by this scan.
 * The &lt;column_list&gt;[i] should be matched to the related TVFScan's output
 * relation column by
 * &lt;signature&gt;.result_schema().column(&lt;column_index_list&gt;[i]).
 * &lt;tvf&gt; The TableValuedFunction entry that the catalog returned for this TVF
 *       scan. Contains non-concrete function signatures which may include
 *       arguments with templated types.
 * &lt;signature&gt; The concrete table function signature for this TVF call,
 *             including the types of all scalar arguments and the
 *             number and types of columns of all table-valued
 *             arguments. An engine may also subclass this object to
 *             provide extra custom information and return an instance
 *             of the subclass from the TableValuedFunction::Resolve
 *             method.
 * &lt;argument_list&gt; The vector of resolved concrete arguments for this TVF
 *                 call, including the default values or NULLs injected for
 *                 the omitted arguments (Note the NULL injection is a
 *                 temporary solution to handle omitted named arguments. This
 *                 is subject to change by upcoming CLs).
 * &lt;column_index_list&gt; This list matches 1-1 with the &lt;column_list&gt;, and
 * identifies the index of the corresponding column in the &lt;signature&gt;'s
 * result relation column list.
 * &lt;alias&gt; The AS alias for the scan, or empty if none.
 * &lt;function_call_signature&gt; The FunctionSignature object from the
 *                           &lt;tvf-&gt;signatures()&gt; list that matched the
 *                           current call. The TVFScan's
 *                           &lt;FunctionSignature::ConcreteArgument&gt; list
 *                           matches 1:1 to &lt;argument_list&gt;, while its
 *                           &lt;FunctionSignature::arguments&gt; list still has
 *                           the full argument list.
 *                           The analyzer only sets this field when
 *                           it could be ambiguous for an engine to figure
 *                           out the actual arguments provided, e.g., when
 *                           there are arguments omitted from the call. When
 *                           it is provided, engines may use this object to
 *                           check for the argument names and omitted
 *                           arguments. SQLBuilder may also need this object
 *                           in cases when the named argument notation is
 *                           required for this call.
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedTVFScanProto}
 */
public final class ResolvedTVFScanProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedTVFScanProto)
    ResolvedTVFScanProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedTVFScanProto.newBuilder() to construct.
  private ResolvedTVFScanProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedTVFScanProto() {
    argumentList_ = java.util.Collections.emptyList();
    columnIndexList_ = emptyLongList();
    alias_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ResolvedTVFScanProto();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedTVFScanProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedTVFScanProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedTVFScanProto.class, com.google.zetasql.ResolvedTVFScanProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedScanProto parent_;
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   * @return Whether the parent field is set.
   */
  @java.lang.Override
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   * @return The parent.
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedScanProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedScanProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
  }

  public static final int TVF_FIELD_NUMBER = 2;
  private com.google.zetasql.TableValuedFunctionRefProto tvf_;
  /**
   * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
   * @return Whether the tvf field is set.
   */
  @java.lang.Override
  public boolean hasTvf() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
   * @return The tvf.
   */
  @java.lang.Override
  public com.google.zetasql.TableValuedFunctionRefProto getTvf() {
    return tvf_ == null ? com.google.zetasql.TableValuedFunctionRefProto.getDefaultInstance() : tvf_;
  }
  /**
   * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
   */
  @java.lang.Override
  public com.google.zetasql.TableValuedFunctionRefProtoOrBuilder getTvfOrBuilder() {
    return tvf_ == null ? com.google.zetasql.TableValuedFunctionRefProto.getDefaultInstance() : tvf_;
  }

  public static final int SIGNATURE_FIELD_NUMBER = 3;
  private com.google.zetasql.FunctionProtos.TVFSignatureProto signature_;
  /**
   * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
   * @return Whether the signature field is set.
   */
  @java.lang.Override
  public boolean hasSignature() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
   * @return The signature.
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.TVFSignatureProto getSignature() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.TVFSignatureProto.getDefaultInstance() : signature_;
  }
  /**
   * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.TVFSignatureProtoOrBuilder getSignatureOrBuilder() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.TVFSignatureProto.getDefaultInstance() : signature_;
  }

  public static final int ARGUMENT_LIST_FIELD_NUMBER = 5;
  private java.util.List<com.google.zetasql.ResolvedFunctionArgumentProto> argumentList_;
  /**
   * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedFunctionArgumentProto> getArgumentListList() {
    return argumentList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder> 
      getArgumentListOrBuilderList() {
    return argumentList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
   */
  @java.lang.Override
  public int getArgumentListCount() {
    return argumentList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedFunctionArgumentProto getArgumentList(int index) {
    return argumentList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder getArgumentListOrBuilder(
      int index) {
    return argumentList_.get(index);
  }

  public static final int COLUMN_INDEX_LIST_FIELD_NUMBER = 8;
  private com.google.protobuf.Internal.LongList columnIndexList_;
  /**
   * <code>repeated int64 column_index_list = 8;</code>
   * @return A list containing the columnIndexList.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long>
      getColumnIndexListList() {
    return columnIndexList_;
  }
  /**
   * <code>repeated int64 column_index_list = 8;</code>
   * @return The count of columnIndexList.
   */
  public int getColumnIndexListCount() {
    return columnIndexList_.size();
  }
  /**
   * <code>repeated int64 column_index_list = 8;</code>
   * @param index The index of the element to return.
   * @return The columnIndexList at the given index.
   */
  public long getColumnIndexList(int index) {
    return columnIndexList_.getLong(index);
  }

  public static final int ALIAS_FIELD_NUMBER = 6;
  private volatile java.lang.Object alias_;
  /**
   * <code>optional string alias = 6;</code>
   * @return Whether the alias field is set.
   */
  @java.lang.Override
  public boolean hasAlias() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <code>optional string alias = 6;</code>
   * @return The alias.
   */
  @java.lang.Override
  public java.lang.String getAlias() {
    java.lang.Object ref = alias_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        alias_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string alias = 6;</code>
   * @return The bytes for alias.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAliasBytes() {
    java.lang.Object ref = alias_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      alias_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FUNCTION_CALL_SIGNATURE_FIELD_NUMBER = 7;
  private com.google.zetasql.FunctionProtos.FunctionSignatureProto functionCallSignature_;
  /**
   * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
   * @return Whether the functionCallSignature field is set.
   */
  @java.lang.Override
  public boolean hasFunctionCallSignature() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
   * @return The functionCallSignature.
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.FunctionSignatureProto getFunctionCallSignature() {
    return functionCallSignature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : functionCallSignature_;
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
   */
  @java.lang.Override
  public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getFunctionCallSignatureOrBuilder() {
    return functionCallSignature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : functionCallSignature_;
  }

  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedTVFScanProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedTVFScanProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This scan represents a call to a table-valued function (TVF). Each TVF
   * returns an entire output relation instead of a single scalar value. The
   * enclosing query may refer to the TVF as if it were a table subquery. The
   * TVF may accept scalar arguments and/or other input relations.
   * Scalar arguments work the same way as arguments for non-table-valued
   * functions: in the resolved AST, their types are equal to the required
   * argument types specified in the function signature.
   * The function signature may also include relation arguments, and any such
   * relation argument may specify a required schema. If such a required schema
   * is present, then in the resolved AST, the ResolvedScan for each relational
   * ResolvedFunctionArgument is guaranteed to have the same number of columns
   * as the required schema, and the provided columns match position-wise with
   * the required columns. Each provided column has the same name and type as
   * the corresponding required column.
   * If AnalyzerOptions::prune_unused_columns is true, the &lt;column_list&gt; and
   * &lt;column_index_list&gt; will include only columns that were referenced
   * in the user query. (SELECT * counts as referencing all columns.)
   * Pruning has no effect on value tables (the value is never pruned).
   * &lt;column_list&gt; is a set of new ResolvedColumns created by this scan.
   * The &lt;column_list&gt;[i] should be matched to the related TVFScan's output
   * relation column by
   * &lt;signature&gt;.result_schema().column(&lt;column_index_list&gt;[i]).
   * &lt;tvf&gt; The TableValuedFunction entry that the catalog returned for this TVF
   *       scan. Contains non-concrete function signatures which may include
   *       arguments with templated types.
   * &lt;signature&gt; The concrete table function signature for this TVF call,
   *             including the types of all scalar arguments and the
   *             number and types of columns of all table-valued
   *             arguments. An engine may also subclass this object to
   *             provide extra custom information and return an instance
   *             of the subclass from the TableValuedFunction::Resolve
   *             method.
   * &lt;argument_list&gt; The vector of resolved concrete arguments for this TVF
   *                 call, including the default values or NULLs injected for
   *                 the omitted arguments (Note the NULL injection is a
   *                 temporary solution to handle omitted named arguments. This
   *                 is subject to change by upcoming CLs).
   * &lt;column_index_list&gt; This list matches 1-1 with the &lt;column_list&gt;, and
   * identifies the index of the corresponding column in the &lt;signature&gt;'s
   * result relation column list.
   * &lt;alias&gt; The AS alias for the scan, or empty if none.
   * &lt;function_call_signature&gt; The FunctionSignature object from the
   *                           &lt;tvf-&gt;signatures()&gt; list that matched the
   *                           current call. The TVFScan's
   *                           &lt;FunctionSignature::ConcreteArgument&gt; list
   *                           matches 1:1 to &lt;argument_list&gt;, while its
   *                           &lt;FunctionSignature::arguments&gt; list still has
   *                           the full argument list.
   *                           The analyzer only sets this field when
   *                           it could be ambiguous for an engine to figure
   *                           out the actual arguments provided, e.g., when
   *                           there are arguments omitted from the call. When
   *                           it is provided, engines may use this object to
   *                           check for the argument names and omitted
   *                           arguments. SQLBuilder may also need this object
   *                           in cases when the named argument notation is
   *                           required for this call.
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedTVFScanProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedTVFScanProto)
      com.google.zetasql.ResolvedTVFScanProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedTVFScanProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedTVFScanProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedTVFScanProto.class, com.google.zetasql.ResolvedTVFScanProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedTVFScanProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getTvfFieldBuilder();
        getSignatureFieldBuilder();
        getArgumentListFieldBuilder();
        getFunctionCallSignatureFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (tvfBuilder_ == null) {
        tvf_ = null;
      } else {
        tvfBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (signatureBuilder_ == null) {
        signature_ = null;
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (argumentListBuilder_ == null) {
        argumentList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        argumentListBuilder_.clear();
      }
      columnIndexList_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000010);
      alias_ = "";
      bitField0_ = (bitField0_ & ~0x00000020);
      if (functionCallSignatureBuilder_ == null) {
        functionCallSignature_ = null;
      } else {
        functionCallSignatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedTVFScanProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedTVFScanProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedTVFScanProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedTVFScanProto build() {
      com.google.zetasql.ResolvedTVFScanProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedTVFScanProto buildPartial() {
      com.google.zetasql.ResolvedTVFScanProto result = new com.google.zetasql.ResolvedTVFScanProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        if (parentBuilder_ == null) {
          result.parent_ = parent_;
        } else {
          result.parent_ = parentBuilder_.build();
        }
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        if (tvfBuilder_ == null) {
          result.tvf_ = tvf_;
        } else {
          result.tvf_ = tvfBuilder_.build();
        }
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        if (signatureBuilder_ == null) {
          result.signature_ = signature_;
        } else {
          result.signature_ = signatureBuilder_.build();
        }
        to_bitField0_ |= 0x00000004;
      }
      if (argumentListBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          argumentList_ = java.util.Collections.unmodifiableList(argumentList_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.argumentList_ = argumentList_;
      } else {
        result.argumentList_ = argumentListBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        columnIndexList_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.columnIndexList_ = columnIndexList_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        to_bitField0_ |= 0x00000008;
      }
      result.alias_ = alias_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        if (functionCallSignatureBuilder_ == null) {
          result.functionCallSignature_ = functionCallSignature_;
        } else {
          result.functionCallSignature_ = functionCallSignatureBuilder_.build();
        }
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedScanProto parent_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     * @return Whether the parent field is set.
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     * @return The parent.
     */
    public com.google.zetasql.ResolvedScanProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedScanProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedScanProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedScanProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedScanProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedScanProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedScanProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedScanProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private com.google.zetasql.TableValuedFunctionRefProto tvf_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.TableValuedFunctionRefProto, com.google.zetasql.TableValuedFunctionRefProto.Builder, com.google.zetasql.TableValuedFunctionRefProtoOrBuilder> tvfBuilder_;
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     * @return Whether the tvf field is set.
     */
    public boolean hasTvf() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     * @return The tvf.
     */
    public com.google.zetasql.TableValuedFunctionRefProto getTvf() {
      if (tvfBuilder_ == null) {
        return tvf_ == null ? com.google.zetasql.TableValuedFunctionRefProto.getDefaultInstance() : tvf_;
      } else {
        return tvfBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public Builder setTvf(com.google.zetasql.TableValuedFunctionRefProto value) {
      if (tvfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tvf_ = value;
        onChanged();
      } else {
        tvfBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public Builder setTvf(
        com.google.zetasql.TableValuedFunctionRefProto.Builder builderForValue) {
      if (tvfBuilder_ == null) {
        tvf_ = builderForValue.build();
        onChanged();
      } else {
        tvfBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public Builder mergeTvf(com.google.zetasql.TableValuedFunctionRefProto value) {
      if (tvfBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0) &&
            tvf_ != null &&
            tvf_ != com.google.zetasql.TableValuedFunctionRefProto.getDefaultInstance()) {
          tvf_ =
            com.google.zetasql.TableValuedFunctionRefProto.newBuilder(tvf_).mergeFrom(value).buildPartial();
        } else {
          tvf_ = value;
        }
        onChanged();
      } else {
        tvfBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public Builder clearTvf() {
      if (tvfBuilder_ == null) {
        tvf_ = null;
        onChanged();
      } else {
        tvfBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public com.google.zetasql.TableValuedFunctionRefProto.Builder getTvfBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTvfFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    public com.google.zetasql.TableValuedFunctionRefProtoOrBuilder getTvfOrBuilder() {
      if (tvfBuilder_ != null) {
        return tvfBuilder_.getMessageOrBuilder();
      } else {
        return tvf_ == null ?
            com.google.zetasql.TableValuedFunctionRefProto.getDefaultInstance() : tvf_;
      }
    }
    /**
     * <code>optional .zetasql.TableValuedFunctionRefProto tvf = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.TableValuedFunctionRefProto, com.google.zetasql.TableValuedFunctionRefProto.Builder, com.google.zetasql.TableValuedFunctionRefProtoOrBuilder> 
        getTvfFieldBuilder() {
      if (tvfBuilder_ == null) {
        tvfBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.TableValuedFunctionRefProto, com.google.zetasql.TableValuedFunctionRefProto.Builder, com.google.zetasql.TableValuedFunctionRefProtoOrBuilder>(
                getTvf(),
                getParentForChildren(),
                isClean());
        tvf_ = null;
      }
      return tvfBuilder_;
    }

    private com.google.zetasql.FunctionProtos.TVFSignatureProto signature_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.TVFSignatureProto, com.google.zetasql.FunctionProtos.TVFSignatureProto.Builder, com.google.zetasql.FunctionProtos.TVFSignatureProtoOrBuilder> signatureBuilder_;
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     * @return Whether the signature field is set.
     */
    public boolean hasSignature() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     * @return The signature.
     */
    public com.google.zetasql.FunctionProtos.TVFSignatureProto getSignature() {
      if (signatureBuilder_ == null) {
        return signature_ == null ? com.google.zetasql.FunctionProtos.TVFSignatureProto.getDefaultInstance() : signature_;
      } else {
        return signatureBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public Builder setSignature(com.google.zetasql.FunctionProtos.TVFSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signature_ = value;
        onChanged();
      } else {
        signatureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public Builder setSignature(
        com.google.zetasql.FunctionProtos.TVFSignatureProto.Builder builderForValue) {
      if (signatureBuilder_ == null) {
        signature_ = builderForValue.build();
        onChanged();
      } else {
        signatureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public Builder mergeSignature(com.google.zetasql.FunctionProtos.TVFSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0) &&
            signature_ != null &&
            signature_ != com.google.zetasql.FunctionProtos.TVFSignatureProto.getDefaultInstance()) {
          signature_ =
            com.google.zetasql.FunctionProtos.TVFSignatureProto.newBuilder(signature_).mergeFrom(value).buildPartial();
        } else {
          signature_ = value;
        }
        onChanged();
      } else {
        signatureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public Builder clearSignature() {
      if (signatureBuilder_ == null) {
        signature_ = null;
        onChanged();
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public com.google.zetasql.FunctionProtos.TVFSignatureProto.Builder getSignatureBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSignatureFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    public com.google.zetasql.FunctionProtos.TVFSignatureProtoOrBuilder getSignatureOrBuilder() {
      if (signatureBuilder_ != null) {
        return signatureBuilder_.getMessageOrBuilder();
      } else {
        return signature_ == null ?
            com.google.zetasql.FunctionProtos.TVFSignatureProto.getDefaultInstance() : signature_;
      }
    }
    /**
     * <code>optional .zetasql.TVFSignatureProto signature = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.TVFSignatureProto, com.google.zetasql.FunctionProtos.TVFSignatureProto.Builder, com.google.zetasql.FunctionProtos.TVFSignatureProtoOrBuilder> 
        getSignatureFieldBuilder() {
      if (signatureBuilder_ == null) {
        signatureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.FunctionProtos.TVFSignatureProto, com.google.zetasql.FunctionProtos.TVFSignatureProto.Builder, com.google.zetasql.FunctionProtos.TVFSignatureProtoOrBuilder>(
                getSignature(),
                getParentForChildren(),
                isClean());
        signature_ = null;
      }
      return signatureBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedFunctionArgumentProto> argumentList_ =
      java.util.Collections.emptyList();
    private void ensureArgumentListIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        argumentList_ = new java.util.ArrayList<com.google.zetasql.ResolvedFunctionArgumentProto>(argumentList_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedFunctionArgumentProto, com.google.zetasql.ResolvedFunctionArgumentProto.Builder, com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder> argumentListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedFunctionArgumentProto> getArgumentListList() {
      if (argumentListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(argumentList_);
      } else {
        return argumentListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public int getArgumentListCount() {
      if (argumentListBuilder_ == null) {
        return argumentList_.size();
      } else {
        return argumentListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public com.google.zetasql.ResolvedFunctionArgumentProto getArgumentList(int index) {
      if (argumentListBuilder_ == null) {
        return argumentList_.get(index);
      } else {
        return argumentListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder setArgumentList(
        int index, com.google.zetasql.ResolvedFunctionArgumentProto value) {
      if (argumentListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentListIsMutable();
        argumentList_.set(index, value);
        onChanged();
      } else {
        argumentListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder setArgumentList(
        int index, com.google.zetasql.ResolvedFunctionArgumentProto.Builder builderForValue) {
      if (argumentListBuilder_ == null) {
        ensureArgumentListIsMutable();
        argumentList_.set(index, builderForValue.build());
        onChanged();
      } else {
        argumentListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder addArgumentList(com.google.zetasql.ResolvedFunctionArgumentProto value) {
      if (argumentListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentListIsMutable();
        argumentList_.add(value);
        onChanged();
      } else {
        argumentListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder addArgumentList(
        int index, com.google.zetasql.ResolvedFunctionArgumentProto value) {
      if (argumentListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentListIsMutable();
        argumentList_.add(index, value);
        onChanged();
      } else {
        argumentListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder addArgumentList(
        com.google.zetasql.ResolvedFunctionArgumentProto.Builder builderForValue) {
      if (argumentListBuilder_ == null) {
        ensureArgumentListIsMutable();
        argumentList_.add(builderForValue.build());
        onChanged();
      } else {
        argumentListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder addArgumentList(
        int index, com.google.zetasql.ResolvedFunctionArgumentProto.Builder builderForValue) {
      if (argumentListBuilder_ == null) {
        ensureArgumentListIsMutable();
        argumentList_.add(index, builderForValue.build());
        onChanged();
      } else {
        argumentListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder addAllArgumentList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedFunctionArgumentProto> values) {
      if (argumentListBuilder_ == null) {
        ensureArgumentListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, argumentList_);
        onChanged();
      } else {
        argumentListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder clearArgumentList() {
      if (argumentListBuilder_ == null) {
        argumentList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        argumentListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public Builder removeArgumentList(int index) {
      if (argumentListBuilder_ == null) {
        ensureArgumentListIsMutable();
        argumentList_.remove(index);
        onChanged();
      } else {
        argumentListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public com.google.zetasql.ResolvedFunctionArgumentProto.Builder getArgumentListBuilder(
        int index) {
      return getArgumentListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder getArgumentListOrBuilder(
        int index) {
      if (argumentListBuilder_ == null) {
        return argumentList_.get(index);  } else {
        return argumentListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder> 
         getArgumentListOrBuilderList() {
      if (argumentListBuilder_ != null) {
        return argumentListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(argumentList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public com.google.zetasql.ResolvedFunctionArgumentProto.Builder addArgumentListBuilder() {
      return getArgumentListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedFunctionArgumentProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public com.google.zetasql.ResolvedFunctionArgumentProto.Builder addArgumentListBuilder(
        int index) {
      return getArgumentListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedFunctionArgumentProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedFunctionArgumentProto argument_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedFunctionArgumentProto.Builder> 
         getArgumentListBuilderList() {
      return getArgumentListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedFunctionArgumentProto, com.google.zetasql.ResolvedFunctionArgumentProto.Builder, com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder> 
        getArgumentListFieldBuilder() {
      if (argumentListBuilder_ == null) {
        argumentListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedFunctionArgumentProto, com.google.zetasql.ResolvedFunctionArgumentProto.Builder, com.google.zetasql.ResolvedFunctionArgumentProtoOrBuilder>(
                argumentList_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        argumentList_ = null;
      }
      return argumentListBuilder_;
    }

    private com.google.protobuf.Internal.LongList columnIndexList_ = emptyLongList();
    private void ensureColumnIndexListIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        columnIndexList_ = mutableCopy(columnIndexList_);
        bitField0_ |= 0x00000010;
       }
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @return A list containing the columnIndexList.
     */
    public java.util.List<java.lang.Long>
        getColumnIndexListList() {
      return ((bitField0_ & 0x00000010) != 0) ?
               java.util.Collections.unmodifiableList(columnIndexList_) : columnIndexList_;
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @return The count of columnIndexList.
     */
    public int getColumnIndexListCount() {
      return columnIndexList_.size();
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @param index The index of the element to return.
     * @return The columnIndexList at the given index.
     */
    public long getColumnIndexList(int index) {
      return columnIndexList_.getLong(index);
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @param index The index to set the value at.
     * @param value The columnIndexList to set.
     * @return This builder for chaining.
     */
    public Builder setColumnIndexList(
        int index, long value) {
      ensureColumnIndexListIsMutable();
      columnIndexList_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @param value The columnIndexList to add.
     * @return This builder for chaining.
     */
    public Builder addColumnIndexList(long value) {
      ensureColumnIndexListIsMutable();
      columnIndexList_.addLong(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @param values The columnIndexList to add.
     * @return This builder for chaining.
     */
    public Builder addAllColumnIndexList(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureColumnIndexListIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, columnIndexList_);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 column_index_list = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearColumnIndexList() {
      columnIndexList_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private java.lang.Object alias_ = "";
    /**
     * <code>optional string alias = 6;</code>
     * @return Whether the alias field is set.
     */
    public boolean hasAlias() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional string alias = 6;</code>
     * @return The alias.
     */
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          alias_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string alias = 6;</code>
     * @return The bytes for alias.
     */
    public com.google.protobuf.ByteString
        getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string alias = 6;</code>
     * @param value The alias to set.
     * @return This builder for chaining.
     */
    public Builder setAlias(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
      alias_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string alias = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearAlias() {
      bitField0_ = (bitField0_ & ~0x00000020);
      alias_ = getDefaultInstance().getAlias();
      onChanged();
      return this;
    }
    /**
     * <code>optional string alias = 6;</code>
     * @param value The bytes for alias to set.
     * @return This builder for chaining.
     */
    public Builder setAliasBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
      alias_ = value;
      onChanged();
      return this;
    }

    private com.google.zetasql.FunctionProtos.FunctionSignatureProto functionCallSignature_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> functionCallSignatureBuilder_;
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     * @return Whether the functionCallSignature field is set.
     */
    public boolean hasFunctionCallSignature() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     * @return The functionCallSignature.
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto getFunctionCallSignature() {
      if (functionCallSignatureBuilder_ == null) {
        return functionCallSignature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : functionCallSignature_;
      } else {
        return functionCallSignatureBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public Builder setFunctionCallSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (functionCallSignatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        functionCallSignature_ = value;
        onChanged();
      } else {
        functionCallSignatureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public Builder setFunctionCallSignature(
        com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder builderForValue) {
      if (functionCallSignatureBuilder_ == null) {
        functionCallSignature_ = builderForValue.build();
        onChanged();
      } else {
        functionCallSignatureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public Builder mergeFunctionCallSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (functionCallSignatureBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0) &&
            functionCallSignature_ != null &&
            functionCallSignature_ != com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance()) {
          functionCallSignature_ =
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.newBuilder(functionCallSignature_).mergeFrom(value).buildPartial();
        } else {
          functionCallSignature_ = value;
        }
        onChanged();
      } else {
        functionCallSignatureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public Builder clearFunctionCallSignature() {
      if (functionCallSignatureBuilder_ == null) {
        functionCallSignature_ = null;
        onChanged();
      } else {
        functionCallSignatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder getFunctionCallSignatureBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getFunctionCallSignatureFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getFunctionCallSignatureOrBuilder() {
      if (functionCallSignatureBuilder_ != null) {
        return functionCallSignatureBuilder_.getMessageOrBuilder();
      } else {
        return functionCallSignature_ == null ?
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : functionCallSignature_;
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto function_call_signature = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> 
        getFunctionCallSignatureFieldBuilder() {
      if (functionCallSignatureBuilder_ == null) {
        functionCallSignatureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder>(
                getFunctionCallSignature(),
                getParentForChildren(),
                isClean());
        functionCallSignature_ = null;
      }
      return functionCallSignatureBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedTVFScanProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedTVFScanProto)
  private static final com.google.zetasql.ResolvedTVFScanProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedTVFScanProto();
  }

  public static com.google.zetasql.ResolvedTVFScanProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedTVFScanProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedTVFScanProto>() {
    @java.lang.Override
    public ResolvedTVFScanProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(
                builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ResolvedTVFScanProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedTVFScanProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedTVFScanProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

