// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * A scan produced by the following SQL fragment:
 * &lt;input_scan&gt; UNPIVOT(&lt;value_column_list&gt;
 *   FOR &lt;label_column&gt;
 *   IN (&lt;unpivot_arg_list&gt;))
 * size of (&lt;unpivot_arg_list&gt;[i], i.e. column groups inside
 * &lt;unpivot_arg_list&gt;)
 *   = size of (&lt;value_column_list&gt;)
 *   = Let's say num_value_columns
 * size of (&lt;unpivot_arg_list&gt;)
 *   = size of (&lt;label_list&gt;)
 *   = Let's say num_args
 * Here is how output rows are generated --
 * for each input row :
 *   for arg_index = 0 .. (num_args - 1) :
 *     output a row with the original columns from &lt;input_scan&gt;
 *       plus
 *     arg = &lt;unpivot_arg_list&gt;[arg_index]
 *     for value_column_index = 0 .. (num_value_columns - 1) :
 *       output_value_column = &lt;value_column_list&gt;[value_column_index]
 *       input_arg_column = arg [value_column_index]
 *       output_value_column = input_arg_column
 *       plus
 *     &lt;label_column&gt; = &lt;label_list&gt;[arg_index]
 * Hence the total number of rows generated in the output =
 *   input rows * size of &lt;unpivot_arg_list&gt;
 * For all column groups inside &lt;unpivot_arg_list&gt;, datatype of
 * columns at the same position in the vector must be equivalent, and
 * also equivalent to the datatype of the column at the same position in
 * &lt;value_column_list&gt;.
 * I.e. in the above pseudocode, datatypes must be equivalent for
 * output_value_column and input_arg_column.
 * Datatype of &lt;label_column&gt; must be the same as datatype of
 * &lt;label_list&gt; and can be string or int64.
 * Details: (broken link)
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedUnpivotScanProto}
 */
public final class ResolvedUnpivotScanProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedUnpivotScanProto)
    ResolvedUnpivotScanProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedUnpivotScanProto.newBuilder() to construct.
  private ResolvedUnpivotScanProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedUnpivotScanProto() {
    valueColumnList_ = java.util.Collections.emptyList();
    labelList_ = java.util.Collections.emptyList();
    unpivotArgList_ = java.util.Collections.emptyList();
    projectedInputColumnList_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ResolvedUnpivotScanProto();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUnpivotScanProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUnpivotScanProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedUnpivotScanProto.class, com.google.zetasql.ResolvedUnpivotScanProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedScanProto parent_;
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   * @return Whether the parent field is set.
   */
  @java.lang.Override
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   * @return The parent.
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedScanProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedScanProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
  }

  public static final int INPUT_SCAN_FIELD_NUMBER = 2;
  private com.google.zetasql.AnyResolvedScanProto inputScan_;
  /**
   * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
   * @return Whether the inputScan field is set.
   */
  @java.lang.Override
  public boolean hasInputScan() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
   * @return The inputScan.
   */
  @java.lang.Override
  public com.google.zetasql.AnyResolvedScanProto getInputScan() {
    return inputScan_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : inputScan_;
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
   */
  @java.lang.Override
  public com.google.zetasql.AnyResolvedScanProtoOrBuilder getInputScanOrBuilder() {
    return inputScan_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : inputScan_;
  }

  public static final int VALUE_COLUMN_LIST_FIELD_NUMBER = 3;
  private java.util.List<com.google.zetasql.ResolvedColumnProto> valueColumnList_;
  /**
   * <pre>
   * This is a list of one or more new columns added by UNPIVOT.
   * These new column(s) store the value of input columns that are in
   * the UNPIVOT IN clause.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedColumnProto> getValueColumnListList() {
    return valueColumnList_;
  }
  /**
   * <pre>
   * This is a list of one or more new columns added by UNPIVOT.
   * These new column(s) store the value of input columns that are in
   * the UNPIVOT IN clause.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedColumnProtoOrBuilder> 
      getValueColumnListOrBuilderList() {
    return valueColumnList_;
  }
  /**
   * <pre>
   * This is a list of one or more new columns added by UNPIVOT.
   * These new column(s) store the value of input columns that are in
   * the UNPIVOT IN clause.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
   */
  @java.lang.Override
  public int getValueColumnListCount() {
    return valueColumnList_.size();
  }
  /**
   * <pre>
   * This is a list of one or more new columns added by UNPIVOT.
   * These new column(s) store the value of input columns that are in
   * the UNPIVOT IN clause.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedColumnProto getValueColumnList(int index) {
    return valueColumnList_.get(index);
  }
  /**
   * <pre>
   * This is a list of one or more new columns added by UNPIVOT.
   * These new column(s) store the value of input columns that are in
   * the UNPIVOT IN clause.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedColumnProtoOrBuilder getValueColumnListOrBuilder(
      int index) {
    return valueColumnList_.get(index);
  }

  public static final int LABEL_COLUMN_FIELD_NUMBER = 4;
  private com.google.zetasql.ResolvedColumnProto labelColumn_;
  /**
   * <pre>
   * This is a new column added in the output for storing labels for
   * input columns groups that are present in the IN clause. Its
   * values are taken from &lt;label_list&gt;.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
   * @return Whether the labelColumn field is set.
   */
  @java.lang.Override
  public boolean hasLabelColumn() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * This is a new column added in the output for storing labels for
   * input columns groups that are present in the IN clause. Its
   * values are taken from &lt;label_list&gt;.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
   * @return The labelColumn.
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedColumnProto getLabelColumn() {
    return labelColumn_ == null ? com.google.zetasql.ResolvedColumnProto.getDefaultInstance() : labelColumn_;
  }
  /**
   * <pre>
   * This is a new column added in the output for storing labels for
   * input columns groups that are present in the IN clause. Its
   * values are taken from &lt;label_list&gt;.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedColumnProtoOrBuilder getLabelColumnOrBuilder() {
    return labelColumn_ == null ? com.google.zetasql.ResolvedColumnProto.getDefaultInstance() : labelColumn_;
  }

  public static final int LABEL_LIST_FIELD_NUMBER = 5;
  private java.util.List<com.google.zetasql.ResolvedLiteralProto> labelList_;
  /**
   * <pre>
   * String or integer literal for each column group in
   * &lt;unpivot_arg_list&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedLiteralProto> getLabelListList() {
    return labelList_;
  }
  /**
   * <pre>
   * String or integer literal for each column group in
   * &lt;unpivot_arg_list&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedLiteralProtoOrBuilder> 
      getLabelListOrBuilderList() {
    return labelList_;
  }
  /**
   * <pre>
   * String or integer literal for each column group in
   * &lt;unpivot_arg_list&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
   */
  @java.lang.Override
  public int getLabelListCount() {
    return labelList_.size();
  }
  /**
   * <pre>
   * String or integer literal for each column group in
   * &lt;unpivot_arg_list&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedLiteralProto getLabelList(int index) {
    return labelList_.get(index);
  }
  /**
   * <pre>
   * String or integer literal for each column group in
   * &lt;unpivot_arg_list&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedLiteralProtoOrBuilder getLabelListOrBuilder(
      int index) {
    return labelList_.get(index);
  }

  public static final int UNPIVOT_ARG_LIST_FIELD_NUMBER = 6;
  private java.util.List<com.google.zetasql.ResolvedUnpivotArgProto> unpivotArgList_;
  /**
   * <pre>
   * The list of groups of columns in the UNPIVOT IN list. Each group
   * contains references to the output columns of &lt;input_scan&gt; of the
   * ResolvedUnpivotScan. The values of these columns are stored in the
   * new &lt;value_column_list&gt; and the column group labels/names
   * in the &lt;label_column&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedUnpivotArgProto> getUnpivotArgListList() {
    return unpivotArgList_;
  }
  /**
   * <pre>
   * The list of groups of columns in the UNPIVOT IN list. Each group
   * contains references to the output columns of &lt;input_scan&gt; of the
   * ResolvedUnpivotScan. The values of these columns are stored in the
   * new &lt;value_column_list&gt; and the column group labels/names
   * in the &lt;label_column&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder> 
      getUnpivotArgListOrBuilderList() {
    return unpivotArgList_;
  }
  /**
   * <pre>
   * The list of groups of columns in the UNPIVOT IN list. Each group
   * contains references to the output columns of &lt;input_scan&gt; of the
   * ResolvedUnpivotScan. The values of these columns are stored in the
   * new &lt;value_column_list&gt; and the column group labels/names
   * in the &lt;label_column&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
   */
  @java.lang.Override
  public int getUnpivotArgListCount() {
    return unpivotArgList_.size();
  }
  /**
   * <pre>
   * The list of groups of columns in the UNPIVOT IN list. Each group
   * contains references to the output columns of &lt;input_scan&gt; of the
   * ResolvedUnpivotScan. The values of these columns are stored in the
   * new &lt;value_column_list&gt; and the column group labels/names
   * in the &lt;label_column&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedUnpivotArgProto getUnpivotArgList(int index) {
    return unpivotArgList_.get(index);
  }
  /**
   * <pre>
   * The list of groups of columns in the UNPIVOT IN list. Each group
   * contains references to the output columns of &lt;input_scan&gt; of the
   * ResolvedUnpivotScan. The values of these columns are stored in the
   * new &lt;value_column_list&gt; and the column group labels/names
   * in the &lt;label_column&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder getUnpivotArgListOrBuilder(
      int index) {
    return unpivotArgList_.get(index);
  }

  public static final int PROJECTED_INPUT_COLUMN_LIST_FIELD_NUMBER = 7;
  private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> projectedInputColumnList_;
  /**
   * <pre>
   * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
   * IN clause. Columns in &lt;projected_input_column_list&gt; and
   * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
   * complete set of columns in the unpivot input-source.
   * The expression of each ResolvedComputedColumn is a
   * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getProjectedInputColumnListList() {
    return projectedInputColumnList_;
  }
  /**
   * <pre>
   * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
   * IN clause. Columns in &lt;projected_input_column_list&gt; and
   * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
   * complete set of columns in the unpivot input-source.
   * The expression of each ResolvedComputedColumn is a
   * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
      getProjectedInputColumnListOrBuilderList() {
    return projectedInputColumnList_;
  }
  /**
   * <pre>
   * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
   * IN clause. Columns in &lt;projected_input_column_list&gt; and
   * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
   * complete set of columns in the unpivot input-source.
   * The expression of each ResolvedComputedColumn is a
   * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
   */
  @java.lang.Override
  public int getProjectedInputColumnListCount() {
    return projectedInputColumnList_.size();
  }
  /**
   * <pre>
   * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
   * IN clause. Columns in &lt;projected_input_column_list&gt; and
   * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
   * complete set of columns in the unpivot input-source.
   * The expression of each ResolvedComputedColumn is a
   * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedComputedColumnProto getProjectedInputColumnList(int index) {
    return projectedInputColumnList_.get(index);
  }
  /**
   * <pre>
   * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
   * IN clause. Columns in &lt;projected_input_column_list&gt; and
   * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
   * complete set of columns in the unpivot input-source.
   * The expression of each ResolvedComputedColumn is a
   * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
   */
  @java.lang.Override
  public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getProjectedInputColumnListOrBuilder(
      int index) {
    return projectedInputColumnList_.get(index);
  }

  public static final int INCLUDE_NULLS_FIELD_NUMBER = 8;
  private boolean includeNulls_;
  /**
   * <pre>
   * Whether we need to include the rows from output where ALL columns
   * from &lt;value_column_list&gt; are null.
   * </pre>
   *
   * <code>optional bool include_nulls = 8;</code>
   * @return Whether the includeNulls field is set.
   */
  @java.lang.Override
  public boolean hasIncludeNulls() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Whether we need to include the rows from output where ALL columns
   * from &lt;value_column_list&gt; are null.
   * </pre>
   *
   * <code>optional bool include_nulls = 8;</code>
   * @return The includeNulls.
   */
  @java.lang.Override
  public boolean getIncludeNulls() {
    return includeNulls_;
  }

  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUnpivotScanProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedUnpivotScanProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A scan produced by the following SQL fragment:
   * &lt;input_scan&gt; UNPIVOT(&lt;value_column_list&gt;
   *   FOR &lt;label_column&gt;
   *   IN (&lt;unpivot_arg_list&gt;))
   * size of (&lt;unpivot_arg_list&gt;[i], i.e. column groups inside
   * &lt;unpivot_arg_list&gt;)
   *   = size of (&lt;value_column_list&gt;)
   *   = Let's say num_value_columns
   * size of (&lt;unpivot_arg_list&gt;)
   *   = size of (&lt;label_list&gt;)
   *   = Let's say num_args
   * Here is how output rows are generated --
   * for each input row :
   *   for arg_index = 0 .. (num_args - 1) :
   *     output a row with the original columns from &lt;input_scan&gt;
   *       plus
   *     arg = &lt;unpivot_arg_list&gt;[arg_index]
   *     for value_column_index = 0 .. (num_value_columns - 1) :
   *       output_value_column = &lt;value_column_list&gt;[value_column_index]
   *       input_arg_column = arg [value_column_index]
   *       output_value_column = input_arg_column
   *       plus
   *     &lt;label_column&gt; = &lt;label_list&gt;[arg_index]
   * Hence the total number of rows generated in the output =
   *   input rows * size of &lt;unpivot_arg_list&gt;
   * For all column groups inside &lt;unpivot_arg_list&gt;, datatype of
   * columns at the same position in the vector must be equivalent, and
   * also equivalent to the datatype of the column at the same position in
   * &lt;value_column_list&gt;.
   * I.e. in the above pseudocode, datatypes must be equivalent for
   * output_value_column and input_arg_column.
   * Datatype of &lt;label_column&gt; must be the same as datatype of
   * &lt;label_list&gt; and can be string or int64.
   * Details: (broken link)
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedUnpivotScanProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedUnpivotScanProto)
      com.google.zetasql.ResolvedUnpivotScanProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUnpivotScanProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUnpivotScanProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedUnpivotScanProto.class, com.google.zetasql.ResolvedUnpivotScanProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedUnpivotScanProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getInputScanFieldBuilder();
        getValueColumnListFieldBuilder();
        getLabelColumnFieldBuilder();
        getLabelListFieldBuilder();
        getUnpivotArgListFieldBuilder();
        getProjectedInputColumnListFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (inputScanBuilder_ == null) {
        inputScan_ = null;
      } else {
        inputScanBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (valueColumnListBuilder_ == null) {
        valueColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        valueColumnListBuilder_.clear();
      }
      if (labelColumnBuilder_ == null) {
        labelColumn_ = null;
      } else {
        labelColumnBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (labelListBuilder_ == null) {
        labelList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        labelListBuilder_.clear();
      }
      if (unpivotArgListBuilder_ == null) {
        unpivotArgList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        unpivotArgListBuilder_.clear();
      }
      if (projectedInputColumnListBuilder_ == null) {
        projectedInputColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
      } else {
        projectedInputColumnListBuilder_.clear();
      }
      includeNulls_ = false;
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUnpivotScanProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUnpivotScanProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedUnpivotScanProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUnpivotScanProto build() {
      com.google.zetasql.ResolvedUnpivotScanProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUnpivotScanProto buildPartial() {
      com.google.zetasql.ResolvedUnpivotScanProto result = new com.google.zetasql.ResolvedUnpivotScanProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        if (parentBuilder_ == null) {
          result.parent_ = parent_;
        } else {
          result.parent_ = parentBuilder_.build();
        }
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        if (inputScanBuilder_ == null) {
          result.inputScan_ = inputScan_;
        } else {
          result.inputScan_ = inputScanBuilder_.build();
        }
        to_bitField0_ |= 0x00000002;
      }
      if (valueColumnListBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          valueColumnList_ = java.util.Collections.unmodifiableList(valueColumnList_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.valueColumnList_ = valueColumnList_;
      } else {
        result.valueColumnList_ = valueColumnListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        if (labelColumnBuilder_ == null) {
          result.labelColumn_ = labelColumn_;
        } else {
          result.labelColumn_ = labelColumnBuilder_.build();
        }
        to_bitField0_ |= 0x00000004;
      }
      if (labelListBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          labelList_ = java.util.Collections.unmodifiableList(labelList_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.labelList_ = labelList_;
      } else {
        result.labelList_ = labelListBuilder_.build();
      }
      if (unpivotArgListBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          unpivotArgList_ = java.util.Collections.unmodifiableList(unpivotArgList_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.unpivotArgList_ = unpivotArgList_;
      } else {
        result.unpivotArgList_ = unpivotArgListBuilder_.build();
      }
      if (projectedInputColumnListBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          projectedInputColumnList_ = java.util.Collections.unmodifiableList(projectedInputColumnList_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.projectedInputColumnList_ = projectedInputColumnList_;
      } else {
        result.projectedInputColumnList_ = projectedInputColumnListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.includeNulls_ = includeNulls_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedScanProto parent_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     * @return Whether the parent field is set.
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     * @return The parent.
     */
    public com.google.zetasql.ResolvedScanProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedScanProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedScanProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedScanProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedScanProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedScanProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedScanProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedScanProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedScanProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedScanProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedScanProto, com.google.zetasql.ResolvedScanProto.Builder, com.google.zetasql.ResolvedScanProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private com.google.zetasql.AnyResolvedScanProto inputScan_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> inputScanBuilder_;
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     * @return Whether the inputScan field is set.
     */
    public boolean hasInputScan() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     * @return The inputScan.
     */
    public com.google.zetasql.AnyResolvedScanProto getInputScan() {
      if (inputScanBuilder_ == null) {
        return inputScan_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : inputScan_;
      } else {
        return inputScanBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public Builder setInputScan(com.google.zetasql.AnyResolvedScanProto value) {
      if (inputScanBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputScan_ = value;
        onChanged();
      } else {
        inputScanBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public Builder setInputScan(
        com.google.zetasql.AnyResolvedScanProto.Builder builderForValue) {
      if (inputScanBuilder_ == null) {
        inputScan_ = builderForValue.build();
        onChanged();
      } else {
        inputScanBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public Builder mergeInputScan(com.google.zetasql.AnyResolvedScanProto value) {
      if (inputScanBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0) &&
            inputScan_ != null &&
            inputScan_ != com.google.zetasql.AnyResolvedScanProto.getDefaultInstance()) {
          inputScan_ =
            com.google.zetasql.AnyResolvedScanProto.newBuilder(inputScan_).mergeFrom(value).buildPartial();
        } else {
          inputScan_ = value;
        }
        onChanged();
      } else {
        inputScanBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public Builder clearInputScan() {
      if (inputScanBuilder_ == null) {
        inputScan_ = null;
        onChanged();
      } else {
        inputScanBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public com.google.zetasql.AnyResolvedScanProto.Builder getInputScanBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInputScanFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    public com.google.zetasql.AnyResolvedScanProtoOrBuilder getInputScanOrBuilder() {
      if (inputScanBuilder_ != null) {
        return inputScanBuilder_.getMessageOrBuilder();
      } else {
        return inputScan_ == null ?
            com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : inputScan_;
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto input_scan = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> 
        getInputScanFieldBuilder() {
      if (inputScanBuilder_ == null) {
        inputScanBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder>(
                getInputScan(),
                getParentForChildren(),
                isClean());
        inputScan_ = null;
      }
      return inputScanBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedColumnProto> valueColumnList_ =
      java.util.Collections.emptyList();
    private void ensureValueColumnListIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        valueColumnList_ = new java.util.ArrayList<com.google.zetasql.ResolvedColumnProto>(valueColumnList_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder> valueColumnListBuilder_;

    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedColumnProto> getValueColumnListList() {
      if (valueColumnListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(valueColumnList_);
      } else {
        return valueColumnListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public int getValueColumnListCount() {
      if (valueColumnListBuilder_ == null) {
        return valueColumnList_.size();
      } else {
        return valueColumnListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnProto getValueColumnList(int index) {
      if (valueColumnListBuilder_ == null) {
        return valueColumnList_.get(index);
      } else {
        return valueColumnListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder setValueColumnList(
        int index, com.google.zetasql.ResolvedColumnProto value) {
      if (valueColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValueColumnListIsMutable();
        valueColumnList_.set(index, value);
        onChanged();
      } else {
        valueColumnListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder setValueColumnList(
        int index, com.google.zetasql.ResolvedColumnProto.Builder builderForValue) {
      if (valueColumnListBuilder_ == null) {
        ensureValueColumnListIsMutable();
        valueColumnList_.set(index, builderForValue.build());
        onChanged();
      } else {
        valueColumnListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder addValueColumnList(com.google.zetasql.ResolvedColumnProto value) {
      if (valueColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValueColumnListIsMutable();
        valueColumnList_.add(value);
        onChanged();
      } else {
        valueColumnListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder addValueColumnList(
        int index, com.google.zetasql.ResolvedColumnProto value) {
      if (valueColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValueColumnListIsMutable();
        valueColumnList_.add(index, value);
        onChanged();
      } else {
        valueColumnListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder addValueColumnList(
        com.google.zetasql.ResolvedColumnProto.Builder builderForValue) {
      if (valueColumnListBuilder_ == null) {
        ensureValueColumnListIsMutable();
        valueColumnList_.add(builderForValue.build());
        onChanged();
      } else {
        valueColumnListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder addValueColumnList(
        int index, com.google.zetasql.ResolvedColumnProto.Builder builderForValue) {
      if (valueColumnListBuilder_ == null) {
        ensureValueColumnListIsMutable();
        valueColumnList_.add(index, builderForValue.build());
        onChanged();
      } else {
        valueColumnListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder addAllValueColumnList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedColumnProto> values) {
      if (valueColumnListBuilder_ == null) {
        ensureValueColumnListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, valueColumnList_);
        onChanged();
      } else {
        valueColumnListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder clearValueColumnList() {
      if (valueColumnListBuilder_ == null) {
        valueColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        valueColumnListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public Builder removeValueColumnList(int index) {
      if (valueColumnListBuilder_ == null) {
        ensureValueColumnListIsMutable();
        valueColumnList_.remove(index);
        onChanged();
      } else {
        valueColumnListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnProto.Builder getValueColumnListBuilder(
        int index) {
      return getValueColumnListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnProtoOrBuilder getValueColumnListOrBuilder(
        int index) {
      if (valueColumnListBuilder_ == null) {
        return valueColumnList_.get(index);  } else {
        return valueColumnListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedColumnProtoOrBuilder> 
         getValueColumnListOrBuilderList() {
      if (valueColumnListBuilder_ != null) {
        return valueColumnListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(valueColumnList_);
      }
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnProto.Builder addValueColumnListBuilder() {
      return getValueColumnListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedColumnProto.getDefaultInstance());
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnProto.Builder addValueColumnListBuilder(
        int index) {
      return getValueColumnListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedColumnProto.getDefaultInstance());
    }
    /**
     * <pre>
     * This is a list of one or more new columns added by UNPIVOT.
     * These new column(s) store the value of input columns that are in
     * the UNPIVOT IN clause.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedColumnProto value_column_list = 3;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedColumnProto.Builder> 
         getValueColumnListBuilderList() {
      return getValueColumnListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder> 
        getValueColumnListFieldBuilder() {
      if (valueColumnListBuilder_ == null) {
        valueColumnListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder>(
                valueColumnList_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        valueColumnList_ = null;
      }
      return valueColumnListBuilder_;
    }

    private com.google.zetasql.ResolvedColumnProto labelColumn_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder> labelColumnBuilder_;
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     * @return Whether the labelColumn field is set.
     */
    public boolean hasLabelColumn() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     * @return The labelColumn.
     */
    public com.google.zetasql.ResolvedColumnProto getLabelColumn() {
      if (labelColumnBuilder_ == null) {
        return labelColumn_ == null ? com.google.zetasql.ResolvedColumnProto.getDefaultInstance() : labelColumn_;
      } else {
        return labelColumnBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public Builder setLabelColumn(com.google.zetasql.ResolvedColumnProto value) {
      if (labelColumnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelColumn_ = value;
        onChanged();
      } else {
        labelColumnBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public Builder setLabelColumn(
        com.google.zetasql.ResolvedColumnProto.Builder builderForValue) {
      if (labelColumnBuilder_ == null) {
        labelColumn_ = builderForValue.build();
        onChanged();
      } else {
        labelColumnBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public Builder mergeLabelColumn(com.google.zetasql.ResolvedColumnProto value) {
      if (labelColumnBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
            labelColumn_ != null &&
            labelColumn_ != com.google.zetasql.ResolvedColumnProto.getDefaultInstance()) {
          labelColumn_ =
            com.google.zetasql.ResolvedColumnProto.newBuilder(labelColumn_).mergeFrom(value).buildPartial();
        } else {
          labelColumn_ = value;
        }
        onChanged();
      } else {
        labelColumnBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public Builder clearLabelColumn() {
      if (labelColumnBuilder_ == null) {
        labelColumn_ = null;
        onChanged();
      } else {
        labelColumnBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public com.google.zetasql.ResolvedColumnProto.Builder getLabelColumnBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLabelColumnFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    public com.google.zetasql.ResolvedColumnProtoOrBuilder getLabelColumnOrBuilder() {
      if (labelColumnBuilder_ != null) {
        return labelColumnBuilder_.getMessageOrBuilder();
      } else {
        return labelColumn_ == null ?
            com.google.zetasql.ResolvedColumnProto.getDefaultInstance() : labelColumn_;
      }
    }
    /**
     * <pre>
     * This is a new column added in the output for storing labels for
     * input columns groups that are present in the IN clause. Its
     * values are taken from &lt;label_list&gt;.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnProto label_column = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder> 
        getLabelColumnFieldBuilder() {
      if (labelColumnBuilder_ == null) {
        labelColumnBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedColumnProto, com.google.zetasql.ResolvedColumnProto.Builder, com.google.zetasql.ResolvedColumnProtoOrBuilder>(
                getLabelColumn(),
                getParentForChildren(),
                isClean());
        labelColumn_ = null;
      }
      return labelColumnBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedLiteralProto> labelList_ =
      java.util.Collections.emptyList();
    private void ensureLabelListIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        labelList_ = new java.util.ArrayList<com.google.zetasql.ResolvedLiteralProto>(labelList_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedLiteralProto, com.google.zetasql.ResolvedLiteralProto.Builder, com.google.zetasql.ResolvedLiteralProtoOrBuilder> labelListBuilder_;

    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedLiteralProto> getLabelListList() {
      if (labelListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labelList_);
      } else {
        return labelListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public int getLabelListCount() {
      if (labelListBuilder_ == null) {
        return labelList_.size();
      } else {
        return labelListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public com.google.zetasql.ResolvedLiteralProto getLabelList(int index) {
      if (labelListBuilder_ == null) {
        return labelList_.get(index);
      } else {
        return labelListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder setLabelList(
        int index, com.google.zetasql.ResolvedLiteralProto value) {
      if (labelListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelListIsMutable();
        labelList_.set(index, value);
        onChanged();
      } else {
        labelListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder setLabelList(
        int index, com.google.zetasql.ResolvedLiteralProto.Builder builderForValue) {
      if (labelListBuilder_ == null) {
        ensureLabelListIsMutable();
        labelList_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder addLabelList(com.google.zetasql.ResolvedLiteralProto value) {
      if (labelListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelListIsMutable();
        labelList_.add(value);
        onChanged();
      } else {
        labelListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder addLabelList(
        int index, com.google.zetasql.ResolvedLiteralProto value) {
      if (labelListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelListIsMutable();
        labelList_.add(index, value);
        onChanged();
      } else {
        labelListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder addLabelList(
        com.google.zetasql.ResolvedLiteralProto.Builder builderForValue) {
      if (labelListBuilder_ == null) {
        ensureLabelListIsMutable();
        labelList_.add(builderForValue.build());
        onChanged();
      } else {
        labelListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder addLabelList(
        int index, com.google.zetasql.ResolvedLiteralProto.Builder builderForValue) {
      if (labelListBuilder_ == null) {
        ensureLabelListIsMutable();
        labelList_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder addAllLabelList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedLiteralProto> values) {
      if (labelListBuilder_ == null) {
        ensureLabelListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, labelList_);
        onChanged();
      } else {
        labelListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder clearLabelList() {
      if (labelListBuilder_ == null) {
        labelList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        labelListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public Builder removeLabelList(int index) {
      if (labelListBuilder_ == null) {
        ensureLabelListIsMutable();
        labelList_.remove(index);
        onChanged();
      } else {
        labelListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public com.google.zetasql.ResolvedLiteralProto.Builder getLabelListBuilder(
        int index) {
      return getLabelListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public com.google.zetasql.ResolvedLiteralProtoOrBuilder getLabelListOrBuilder(
        int index) {
      if (labelListBuilder_ == null) {
        return labelList_.get(index);  } else {
        return labelListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedLiteralProtoOrBuilder> 
         getLabelListOrBuilderList() {
      if (labelListBuilder_ != null) {
        return labelListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labelList_);
      }
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public com.google.zetasql.ResolvedLiteralProto.Builder addLabelListBuilder() {
      return getLabelListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedLiteralProto.getDefaultInstance());
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public com.google.zetasql.ResolvedLiteralProto.Builder addLabelListBuilder(
        int index) {
      return getLabelListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedLiteralProto.getDefaultInstance());
    }
    /**
     * <pre>
     * String or integer literal for each column group in
     * &lt;unpivot_arg_list&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedLiteralProto label_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedLiteralProto.Builder> 
         getLabelListBuilderList() {
      return getLabelListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedLiteralProto, com.google.zetasql.ResolvedLiteralProto.Builder, com.google.zetasql.ResolvedLiteralProtoOrBuilder> 
        getLabelListFieldBuilder() {
      if (labelListBuilder_ == null) {
        labelListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedLiteralProto, com.google.zetasql.ResolvedLiteralProto.Builder, com.google.zetasql.ResolvedLiteralProtoOrBuilder>(
                labelList_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        labelList_ = null;
      }
      return labelListBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedUnpivotArgProto> unpivotArgList_ =
      java.util.Collections.emptyList();
    private void ensureUnpivotArgListIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        unpivotArgList_ = new java.util.ArrayList<com.google.zetasql.ResolvedUnpivotArgProto>(unpivotArgList_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUnpivotArgProto, com.google.zetasql.ResolvedUnpivotArgProto.Builder, com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder> unpivotArgListBuilder_;

    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUnpivotArgProto> getUnpivotArgListList() {
      if (unpivotArgListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(unpivotArgList_);
      } else {
        return unpivotArgListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public int getUnpivotArgListCount() {
      if (unpivotArgListBuilder_ == null) {
        return unpivotArgList_.size();
      } else {
        return unpivotArgListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUnpivotArgProto getUnpivotArgList(int index) {
      if (unpivotArgListBuilder_ == null) {
        return unpivotArgList_.get(index);
      } else {
        return unpivotArgListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder setUnpivotArgList(
        int index, com.google.zetasql.ResolvedUnpivotArgProto value) {
      if (unpivotArgListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.set(index, value);
        onChanged();
      } else {
        unpivotArgListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder setUnpivotArgList(
        int index, com.google.zetasql.ResolvedUnpivotArgProto.Builder builderForValue) {
      if (unpivotArgListBuilder_ == null) {
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.set(index, builderForValue.build());
        onChanged();
      } else {
        unpivotArgListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder addUnpivotArgList(com.google.zetasql.ResolvedUnpivotArgProto value) {
      if (unpivotArgListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.add(value);
        onChanged();
      } else {
        unpivotArgListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder addUnpivotArgList(
        int index, com.google.zetasql.ResolvedUnpivotArgProto value) {
      if (unpivotArgListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.add(index, value);
        onChanged();
      } else {
        unpivotArgListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder addUnpivotArgList(
        com.google.zetasql.ResolvedUnpivotArgProto.Builder builderForValue) {
      if (unpivotArgListBuilder_ == null) {
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.add(builderForValue.build());
        onChanged();
      } else {
        unpivotArgListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder addUnpivotArgList(
        int index, com.google.zetasql.ResolvedUnpivotArgProto.Builder builderForValue) {
      if (unpivotArgListBuilder_ == null) {
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.add(index, builderForValue.build());
        onChanged();
      } else {
        unpivotArgListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder addAllUnpivotArgList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedUnpivotArgProto> values) {
      if (unpivotArgListBuilder_ == null) {
        ensureUnpivotArgListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, unpivotArgList_);
        onChanged();
      } else {
        unpivotArgListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder clearUnpivotArgList() {
      if (unpivotArgListBuilder_ == null) {
        unpivotArgList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        unpivotArgListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public Builder removeUnpivotArgList(int index) {
      if (unpivotArgListBuilder_ == null) {
        ensureUnpivotArgListIsMutable();
        unpivotArgList_.remove(index);
        onChanged();
      } else {
        unpivotArgListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUnpivotArgProto.Builder getUnpivotArgListBuilder(
        int index) {
      return getUnpivotArgListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder getUnpivotArgListOrBuilder(
        int index) {
      if (unpivotArgListBuilder_ == null) {
        return unpivotArgList_.get(index);  } else {
        return unpivotArgListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder> 
         getUnpivotArgListOrBuilderList() {
      if (unpivotArgListBuilder_ != null) {
        return unpivotArgListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(unpivotArgList_);
      }
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUnpivotArgProto.Builder addUnpivotArgListBuilder() {
      return getUnpivotArgListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedUnpivotArgProto.getDefaultInstance());
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUnpivotArgProto.Builder addUnpivotArgListBuilder(
        int index) {
      return getUnpivotArgListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedUnpivotArgProto.getDefaultInstance());
    }
    /**
     * <pre>
     * The list of groups of columns in the UNPIVOT IN list. Each group
     * contains references to the output columns of &lt;input_scan&gt; of the
     * ResolvedUnpivotScan. The values of these columns are stored in the
     * new &lt;value_column_list&gt; and the column group labels/names
     * in the &lt;label_column&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUnpivotArgProto unpivot_arg_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUnpivotArgProto.Builder> 
         getUnpivotArgListBuilderList() {
      return getUnpivotArgListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUnpivotArgProto, com.google.zetasql.ResolvedUnpivotArgProto.Builder, com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder> 
        getUnpivotArgListFieldBuilder() {
      if (unpivotArgListBuilder_ == null) {
        unpivotArgListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedUnpivotArgProto, com.google.zetasql.ResolvedUnpivotArgProto.Builder, com.google.zetasql.ResolvedUnpivotArgProtoOrBuilder>(
                unpivotArgList_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        unpivotArgList_ = null;
      }
      return unpivotArgListBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> projectedInputColumnList_ =
      java.util.Collections.emptyList();
    private void ensureProjectedInputColumnListIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        projectedInputColumnList_ = new java.util.ArrayList<com.google.zetasql.ResolvedComputedColumnProto>(projectedInputColumnList_);
        bitField0_ |= 0x00000040;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> projectedInputColumnListBuilder_;

    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getProjectedInputColumnListList() {
      if (projectedInputColumnListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(projectedInputColumnList_);
      } else {
        return projectedInputColumnListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public int getProjectedInputColumnListCount() {
      if (projectedInputColumnListBuilder_ == null) {
        return projectedInputColumnList_.size();
      } else {
        return projectedInputColumnListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto getProjectedInputColumnList(int index) {
      if (projectedInputColumnListBuilder_ == null) {
        return projectedInputColumnList_.get(index);
      } else {
        return projectedInputColumnListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder setProjectedInputColumnList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (projectedInputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.set(index, value);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder setProjectedInputColumnList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (projectedInputColumnListBuilder_ == null) {
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.set(index, builderForValue.build());
        onChanged();
      } else {
        projectedInputColumnListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder addProjectedInputColumnList(com.google.zetasql.ResolvedComputedColumnProto value) {
      if (projectedInputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.add(value);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder addProjectedInputColumnList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (projectedInputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.add(index, value);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder addProjectedInputColumnList(
        com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (projectedInputColumnListBuilder_ == null) {
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.add(builderForValue.build());
        onChanged();
      } else {
        projectedInputColumnListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder addProjectedInputColumnList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (projectedInputColumnListBuilder_ == null) {
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.add(index, builderForValue.build());
        onChanged();
      } else {
        projectedInputColumnListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder addAllProjectedInputColumnList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedComputedColumnProto> values) {
      if (projectedInputColumnListBuilder_ == null) {
        ensureProjectedInputColumnListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, projectedInputColumnList_);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder clearProjectedInputColumnList() {
      if (projectedInputColumnListBuilder_ == null) {
        projectedInputColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public Builder removeProjectedInputColumnList(int index) {
      if (projectedInputColumnListBuilder_ == null) {
        ensureProjectedInputColumnListIsMutable();
        projectedInputColumnList_.remove(index);
        onChanged();
      } else {
        projectedInputColumnListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder getProjectedInputColumnListBuilder(
        int index) {
      return getProjectedInputColumnListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getProjectedInputColumnListOrBuilder(
        int index) {
      if (projectedInputColumnListBuilder_ == null) {
        return projectedInputColumnList_.get(index);  } else {
        return projectedInputColumnListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
         getProjectedInputColumnListOrBuilderList() {
      if (projectedInputColumnListBuilder_ != null) {
        return projectedInputColumnListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(projectedInputColumnList_);
      }
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addProjectedInputColumnListBuilder() {
      return getProjectedInputColumnListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addProjectedInputColumnListBuilder(
        int index) {
      return getProjectedInputColumnListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <pre>
     * The columns from &lt;input_scan&gt; that are not unpivoted in UNPIVOT
     * IN clause. Columns in &lt;projected_input_column_list&gt; and
     * &lt;unpivot_arg_list&gt; are mutually exclusive and their union is the
     * complete set of columns in the unpivot input-source.
     * The expression of each ResolvedComputedColumn is a
     * ResolvedColumnRef that references a column from &lt;input_scan&gt;.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedComputedColumnProto projected_input_column_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto.Builder> 
         getProjectedInputColumnListBuilderList() {
      return getProjectedInputColumnListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
        getProjectedInputColumnListFieldBuilder() {
      if (projectedInputColumnListBuilder_ == null) {
        projectedInputColumnListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder>(
                projectedInputColumnList_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        projectedInputColumnList_ = null;
      }
      return projectedInputColumnListBuilder_;
    }

    private boolean includeNulls_ ;
    /**
     * <pre>
     * Whether we need to include the rows from output where ALL columns
     * from &lt;value_column_list&gt; are null.
     * </pre>
     *
     * <code>optional bool include_nulls = 8;</code>
     * @return Whether the includeNulls field is set.
     */
    @java.lang.Override
    public boolean hasIncludeNulls() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether we need to include the rows from output where ALL columns
     * from &lt;value_column_list&gt; are null.
     * </pre>
     *
     * <code>optional bool include_nulls = 8;</code>
     * @return The includeNulls.
     */
    @java.lang.Override
    public boolean getIncludeNulls() {
      return includeNulls_;
    }
    /**
     * <pre>
     * Whether we need to include the rows from output where ALL columns
     * from &lt;value_column_list&gt; are null.
     * </pre>
     *
     * <code>optional bool include_nulls = 8;</code>
     * @param value The includeNulls to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeNulls(boolean value) {
      bitField0_ |= 0x00000080;
      includeNulls_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we need to include the rows from output where ALL columns
     * from &lt;value_column_list&gt; are null.
     * </pre>
     *
     * <code>optional bool include_nulls = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearIncludeNulls() {
      bitField0_ = (bitField0_ & ~0x00000080);
      includeNulls_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedUnpivotScanProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedUnpivotScanProto)
  private static final com.google.zetasql.ResolvedUnpivotScanProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedUnpivotScanProto();
  }

  public static com.google.zetasql.ResolvedUnpivotScanProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedUnpivotScanProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedUnpivotScanProto>() {
    @java.lang.Override
    public ResolvedUnpivotScanProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(
                builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ResolvedUnpivotScanProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedUnpivotScanProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedUnpivotScanProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

