/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.Validators;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ContactInfoGenerator
implements GeneratorSource {
    private Grid table;
    private final ListBox encoding = new ListBox();
    private final TextBox name = new TextBox();
    private final TextBox company = new TextBox();
    private final TextBox title = new TextBox();
    private final TextBox tel = new TextBox();
    private final TextBox url = new TextBox();
    private final TextBox email = new TextBox();
    private final TextBox address = new TextBox();
    private final TextBox address2 = new TextBox();
    private final TextBox memo = new TextBox();

    public ContactInfoGenerator(ChangeHandler changeHandler, KeyPressHandler keyListener) {
        TextBox[] widgets;
        for (TextBox w : widgets = new TextBox[]{this.name, this.company, this.tel, this.url, this.email, this.address, this.address2, this.memo}) {
            w.addChangeHandler(changeHandler);
            w.addKeyPressHandler(keyListener);
        }
        this.encoding.addItem("MECARD");
        this.encoding.addItem("vCard");
        this.encoding.setSelectedIndex(0);
    }

    public String getName() {
        return "Contact information";
    }

    public String getText() throws GeneratorException {
        String name = this.getNameField();
        String company = this.getCompanyField();
        String title = this.getTitleField();
        String tel = this.getTelField();
        String url = this.getUrlField();
        String email = this.getEmailField();
        String address = this.getAddressField();
        String address2 = this.getAddress2Field();
        String memo = this.getMemoField();
        if ("vCard".equals(this.encoding.getValue(this.encoding.getSelectedIndex()))) {
            return ContactInfoGenerator.getVCard((String)name, (String)company, (String)title, (String)tel, (String)url, (String)email, (String)address, (String)address2, (String)memo);
        }
        return ContactInfoGenerator.getMeCard((String)name, (String)company, (String)title, (String)tel, (String)url, (String)email, (String)address, (String)address2, (String)memo);
    }

    private static String getMeCard(String name, String company, String title, String tel, String url, String email, String address, String address2, String memo) {
        StringBuilder output = new StringBuilder(100);
        output.append("MECARD:");
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"N", (String)name.replace(",", ""));
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"ORG", (String)company);
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"TEL", tel == null ? null : tel.replaceAll("[^0-9+]+", ""));
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"URL", (String)url);
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"EMAIL", (String)email);
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"ADR", (String)ContactInfoGenerator.buildAddress((String)address, (String)address2));
        StringBuilder memoContents = new StringBuilder();
        if (memo != null) {
            memoContents.append(memo);
        }
        if (title != null) {
            if (memoContents.length() > 0) {
                memoContents.append('\n');
            }
            memoContents.append(title);
        }
        ContactInfoGenerator.maybeAppendMECARD((StringBuilder)output, (String)"NOTE", (String)memoContents.toString());
        output.append(';');
        return output.toString();
    }

    private static String buildAddress(String address, String address2) {
        if (!address.isEmpty()) {
            if (!address2.isEmpty()) {
                return address + ' ' + address2;
            }
            return address;
        }
        if (!address2.isEmpty()) {
            return address2;
        }
        return "";
    }

    private static void maybeAppendMECARD(StringBuilder output, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            value = value.replaceAll("([\\\\:;])", "\\\\$1");
            value = value.replaceAll("\\n", "");
            output.append(prefix).append(':').append(value).append(';');
        }
    }

    private static String getVCard(String name, String company, String title, String tel, String url, String email, String address, String address2, String memo) {
        StringBuilder output = new StringBuilder(100);
        output.append("BEGIN:VCARD\n");
        output.append("VERSION:3.0\n");
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"N", (String)name);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"ORG", (String)company);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"TITLE", (String)title);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"TEL", (String)tel);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"URL", (String)url);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"EMAIL", (String)email);
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"ADR", (String)ContactInfoGenerator.buildAddress((String)address, (String)address2));
        ContactInfoGenerator.maybeAppendvCard((StringBuilder)output, (String)"NOTE", (String)memo);
        output.append("END:VCARD");
        return output.toString();
    }

    private static void maybeAppendvCard(StringBuilder output, String prefix, String value) {
        if (!value.isEmpty()) {
            value = value.replaceAll("([\\\\,;])", "\\\\$1");
            value = value.replaceAll("\\n", "\\\\n");
            output.append(prefix).append(':').append(value).append('\n');
        }
    }

    private String getNameField() throws GeneratorException {
        String input = this.name.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("Name must be at least 1 character.");
        }
        return input;
    }

    private String getCompanyField() {
        return this.company.getText();
    }

    private String getTitleField() {
        return this.title.getText();
    }

    private String getTelField() throws GeneratorException {
        String input = Validators.filterNumber((String)this.tel.getText());
        if (input.isEmpty()) {
            return "";
        }
        Validators.validateNumber((String)input);
        if (input.contains(";")) {
            throw new GeneratorException("Tel must not contains ; characters");
        }
        return input;
    }

    private String getUrlField() throws GeneratorException {
        String input = this.url.getText();
        if (input != null && !input.isEmpty()) {
            Validators.validateUrl((String)input);
        }
        return input;
    }

    private String getEmailField() throws GeneratorException {
        String input = this.email.getText();
        if (input.isEmpty()) {
            return "";
        }
        Validators.validateEmail((String)input);
        if (input.contains(";")) {
            throw new GeneratorException("Email must not contains ; characters");
        }
        return input;
    }

    private String getAddressField() {
        return this.address.getText();
    }

    private String getAddress2Field() {
        return this.address2.getText();
    }

    private String getMemoField() {
        return this.memo.getText();
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(10, 2);
        this.table.setText(0, 0, "Name");
        this.table.setWidget(0, 1, (Widget)this.name);
        this.table.setText(1, 0, "Company");
        this.table.setWidget(1, 1, (Widget)this.company);
        this.table.setText(2, 0, "Title");
        this.table.setWidget(2, 1, (Widget)this.title);
        this.table.setText(3, 0, "Phone number");
        this.table.setWidget(3, 1, (Widget)this.tel);
        this.table.setText(4, 0, "Email");
        this.table.setWidget(4, 1, (Widget)this.email);
        this.table.setText(5, 0, "Address");
        this.table.setWidget(5, 1, (Widget)this.address);
        this.table.setText(6, 0, "Address 2");
        this.table.setWidget(6, 1, (Widget)this.address2);
        this.table.setText(7, 0, "Website");
        this.table.setWidget(7, 1, (Widget)this.url);
        this.table.setText(8, 0, "Memo");
        this.table.setWidget(8, 1, (Widget)this.memo);
        this.table.setText(9, 0, "Encoding");
        this.table.setWidget(9, 1, (Widget)this.encoding);
        this.name.addStyleName("required");
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.name) {
            this.getNameField();
        }
        if (widget == this.company) {
            this.getCompanyField();
        }
        if (widget == this.title) {
            this.getTitleField();
        }
        if (widget == this.tel) {
            this.getTelField();
        }
        if (widget == this.email) {
            this.getEmailField();
        }
        if (widget == this.address) {
            this.getAddressField();
        }
        if (widget == this.address2) {
            this.getAddress2Field();
        }
        if (widget == this.url) {
            this.getUrlField();
        }
        if (widget == this.memo) {
            this.getMemoField();
        }
    }

    public void setFocus() {
        this.name.setFocus(true);
    }
}

