/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.CalendarEventGenerator;
import com.google.zxing.web.generator.client.ContactInfoGenerator;
import com.google.zxing.web.generator.client.EmailGenerator;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.GeoLocationGenerator;
import com.google.zxing.web.generator.client.PhoneNumberGenerator;
import com.google.zxing.web.generator.client.SmsAddressGenerator;
import com.google.zxing.web.generator.client.TextGenerator;
import com.google.zxing.web.generator.client.UrlGenerator;
import com.google.zxing.web.generator.client.WifiGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Generator
implements EntryPoint {
    private final List<GeneratorSource> generators = new ArrayList();
    private final ListBox genList = new ListBox();
    private final ListBox sizeList = new ListBox();
    private final ListBox ecLevelList = new ListBox();
    private final ListBox encodingList = new ListBox();
    private final Image result = new Image("");
    private final HTMLTable topPanel = new Grid(5, 1);
    private GeneratorSource selectedGenerator = null;
    private final VerticalPanel rightPanel = new VerticalPanel();
    private final TextBox urlResult = new TextBox();
    private final Widget downloadText = new HTML("<a href=\"\" id=\"downloadlink\" >Download</a> or embed with this URL:");
    private final TextArea rawTextResult = new TextArea();
    private final ChangeHandler changeHandler = new /* Unavailable Anonymous Inner Class!! */;
    private final KeyPressHandler keyPressHandler = new /* Unavailable Anonymous Inner Class!! */;

    public void onModuleLoad() {
        this.loadGenerators();
        this.setupLeftPanel();
        this.topPanel.getElement().setId("leftpanel");
        HTMLTable leftPanel = this.topPanel;
        HorizontalPanel mainPanel = new HorizontalPanel();
        mainPanel.add((Widget)leftPanel);
        SimplePanel div2 = new SimplePanel();
        div2.add((Widget)this.result);
        div2.getElement().setId("innerresult");
        SimplePanel div = new SimplePanel();
        div.add((Widget)div2);
        div.getElement().setId("imageresult");
        this.urlResult.getElement().setId("urlresult");
        this.rawTextResult.getElement().setId("rawtextresult");
        this.rawTextResult.setCharacterWidth(50);
        this.rawTextResult.setVisibleLines(8);
        this.downloadText.getElement().setId("downloadText");
        this.rightPanel.add((Widget)div);
        this.rightPanel.add(this.downloadText);
        this.rightPanel.add((Widget)this.urlResult);
        this.rightPanel.add((Widget)this.rawTextResult);
        mainPanel.add((Widget)this.rightPanel);
        mainPanel.getElement().setId("mainpanel");
        RootPanel.get((String)"ui").add((Widget)mainPanel);
        this.setWidget(1);
        this.invalidateBarcode();
    }

    private void setWidget(int id) {
        if (id >= 0 && id < this.generators.size()) {
            this.topPanel.setWidget(1, 0, (Widget)((GeneratorSource)this.generators.get(id)).getWidget());
            this.genList.setSelectedIndex(id);
            this.selectedGenerator = (GeneratorSource)this.generators.get(id);
            Generator.eraseErrorMessage();
            this.invalidateBarcode();
            this.genList.setFocus(false);
            this.selectedGenerator.setFocus();
        }
    }

    private void loadGenerators() {
        this.generators.add(new CalendarEventGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new ContactInfoGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new EmailGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new GeoLocationGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new PhoneNumberGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new SmsAddressGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new TextGenerator(this.changeHandler));
        this.generators.add(new UrlGenerator(this.changeHandler, this.keyPressHandler));
        this.generators.add(new WifiGenerator(this.changeHandler, this.keyPressHandler));
    }

    void setupLeftPanel() {
        this.topPanel.setHTML(2, 0, "<span id=\"errorMessageID\" class=\"errorMessage\"></span>");
        for (GeneratorSource generator : this.generators) {
            this.genList.addItem(generator.getName());
            Generator.setGridStyle((HTMLTable)generator.getWidget());
        }
        this.sizeList.addItem("Small", "120");
        this.sizeList.addItem("Medium", "230");
        this.sizeList.addItem("Large", "350");
        this.sizeList.setSelectedIndex(2);
        this.ecLevelList.addItem("L");
        this.ecLevelList.addItem("M");
        this.ecLevelList.addItem("Q");
        this.ecLevelList.addItem("H");
        this.ecLevelList.setSelectedIndex(0);
        this.encodingList.addItem("UTF-8");
        this.encodingList.addItem("ISO-8859-1");
        this.encodingList.addItem("Shift_JIS");
        this.encodingList.setSelectedIndex(0);
        this.genList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Grid selectionTable = new Grid(1, 2);
        selectionTable.setText(0, 0, "Contents");
        selectionTable.setWidget(0, 1, (Widget)this.genList);
        Generator.setGridStyle((HTMLTable)selectionTable);
        this.topPanel.setWidget(0, 0, (Widget)selectionTable);
        Grid generateGrid = new Grid(1, 2);
        Generator.setGridStyle((HTMLTable)generateGrid);
        Button generateButton = new Button("Generate &rarr;");
        generateButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        generateGrid.setWidget(0, 1, (Widget)generateButton);
        this.topPanel.setWidget(4, 0, (Widget)generateGrid);
        Grid configTable = new Grid(3, 2);
        configTable.setText(0, 0, "Barcode size");
        configTable.setWidget(0, 1, (Widget)this.sizeList);
        configTable.setText(1, 0, "Error correction");
        configTable.setWidget(1, 1, (Widget)this.ecLevelList);
        configTable.setText(2, 0, "Character encoding");
        configTable.setWidget(2, 1, (Widget)this.encodingList);
        Generator.setGridStyle((HTMLTable)configTable);
        this.topPanel.setWidget(3, 0, (Widget)configTable);
    }

    private static void setGridStyle(HTMLTable grid) {
        grid.getColumnFormatter().addStyleName(0, "firstColumn");
        grid.getColumnFormatter().addStyleName(1, "secondColumn");
        HTMLTable.CellFormatter cellFormatter = grid.getCellFormatter();
        for (int i = 0; i < grid.getRowCount(); ++i) {
            cellFormatter.addStyleName(i, 0, "firstColumn");
            cellFormatter.addStyleName(i, 1, "secondColumn");
        }
    }

    private static String getUrl(int sizeX, int sizeY, String ecLevel, String encoding, String content) {
        return "https://zxing.org/w/chart?cht=qr&chs=" + sizeX + 'x' + sizeY + "&chld=" + ecLevel + "&choe=" + encoding + "&chl=" + URL.encodeQueryString((String)content);
    }

    private void generate() {
        try {
            String text = this.selectedGenerator.getText();
            Generator.eraseErrorMessage();
            int size = Integer.parseInt(this.sizeList.getValue(this.sizeList.getSelectedIndex()));
            String ecLevel = this.ecLevelList.getValue(this.ecLevelList.getSelectedIndex());
            String encoding = this.encodingList.getValue(this.encodingList.getSelectedIndex());
            String url = Generator.getUrl((int)size, (int)size, (String)ecLevel, (String)encoding, (String)text);
            this.result.setUrl(url);
            this.result.setVisible(true);
            this.urlResult.setText(url);
            this.urlResult.setVisible(true);
            this.rawTextResult.setText(text);
            this.rawTextResult.setVisible(true);
            Element linkElement = DOM.getElementById((String)"downloadlink");
            linkElement.setAttribute("href", url);
            this.downloadText.setVisible(true);
        }
        catch (GeneratorException ex) {
            this.invalidateBarcode();
            String error = ex.getMessage();
            Generator.showErrorMessage((String)error);
        }
    }

    void invalidateBarcode() {
        this.result.setVisible(false);
        this.urlResult.setText("");
        this.urlResult.setVisible(false);
        this.rawTextResult.setText("");
        this.rawTextResult.setVisible(false);
        Element linkElement = DOM.getElementById((String)"downloadlink");
        linkElement.setAttribute("href", "");
        this.downloadText.setVisible(false);
    }

    private static void showErrorMessage(String error) {
        Element errorElement = DOM.getElementById((String)"errorMessageID");
        errorElement.setInnerHTML(error);
    }

    private static void eraseErrorMessage() {
        Element errorElement = DOM.getElementById((String)"errorMessageID");
        errorElement.setInnerHTML("&nbsp;");
    }

    static /* synthetic */ ListBox access$000(Generator x0) {
        return x0.genList;
    }

    static /* synthetic */ void access$100(Generator x0, int x1) {
        x0.setWidget(x1);
    }

    static /* synthetic */ void access$200(Generator x0) {
        x0.generate();
    }

    static /* synthetic */ GeneratorSource access$300(Generator x0) {
        return x0.selectedGenerator;
    }

    static /* synthetic */ void access$400() {
        Generator.eraseErrorMessage();
    }

    static /* synthetic */ void access$500(String x0) {
        Generator.showErrorMessage((String)x0);
    }
}

