/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.Validators;

public final class PhoneNumberGenerator
implements GeneratorSource {
    private Grid table;
    private final TextBox number = new TextBox();

    public PhoneNumberGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        this.number.addStyleName("required");
        this.number.addChangeHandler(handler);
        this.number.addKeyPressHandler(keyListener);
    }

    public String getName() {
        return "Phone number";
    }

    public String getText() throws GeneratorException {
        String tel = this.getTelField();
        return "tel:" + tel;
    }

    private String getTelField() throws GeneratorException {
        String input = this.number.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("Phone number must be present.");
        }
        input = Validators.filterNumber((String)input);
        Validators.validateNumber((String)input);
        return input;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(1, 2);
        this.table.setText(0, 0, "Phone number");
        this.table.setWidget(0, 1, (Widget)this.number);
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.number) {
            this.getTelField();
        }
    }

    public void setFocus() {
        this.number.setFocus(true);
    }
}

