/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.Validators;

public final class SmsAddressGenerator
implements GeneratorSource {
    private Grid table;
    private final TextBox number = new TextBox();
    private final TextArea message = new TextArea();

    public SmsAddressGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        this.number.addStyleName("required");
        this.number.addChangeHandler(handler);
        this.number.addKeyPressHandler(keyListener);
        this.message.addChangeHandler(handler);
    }

    public String getName() {
        return "SMS";
    }

    public String getText() throws GeneratorException {
        String inputNumber = this.getTelField();
        String inputMessage = this.getMessageField();
        String output = inputNumber;
        if (!inputMessage.isEmpty()) {
            output = output + ':' + inputMessage;
        }
        return "smsto:" + output;
    }

    private String getTelField() throws GeneratorException {
        String input = this.number.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("Phone number must be present.");
        }
        input = Validators.filterNumber((String)input);
        Validators.validateNumber((String)input);
        return input;
    }

    private String getMessageField() throws GeneratorException {
        String inputMessage = this.message.getText();
        if (inputMessage.length() > 150) {
            throw new GeneratorException("Sms message can not be longer than 150 characters.");
        }
        return inputMessage;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(2, 2);
        this.table.setText(0, 0, "Phone number");
        this.table.setWidget(0, 1, (Widget)this.number);
        this.table.setText(1, 0, "Message");
        this.table.setWidget(1, 1, (Widget)this.message);
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.number) {
            this.getTelField();
        }
        if (widget == this.message) {
            this.getMessageField();
        }
    }

    public void setFocus() {
        this.number.setFocus(true);
    }
}

