/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;

public final class TextGenerator
implements GeneratorSource {
    private Grid table;
    private final TextArea text = new TextArea();

    public TextGenerator(ChangeHandler handler) {
        this.text.addStyleName("required");
        this.text.addChangeHandler(handler);
        this.text.setVisibleLines(5);
    }

    public String getName() {
        return "Text";
    }

    public String getText() throws GeneratorException {
        return this.getTextField();
    }

    String getTextField() throws GeneratorException {
        String input = this.text.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("Text should be at least 1 character.");
        }
        return input;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(1, 2);
        this.table.getColumnFormatter().addStyleName(0, "firstColumn");
        this.table.setText(0, 0, "Text content");
        this.table.setWidget(0, 1, (Widget)this.text);
        return this.table;
    }

    public static String getErrorMessage() {
        return "";
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.text) {
            this.getTextField();
        }
    }

    public void setFocus() {
        this.text.setFocus(true);
    }
}

