/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.web.ChartServletRequestParameters;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
@WebServlet(value={"/w/chart", "/w/chart.png", "/w/chart.gif", "/w/chart.jpg", "/w/chart.jpeg"})
public final class ChartServlet
extends HttpServlet {
    private static final int MAX_DIMENSION = 4096;
    private static final Collection<Charset> SUPPORTED_OUTPUT_ENCODINGS = ImmutableSet.builder().add((Object)StandardCharsets.UTF_8).add((Object)StandardCharsets.ISO_8859_1).add((Object)Charset.forName("Shift_JIS")).build();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChartServlet.doEncode((HttpServletRequest)request, (HttpServletResponse)response, (boolean)false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChartServlet.doEncode((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
    }

    private static void doEncode(HttpServletRequest request, HttpServletResponse response, boolean isPost) throws IOException {
        String contentType;
        String imageFormat;
        BitMatrix matrix;
        ChartServletRequestParameters parameters;
        try {
            parameters = ChartServlet.doParseParameters((ServletRequest)request, (boolean)isPost);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            response.sendError(400, e.toString());
            return;
        }
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, (Object)parameters.getMargin());
        if (!StandardCharsets.ISO_8859_1.equals(parameters.getOutputEncoding())) {
            hints.put(EncodeHintType.CHARACTER_SET, (Object)parameters.getOutputEncoding().name());
        }
        hints.put(EncodeHintType.ERROR_CORRECTION, (Object)parameters.getEcLevel());
        try {
            matrix = new QRCodeWriter().encode(parameters.getText(), BarcodeFormat.QR_CODE, parameters.getWidth(), parameters.getHeight(), hints);
        }
        catch (WriterException we) {
            response.sendError(400, we.toString());
            return;
        }
        String requestURI = request.getRequestURI();
        if (requestURI == null) {
            response.sendError(400);
            return;
        }
        int lastDot = requestURI.lastIndexOf(46);
        if (lastDot > 0) {
            imageFormat = requestURI.substring(lastDot + 1).toUpperCase(Locale.ROOT);
            if ("JPG".equals(imageFormat)) {
                imageFormat = "JPEG";
            }
        } else {
            imageFormat = "PNG";
        }
        switch (imageFormat) {
            case "PNG": {
                contentType = "image/png";
                break;
            }
            case "JPEG": {
                contentType = "image/jpeg";
                break;
            }
            case "GIF": {
                contentType = "image/gif";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + imageFormat);
            }
        }
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream(1024);
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)imageFormat, (OutputStream)imageOut);
        byte[] imageData = imageOut.toByteArray();
        response.setContentType(contentType);
        response.setContentLength(imageData.length);
        response.setHeader("Cache-Control", "public");
        response.getOutputStream().write(imageData);
    }

    private static ChartServletRequestParameters doParseParameters(ServletRequest request, boolean readBody) throws IOException {
        Charset outputEncoding;
        String chartType = request.getParameter("cht");
        Preconditions.checkArgument((chartType == null || "qr".equals(chartType) ? 1 : 0) != 0, (Object)"Bad type");
        String widthXHeight = request.getParameter("chs");
        Preconditions.checkNotNull((Object)widthXHeight, (Object)"No size");
        int xIndex = widthXHeight.indexOf(120);
        Preconditions.checkArgument((xIndex >= 0 ? 1 : 0) != 0, (Object)"Bad size");
        int width = Integer.parseInt(widthXHeight.substring(0, xIndex));
        int height = Integer.parseInt(widthXHeight.substring(xIndex + 1));
        Preconditions.checkArgument((width > 0 && height > 0 ? 1 : 0) != 0, (Object)"Bad size");
        Preconditions.checkArgument((width <= 4096 && height <= 4096 ? 1 : 0) != 0, (Object)"Bad size");
        String outputEncodingName = request.getParameter("choe");
        if (outputEncodingName == null) {
            outputEncoding = StandardCharsets.UTF_8;
        } else {
            outputEncoding = Charset.forName(outputEncodingName);
            Preconditions.checkArgument((boolean)SUPPORTED_OUTPUT_ENCODINGS.contains(outputEncoding), (Object)"Bad output encoding");
        }
        ErrorCorrectionLevel ecLevel = ErrorCorrectionLevel.L;
        int margin = 4;
        String ldString = request.getParameter("chld");
        if (ldString != null) {
            int pipeIndex = ldString.indexOf(124);
            if (pipeIndex < 0) {
                ecLevel = ErrorCorrectionLevel.valueOf((String)ldString);
            } else {
                ecLevel = ErrorCorrectionLevel.valueOf((String)ldString.substring(0, pipeIndex));
                margin = Integer.parseInt(ldString.substring(pipeIndex + 1));
                Preconditions.checkArgument((margin > 0 ? 1 : 0) != 0, (Object)"Bad margin");
            }
        }
        String text = readBody ? CharStreams.toString((Readable)request.getReader()) : request.getParameter("chl");
        Preconditions.checkArgument((text != null && !text.isEmpty() ? 1 : 0) != 0, (Object)"No input");
        return new ChartServletRequestParameters(width, height, outputEncoding, ecLevel, margin, text);
    }
}

