/*
 * Copyright 2007 Daniel Armbrust 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package sqlWrapper;

/**
 * Constants for the SQL Wrapper Classes.
 * 
 * @author <A HREF="mailto:daniel.armbrust@gmail.com">Dan Armbrust</A>
 */
public class WrapperConstants
{
    protected static final int STRING     = 0;
    protected static final int BOOLEAN    = 1;
    protected static final int NULL       = 2;
    protected static final int TIME       = 3;
    protected static final int TIMESTAMP  = 4;
    protected static final int BYTE       = 5;
    protected static final int DOUBLE     = 6;
    protected static final int FLOAT      = 7;
    protected static final int INT        = 8;
    protected static final int LONG       = 9;
    protected static final int SHORT      = 10;
    protected static final int BYTES      = 11;
    protected static final int OBJECT     = 12;
    protected static final int BIGDECIMAL = 13;
    protected static final int ARRAY      = 14;
    protected static final int URL        = 15;
    protected static final int BLOB       = 16;
    protected static final int CLOB       = 17;
    protected static final int DATE       = 18;
    protected static final int REF        = 19;
}