/*
 * Decompiled with CFR 0.152.
 */
package sqlWrapper;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import sqlWrapper.WrappedPreparedStatement;

public class WrappedConnection
implements Connection {
    protected Connection connection_;
    private String userName_;
    private String password_;
    private String driver_;
    private String server_;
    private boolean useUTF8_ = false;
    private int maxFailCount_ = 3;
    public static final Logger logger = Logger.getLogger((String)"org.LexGrid.util.sql.sqlReconnect.WrappedConnection");
    private Integer holdability_;
    private Integer transactionIsoloation_;
    private Boolean autoCommit_;
    private Boolean readOnly_;
    private String catalog_;
    private Map typeMap_;

    public WrappedConnection(String userName, String password, String driver, String server) throws ClassNotFoundException, SQLException {
        logger.debug((Object)("Creating a new reconnectable SQL connection to " + server));
        this.userName_ = userName;
        this.password_ = password;
        this.driver_ = driver;
        this.server_ = server;
        this.useUTF8_ = false;
        if (this.userName_ == null) {
            this.userName_ = "";
        }
        if (this.password_ == null) {
            this.password_ = "";
        }
        this.connect();
    }

    public WrappedConnection(String userName, String password, String driver, String server, boolean useUTF8) throws ClassNotFoundException, SQLException {
        logger.debug((Object)("Creating a new reconnectable SQL connection to " + server));
        this.userName_ = userName;
        this.password_ = password;
        this.driver_ = driver;
        this.server_ = server;
        this.useUTF8_ = useUTF8;
        if (this.userName_ == null) {
            this.userName_ = "";
        }
        if (this.password_ == null) {
            this.password_ = "";
        }
        this.connect();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.debug((Object)("Creating reconnectable prepared statement: \"" + sql + "\""));
        return new WrappedPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug((Object)("Creating reconnectable prepared statement: \"" + sql + "\""));
        return new WrappedPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public int getHoldability() throws SQLException {
        return this.connection_.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection_.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.connection_.clearWarnings();
    }

    public void close() throws SQLException {
        this.connection_.close();
    }

    public void commit() throws SQLException {
        this.connection_.commit();
    }

    public void rollback() throws SQLException {
        this.connection_.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection_.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.connection_.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection_.isReadOnly();
    }

    public String getCatalog() throws SQLException {
        return this.connection_.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection_.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection_.getWarnings();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection_.rollback(savepoint);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.connection_.setHoldability(holdability);
        this.holdability_ = new Integer(holdability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection_.setTransactionIsolation(level);
        this.transactionIsoloation_ = new Integer(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection_.setAutoCommit(autoCommit);
        this.autoCommit_ = new Boolean(autoCommit);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection_.setReadOnly(readOnly);
        this.readOnly_ = new Boolean(readOnly);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection_.setCatalog(catalog);
        this.catalog_ = catalog;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection_.setTypeMap(map);
        this.typeMap_ = map;
    }

    private void setAllParameters() throws SQLException {
        logger.debug((Object)"Resetting all connection parameters");
        if (this.holdability_ != null) {
            this.connection_.setHoldability(this.holdability_);
        }
        if (this.transactionIsoloation_ != null) {
            this.connection_.setTransactionIsolation(this.transactionIsoloation_);
        }
        if (this.autoCommit_ != null) {
            this.connection_.setAutoCommit(this.autoCommit_);
        }
        if (this.readOnly_ != null) {
            this.connection_.setReadOnly(this.readOnly_);
        }
        if (this.catalog_ != null) {
            this.connection_.setCatalog(this.catalog_);
        }
        if (this.typeMap_ != null) {
            this.connection_.setTypeMap(this.typeMap_);
        }
    }

    private void connect() throws ClassNotFoundException, SQLException {
        try {
            Class.forName(this.driver_);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("The driver for your sql connection was not found.  I tried to load " + this.driver_));
            throw e;
        }
        DriverManager.setLoginTimeout(5);
        Properties props = new Properties();
        props.setProperty("user", this.userName_);
        props.setProperty("password", this.password_);
        if (this.useUTF8_) {
            WrappedConnection.setUTFCharsetForDB(props, this.server_);
        }
        this.connection_ = DriverManager.getConnection(this.server_, props);
    }

    protected void reconnect() throws SQLException {
        logger.debug((Object)"Reconnect called on SQL connection");
        int failCount = 0;
        while (true) {
            try {
                if (this.connection_ != null) {
                    this.connection_.close();
                    this.connection_ = null;
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                Properties props = new Properties();
                props.setProperty("user", this.userName_);
                props.setProperty("password", this.password_);
                if (this.useUTF8_) {
                    WrappedConnection.setUTFCharsetForDB(props, this.server_);
                }
                this.connection_ = DriverManager.getConnection(this.server_, props);
                this.setAllParameters();
            }
            catch (SQLException e) {
                logger.warn((Object)("Reconnect failed on attempt " + failCount));
                if (++failCount <= this.maxFailCount_) continue;
                throw e;
            }
            break;
        }
    }

    private static void setUTFCharsetForDB(Properties props, String URL2) {
        String tempURL = URL2.toLowerCase();
        if (tempURL.indexOf("odbc") != -1 || tempURL.indexOf("postgresql") != -1) {
            props.setProperty("charSet", "utf-8");
        } else if (tempURL.indexOf("mysql") != -1) {
            props.setProperty("characterEncoding", "UTF-8");
            props.setProperty("useUnicode", "true");
        } else {
            props.setProperty("charSet", "utf-8");
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint not yet implemented.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Method releaseSavepoint not yet implemented.");
    }

    public Statement createStatement() throws SQLException {
        throw new UnsupportedOperationException("Method createStatement not yet implemented.");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Method createStatement not yet implemented.");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method createStatement not yet implemented.");
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Method getTypeMap not yet implemented.");
    }

    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("Method nativeSQL not yet implemented.");
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Method prepareCall not yet implemented.");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Method prepareCall not yet implemented.");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method prepareCall not yet implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement not yet implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement not yet implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement not yet implemented.");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint not yet implemented.");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement not yet implemented.");
    }
}

