/*
 * Decompiled with CFR 0.152.
 */
package sqlWrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import sqlWrapper.WrappedConnection;

public class WrappedPreparedStatement
implements PreparedStatement {
    private PreparedStatement statement_;
    private WrappedConnection wrappedConnection_;
    private Hashtable setVariables_;
    private String sql_;
    private Integer fetchDirection_;
    private Integer fetchSize_;
    private Integer maxFieldSize_;
    private Integer maxRows_;
    private Integer queryTimeout_;
    private Integer resultSetType_;
    private Integer resultSetConcurrency_;
    public static final Logger logger = Logger.getLogger((String)"org.LexGrid.util.sql.sqlReconnect.WrappedPreparedStatement");
    Boolean escapeProcessing_;

    public WrappedPreparedStatement(WrappedConnection connection, String sql) throws SQLException {
        this.sql_ = sql;
        this.setVariables_ = new Hashtable();
        this.wrappedConnection_ = connection;
        this.statement_ = this.wrappedConnection_.connection_.prepareStatement(this.sql_);
    }

    public WrappedPreparedStatement(WrappedConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.sql_ = sql;
        this.resultSetType_ = new Integer(resultSetType);
        this.resultSetConcurrency_ = new Integer(resultSetConcurrency);
        this.setVariables_ = new Hashtable();
        this.wrappedConnection_ = connection;
        this.statement_ = this.wrappedConnection_.connection_.prepareStatement(this.sql_, resultSetType, resultSetConcurrency);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        QueryParameter temp = new QueryParameter(0, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        QueryParameter temp = new QueryParameter(1, new Boolean(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        QueryParameter temp = new QueryParameter(2, new Integer(sqlType));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        QueryParameter temp = new QueryParameter(3, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        QueryParameter temp = new QueryParameter(4, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        QueryParameter temp = new QueryParameter(5, new Byte(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        QueryParameter temp = new QueryParameter(6, new Double(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        QueryParameter temp = new QueryParameter(7, new Float(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        QueryParameter temp = new QueryParameter(8, new Integer(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        QueryParameter temp = new QueryParameter(9, new Long(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        QueryParameter temp = new QueryParameter(10, new Short(x));
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Byte[] temp1 = new Byte[x.length];
        for (int i = 0; i < temp1.length; ++i) {
            temp1[i] = new Byte(x[i]);
        }
        QueryParameter temp = new QueryParameter(11, temp1);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        QueryParameter temp = new QueryParameter(12, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        QueryParameter temp = new QueryParameter(12, x, targetSqlType);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        QueryParameter temp = new QueryParameter(13, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        QueryParameter temp = new QueryParameter(15, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        QueryParameter temp = new QueryParameter(14, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        QueryParameter temp = new QueryParameter(16, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        QueryParameter temp = new QueryParameter(17, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        QueryParameter temp = new QueryParameter(18, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        QueryParameter temp = new QueryParameter(19, x);
        this.setType(parameterIndex, temp);
        this.setVariables_.put(new Integer(parameterIndex), temp);
    }

    private void setType(int parameterIndex, QueryParameter value) throws SQLException {
        switch (value.type) {
            case 0: {
                this.statement_.setString(parameterIndex, (String)value.value);
                break;
            }
            case 1: {
                this.statement_.setBoolean(parameterIndex, (Boolean)value.value);
                break;
            }
            case 2: {
                this.statement_.setNull(parameterIndex, (Integer)value.value);
                break;
            }
            case 3: {
                this.statement_.setTime(parameterIndex, (Time)value.value);
                break;
            }
            case 4: {
                this.statement_.setTimestamp(parameterIndex, (Timestamp)value.value);
                break;
            }
            case 5: {
                this.statement_.setByte(parameterIndex, (Byte)value.value);
                break;
            }
            case 6: {
                this.statement_.setDouble(parameterIndex, (Double)value.value);
                break;
            }
            case 7: {
                this.statement_.setFloat(parameterIndex, ((Float)value.value).floatValue());
                break;
            }
            case 8: {
                this.statement_.setInt(parameterIndex, (Integer)value.value);
                break;
            }
            case 9: {
                this.statement_.setLong(parameterIndex, (Long)value.value);
                break;
            }
            case 10: {
                this.statement_.setShort(parameterIndex, (Short)value.value);
                break;
            }
            case 11: {
                Byte[] temp = (Byte[])value.value;
                byte[] temp1 = new byte[temp.length];
                for (int i = 0; i < temp1.length; ++i) {
                    temp1[i] = temp[i];
                }
                this.statement_.setBytes(parameterIndex, temp1);
                break;
            }
            case 12: {
                if (value.targetType != Integer.MIN_VALUE) {
                    this.statement_.setObject(parameterIndex, value.value, value.targetType);
                    break;
                }
                this.statement_.setObject(parameterIndex, value.value);
                break;
            }
            case 13: {
                this.statement_.setBigDecimal(parameterIndex, (BigDecimal)value.value);
                break;
            }
            case 15: {
                this.statement_.setURL(parameterIndex, (URL)value.value);
                break;
            }
            case 14: {
                this.statement_.setArray(parameterIndex, (Array)value.value);
                break;
            }
            case 16: {
                this.statement_.setBlob(parameterIndex, (Blob)value.value);
                break;
            }
            case 17: {
                this.statement_.setClob(parameterIndex, (Clob)value.value);
                break;
            }
            case 18: {
                this.statement_.setDate(parameterIndex, (Date)value.value);
                break;
            }
            case 19: {
                this.statement_.setRef(parameterIndex, (Ref)value.value);
                break;
            }
            default: {
                throw new SQLException("Unknown object type passed through WrappedPreparedStatment");
            }
        }
    }

    public void close() throws SQLException {
        this.statement_.close();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.statement_.setFetchDirection(direction);
        this.fetchDirection_ = new Integer(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.statement_.setFetchSize(rows);
        this.fetchSize_ = new Integer(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.statement_.setMaxFieldSize(max);
        this.maxFieldSize_ = new Integer(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.statement_.setMaxRows(max);
        this.maxRows_ = new Integer(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement_.setQueryTimeout(seconds);
        this.queryTimeout_ = new Integer(seconds);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement_.setEscapeProcessing(enable);
        this.escapeProcessing_ = new Boolean(enable);
    }

    public Connection getConnection() throws SQLException {
        return this.wrappedConnection_;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement_.getGeneratedKeys();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement_.getResultSet();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement_.getWarnings();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement_.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement_.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.statement_.getResultSetType();
    }

    public int getFetchDirection() throws SQLException {
        return this.statement_.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.statement_.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement_.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement_.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement_.getQueryTimeout();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement_.getUpdateCount();
    }

    public void cancel() throws SQLException {
        this.statement_.cancel();
    }

    public void clearBatch() throws SQLException {
        this.statement_.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.statement_.clearWarnings();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement_.getMoreResults();
    }

    public void clearParameters() throws SQLException {
        this.setVariables_.clear();
        this.statement_.clearParameters();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement_.getMetaData();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.statement_.getMoreResults(current);
    }

    private void setAllParameters() throws SQLException {
        logger.debug((Object)"Resetting all prepared statement parameters");
        if (this.fetchDirection_ != null) {
            this.statement_.setFetchDirection(this.fetchDirection_);
        }
        if (this.fetchSize_ != null) {
            this.statement_.setFetchSize(this.fetchSize_);
        }
        if (this.maxFieldSize_ != null) {
            this.statement_.setMaxFieldSize(this.maxFieldSize_);
        }
        if (this.maxRows_ != null) {
            this.statement_.setMaxRows(this.maxRows_);
        }
        if (this.queryTimeout_ != null) {
            this.statement_.setQueryTimeout(this.queryTimeout_);
        }
        if (this.escapeProcessing_ != null) {
            this.statement_.setEscapeProcessing(this.escapeProcessing_);
        }
    }

    private void setAllVariables() throws SQLException {
        logger.debug((Object)"Resetting all prepared statement variable values");
        Enumeration enumerator = this.setVariables_.keys();
        while (enumerator.hasMoreElements()) {
            Integer index = (Integer)enumerator.nextElement();
            this.setType(index, (QueryParameter)this.setVariables_.get(index));
        }
    }

    private void rebuildStatement() throws SQLException {
        logger.debug((Object)"recreating the prepared statement");
        this.statement_ = this.resultSetConcurrency_ != null && this.resultSetType_ != null ? this.wrappedConnection_.connection_.prepareStatement(this.sql_, this.resultSetType_, this.resultSetConcurrency_) : this.wrappedConnection_.connection_.prepareStatement(this.sql_);
    }

    private void rebuildAll() throws SQLException {
        boolean recreatedConnection = false;
        boolean isClosed = false;
        try {
            isClosed = this.wrappedConnection_.isClosed();
        }
        catch (SQLException e) {
            isClosed = true;
        }
        if (isClosed) {
            this.wrappedConnection_.reconnect();
            recreatedConnection = true;
        }
        try {
            this.statement_.close();
            this.statement_ = null;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        try {
            this.rebuildStatement();
        }
        catch (SQLException e) {
            if (!recreatedConnection) {
                this.wrappedConnection_.reconnect();
                this.rebuildStatement();
            }
            throw e;
        }
        this.setAllVariables();
        this.setAllParameters();
    }

    private String toString(String sql, boolean throwException) throws SQLException {
        if (sql == null) {
            sql = "";
        }
        StringBuffer temp = new StringBuffer("WrappedPreparedStatement - query: \"" + sql + "\"");
        int parameterIndex = 1;
        for (int i = 0; i < temp.length(); ++i) {
            QueryParameter para;
            if (temp.charAt(i) != '?') continue;
            if ((para = (QueryParameter)this.setVariables_.get(new Integer(parameterIndex++))) == null) {
                if (throwException) {
                    throw new SQLException("You forgot to set parameter " + parameterIndex);
                }
                para = new QueryParameter(0, "--UNSET_PARAMETER--");
            }
            String replacementValue = "";
            replacementValue = para.type == 2 ? "'null'" : "'" + (para.value == null ? "null" : para.value.toString()) + "'";
            temp.replace(i, i + 1, replacementValue);
            i += replacementValue.length();
        }
        return temp.toString();
    }

    public String toString() {
        try {
            return this.toString(this.sql_, false);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private void debugQuery(String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing query: " + this.toString(sql, true)));
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.debugQuery(this.sql_);
        try {
            return this.statement_.executeQuery();
        }
        catch (Exception e) {
            try {
                this.rebuildAll();
                return this.statement_.executeQuery();
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.debugQuery(sql);
        try {
            return this.statement_.executeQuery(sql);
        }
        catch (Exception e) {
            try {
                this.rebuildAll();
                return this.statement_.executeQuery(sql);
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public boolean execute(String sql) throws SQLException {
        this.debugQuery(sql);
        try {
            return this.statement_.execute(sql);
        }
        catch (SQLException e) {
            try {
                this.rebuildAll();
                return this.statement_.execute(sql);
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public int executeUpdate() throws SQLException {
        this.debugQuery(this.sql_);
        try {
            return this.statement_.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.rebuildAll();
                return this.statement_.executeUpdate();
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.debugQuery(sql);
        try {
            return this.statement_.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.rebuildAll();
                return this.statement_.executeUpdate(sql);
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException("Method addBatch not yet implemented.");
    }

    public boolean execute() throws SQLException {
        this.debugQuery(this.sql_);
        try {
            return this.statement_.execute();
        }
        catch (SQLException e) {
            try {
                this.rebuildAll();
                return this.statement_.execute();
            }
            catch (SQLException e1) {
                if (e instanceof SQLException) {
                    throw e;
                }
                throw new SQLException("Unexpected Error " + e.toString());
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Method setAsciiStream not yet implemented.");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Method setBinaryStream not yet implemented.");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Method setUnicodeStream not yet implemented.");
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("Method setCharacterStream not yet implemented.");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        throw new UnsupportedOperationException("Method setObject not yet implemented.");
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw new UnsupportedOperationException("Method setNull not yet implemented.");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("Method getParameterMetaData not yet implemented.");
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Method setDate not yet implemented.");
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Method setTime not yet implemented.");
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Method setTimestamp not yet implemented.");
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("Method executeBatch not yet implemented.");
    }

    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("Method addBatch not yet implemented.");
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Method setCursorName not yet implemented.");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Method executeUpdate not yet implemented.");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Method execute not yet implemented.");
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Method executeUpdate not yet implemented.");
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Method execute not yet implemented.");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Method executeUpdate not yet implemented.");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Method execute not yet implemented.");
    }

    private class QueryParameter {
        int type;
        Object value;
        int targetType;

        public QueryParameter(int type, Object value) {
            this.type = type;
            this.value = value;
            this.targetType = Integer.MIN_VALUE;
        }

        public QueryParameter(int type, Object value, int targetSqlType) {
            this.type = type;
            this.value = value;
            this.targetType = targetSqlType;
        }
    }
}

