/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Mojos;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE)
public class CompileMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private String config;
    @Parameter
    private String target;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private Map<String, String> environmentVariables;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private List<String> options;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private File projectDirectory;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            int returnCode;
            Log log;
            if (!this.projectDirectory.exists()) {
                throw new MojoExecutionException(this.projectDirectory.getAbsolutePath() + " does not exist");
            }
            if (!this.projectDirectory.isDirectory()) {
                throw new MojoExecutionException(this.projectDirectory.getAbsolutePath() + " must be a directory");
            }
            Path cmakeDir = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake").toAbsolutePath();
            ProcessBuilder processBuilder = new ProcessBuilder(cmakeDir.resolve("bin/cmake").toString(), "--build", this.projectDirectory.getPath());
            if (this.target != null) {
                Collections.addAll(processBuilder.command(), "--target", this.target);
            }
            if (this.config != null) {
                Collections.addAll(processBuilder.command(), "--config", this.config);
            }
            if (this.options != null) {
                processBuilder.command().addAll(this.options);
            }
            Map<String, String> env = processBuilder.environment();
            if (this.environmentVariables != null) {
                env.putAll(this.environmentVariables);
            }
            if ((log = this.getLog()).isDebugEnabled()) {
                log.debug((CharSequence)("projectDirectory: " + this.projectDirectory));
                log.debug((CharSequence)("target: " + this.target));
                log.debug((CharSequence)("config: " + this.config));
                log.debug((CharSequence)("environment: " + processBuilder.environment()));
                log.debug((CharSequence)("command-line: " + processBuilder.command()));
            }
            if ((returnCode = Mojos.waitFor(processBuilder)) != 0) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

