/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Mojos;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="classifier", readonly=true)
    private String classifier;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private File sourcePath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private File targetPath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private String generator;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private Map<String, String> environmentVariables;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private List<String> options;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Component
    private BuildPluginManager pluginManager;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        try {
            int returnCode;
            Log log;
            PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
            String groupId = pluginDescriptor.getGroupId();
            String version = pluginDescriptor.getVersion();
            if (!this.targetPath.exists() && !this.targetPath.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.targetPath.getAbsolutePath());
            }
            if (this.classifier == null) {
                String os = System.getProperty("os.name");
                if (os.toLowerCase().startsWith("windows")) {
                    this.classifier = "windows";
                } else if (os.toLowerCase().startsWith("linux")) {
                    this.classifier = "linux";
                } else if (os.toLowerCase().startsWith("mac")) {
                    this.classifier = "mac";
                } else {
                    throw new MojoExecutionException("Unsupported os.name: " + os);
                }
            }
            Path cmakeDir = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake").toAbsolutePath();
            String binariesArtifact = "cmake-binaries";
            MojoExecutor.Element groupIdElement = new MojoExecutor.Element("groupId", groupId, new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactIdElement = new MojoExecutor.Element("artifactId", binariesArtifact, new MojoExecutor.Element[0]);
            MojoExecutor.Element versionElement = new MojoExecutor.Element("version", version, new MojoExecutor.Element[0]);
            MojoExecutor.Element classifierElement = new MojoExecutor.Element("classifier", this.classifier, new MojoExecutor.Element[0]);
            MojoExecutor.Element outputDirectoryElement = new MojoExecutor.Element("outputDirectory", cmakeDir.toString(), new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactItemElement = new MojoExecutor.Element("artifactItem", new MojoExecutor.Element[]{groupIdElement, artifactIdElement, versionElement, classifierElement, outputDirectoryElement});
            MojoExecutor.Element artifactItemsItem = new MojoExecutor.Element("artifactItems", new MojoExecutor.Element[]{artifactItemElement});
            Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{artifactItemsItem});
            MojoExecutor.ExecutionEnvironment environment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
            Plugin dependencyPlugin = MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"2.8");
            MojoExecutor.executeMojo((Plugin)dependencyPlugin, (String)"unpack", (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)environment);
            ProcessBuilder processBuilder = new ProcessBuilder(cmakeDir.resolve("bin/cmake").toString(), "-G", this.generator).directory(this.targetPath);
            if (this.options != null) {
                processBuilder.command().addAll(this.options);
            }
            processBuilder.command().add(this.sourcePath.getAbsolutePath());
            Map<String, String> env = processBuilder.environment();
            if (this.environmentVariables != null) {
                env.putAll(this.environmentVariables);
            }
            if ((log = this.getLog()).isDebugEnabled()) {
                log.debug((CharSequence)("sourcePath: " + this.sourcePath));
                log.debug((CharSequence)("targetPath: " + this.targetPath));
                log.debug((CharSequence)("environment: " + processBuilder.environment()));
                log.debug((CharSequence)("command-line: " + processBuilder.command()));
            }
            if ((returnCode = Mojos.waitFor(processBuilder)) != 0) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

