/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Platform;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class CmakeMojo
extends AbstractMojo {
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="cmake.download", defaultValue="true")
    private boolean downloadBinaries;
    @Parameter(property="cmake.dir")
    private String cmakeDir;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private List<String> options;
    private final Platform platform = Platform.detected();

    protected void downloadBinariesIfNecessary() throws MojoExecutionException {
        Log log = this.getLog();
        log.debug((CharSequence)("downloadBinaries: " + this.downloadBinaries));
        if (!this.downloadBinaries) {
            return;
        }
        Path outputDirectory = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake");
        this.downloadBinaries(outputDirectory);
    }

    private void downloadBinaries(Path outputDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Downloading binaries to " + outputDirectory));
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        String groupId = pluginDescriptor.getGroupId();
        String version = pluginDescriptor.getVersion();
        String binariesArtifact = "cmake-binaries";
        MojoExecutor.Element groupIdElement = new MojoExecutor.Element("groupId", groupId, new MojoExecutor.Element[0]);
        MojoExecutor.Element artifactIdElement = new MojoExecutor.Element("artifactId", binariesArtifact, new MojoExecutor.Element[0]);
        MojoExecutor.Element versionElement = new MojoExecutor.Element("version", version, new MojoExecutor.Element[0]);
        MojoExecutor.Element classifierElement = new MojoExecutor.Element("classifier", this.platform.getClassifier(), new MojoExecutor.Element[0]);
        MojoExecutor.Element outputDirectoryElement = new MojoExecutor.Element("outputDirectory", outputDirectory.toString(), new MojoExecutor.Element[0]);
        MojoExecutor.Element artifactItemElement = new MojoExecutor.Element("artifactItem", new MojoExecutor.Element[]{groupIdElement, artifactIdElement, versionElement, classifierElement, outputDirectoryElement});
        MojoExecutor.Element artifactItemsItem = new MojoExecutor.Element("artifactItems", new MojoExecutor.Element[]{artifactItemElement});
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{artifactItemsItem});
        MojoExecutor.ExecutionEnvironment environment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
        Plugin dependencyPlugin = MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"3.6.0");
        MojoExecutor.executeMojo((Plugin)dependencyPlugin, (String)"unpack", (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)environment);
    }

    public Path getBinaryPath(String filename, ProcessBuilder processBuilder) throws FileNotFoundException {
        Log log = this.getLog();
        Path cmakeDir = this.getCmakeDir();
        if (cmakeDir == null) {
            log.info((CharSequence)("Executing " + filename + " on PATH"));
            String path = this.platform.getEnvironment(processBuilder, "PATH");
            if (path == null) {
                throw new IllegalArgumentException("PATH not found\nenv: " + processBuilder.environment());
            }
            return this.platform.getExecutableOnPath(filename, path);
        }
        Path result = cmakeDir.resolve(filename + this.platform.getExecutableSuffix());
        log.info((CharSequence)("Executing " + result));
        return result;
    }

    private Path getCmakeDir() {
        Log log = this.getLog();
        log.debug((CharSequence)("downloadBinaries: " + this.downloadBinaries));
        if (this.downloadBinaries) {
            Path outputDirectory = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake");
            return outputDirectory.resolve("bin");
        }
        if (this.cmakeDir == null) {
            return null;
        }
        return Paths.get(this.cmakeDir, new String[0]);
    }

    public void addOptions(ProcessBuilder processBuilder) {
        if (this.options == null) {
            return;
        }
        List nonEmptyOptions = this.options.stream().filter(option -> !option.isEmpty()).collect(Collectors.toList());
        processBuilder.command().addAll(nonEmptyOptions);
    }

    public void overrideEnvironmentVariables(ProcessBuilder processBuilder) {
        if (this.environmentVariables == null) {
            return;
        }
        this.platform.overrideEnvironmentVariables(this.environmentVariables, processBuilder);
    }
}

