/*
 * Decompiled with CFR 0.152.
 */
package com.github.cmake.maven.project.maven.plugin;

import com.github.cmake.maven.project.common.Mojos;
import com.github.cmake.maven.project.maven.plugin.CmakeMojo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE)
public class CompileMojo
extends CmakeMojo {
    @Parameter
    private String config;
    @Parameter
    private String target;
    @Parameter(required=true)
    private File projectDirectory;

    @Inject
    public CompileMojo(MavenProject project, MavenSession session, BuildPluginManager pluginManager) {
        super(project, session, pluginManager);
    }

    public void execute() throws MojoExecutionException {
        try {
            int returnCode;
            if (!this.projectDirectory.exists()) {
                throw new MojoExecutionException(this.projectDirectory.getAbsolutePath() + " does not exist");
            }
            if (!this.projectDirectory.isDirectory()) {
                throw new MojoExecutionException(this.projectDirectory.getAbsolutePath() + " must be a directory");
            }
            this.downloadBinariesIfNecessary();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            this.overrideEnvironmentVariables(processBuilder);
            String cmakePath = this.getBinaryPath("cmake", processBuilder).toString();
            processBuilder.command().add(cmakePath);
            Collections.addAll(processBuilder.command(), "--build", this.projectDirectory.getPath());
            if (this.target != null) {
                Collections.addAll(processBuilder.command(), "--target", this.target);
            }
            if (this.config != null) {
                Collections.addAll(processBuilder.command(), "--config", this.config);
            }
            this.addOptions(processBuilder);
            Log log = this.getLog();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("projectDirectory: " + this.projectDirectory));
                log.debug((CharSequence)("target: " + this.target));
                log.debug((CharSequence)("config: " + this.config));
                log.debug((CharSequence)("Environment: " + processBuilder.environment()));
                log.debug((CharSequence)("Command-line: " + processBuilder.command()));
            }
            if ((returnCode = Mojos.waitFor((ProcessBuilder)processBuilder, (Log)this.getLog())) != 0) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("", e);
        }
    }
}

