/*
 * Decompiled with CFR 0.152.
 */
package com.github.cmake.maven.project.maven.plugin;

import com.github.cmake.maven.project.common.Mojos;
import com.github.cmake.maven.project.maven.plugin.CmakeMojo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateMojo
extends CmakeMojo {
    @Parameter(required=true)
    private File sourcePath;
    @Parameter(required=true)
    private File targetPath;
    @Parameter
    private String generator;

    @Inject
    public GenerateMojo(MavenProject project, BuildPluginManager pluginManager, MavenSession session) {
        super(project, session, pluginManager);
    }

    public void execute() throws MojoExecutionException {
        try {
            int returnCode;
            if (!this.sourcePath.exists()) {
                throw new MojoExecutionException("sourcePath does not exist: " + this.sourcePath.getAbsolutePath());
            }
            if (!this.targetPath.exists() && !this.targetPath.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.targetPath.getAbsolutePath());
            }
            this.downloadBinariesIfNecessary();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.targetPath);
            this.overrideEnvironmentVariables(processBuilder);
            String cmakePath = this.getBinaryPath("cmake", processBuilder).toString();
            processBuilder.command().add(cmakePath);
            if (this.generator != null && !this.generator.trim().isEmpty()) {
                Collections.addAll(processBuilder.command(), "-G", this.generator);
            }
            this.addOptions(processBuilder);
            processBuilder.command().add(this.sourcePath.getAbsolutePath());
            Log log = this.getLog();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("sourcePath: " + this.sourcePath));
                log.debug((CharSequence)("targetPath: " + this.targetPath));
                log.debug((CharSequence)("Environment: " + processBuilder.environment()));
                log.debug((CharSequence)("Command-line: " + processBuilder.command()));
            }
            if ((returnCode = Mojos.waitFor((ProcessBuilder)processBuilder, (Log)this.getLog())) != 0) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("", e);
        }
    }
}

