/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Mojos;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private File sourcePath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private File targetPath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(required=true)
    private String generator;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private Map<String, String> environmentVariables;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter
    private List<String> options;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Component
    private BuildPluginManager pluginManager;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="download.cmake", defaultValue="true", required=false)
    private boolean downloadBinaries;
    @Parameter(property="cmake.root.dir", defaultValue="/usr", required=false)
    private String cmakeRootDir;
    @Parameter(property="cmake.child.dir", defaultValue="bin/cmake", required=false)
    private String cmakeChildDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        try {
            int returnCode;
            Log log;
            File cmakeDir;
            if (!this.downloadBinaries) {
                this.getLog().info((CharSequence)" **** Using Native CMake");
            }
            PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
            String groupId = pluginDescriptor.getGroupId();
            String version = pluginDescriptor.getVersion();
            String classifier = this.getClassifier();
            if (!this.targetPath.exists() && !this.targetPath.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.targetPath.getAbsolutePath());
            }
            if (classifier == null) {
                String os = System.getProperty("os.name");
                String arch = System.getProperty("os.arch");
                if (os.toLowerCase().startsWith("windows")) {
                    classifier = "windows";
                } else if (os.toLowerCase().startsWith("linux")) {
                    if (arch.equals("x86_64") || arch.equals("amd64")) {
                        classifier = "linux64";
                    } else {
                        if (!arch.equals("i386") && !arch.equals("arm")) throw new MojoExecutionException("Unsupported Linux arch: " + arch);
                        classifier = "linux32";
                    }
                } else {
                    if (!os.toLowerCase().startsWith("mac")) throw new MojoExecutionException("Unsupported os.name: " + os);
                    if (!arch.equals("x86_64")) throw new MojoExecutionException("Unsupported Mac arch: " + arch);
                    classifier = "mac64";
                }
            }
            File file = cmakeDir = this.downloadBinaries ? new File(this.project.getBuild().getDirectory(), "dependency/cmake") : new File(this.cmakeRootDir);
            if (!this.downloadBinaries) {
                this.getLog().info((CharSequence)" **** Using Native CMake");
            }
            String binariesArtifact = "cmake-binaries";
            MojoExecutor.Element groupIdElement = new MojoExecutor.Element("groupId", groupId, new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactIdElement = new MojoExecutor.Element("artifactId", binariesArtifact, new MojoExecutor.Element[0]);
            MojoExecutor.Element versionElement = new MojoExecutor.Element("version", version, new MojoExecutor.Element[0]);
            MojoExecutor.Element classifierElement = new MojoExecutor.Element("classifier", classifier, new MojoExecutor.Element[0]);
            MojoExecutor.Element outputDirectoryElement = new MojoExecutor.Element("outputDirectory", cmakeDir.getAbsolutePath(), new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactItemElement = new MojoExecutor.Element("artifactItem", new MojoExecutor.Element[]{groupIdElement, artifactIdElement, versionElement, classifierElement, outputDirectoryElement});
            MojoExecutor.Element artifactItemsItem = new MojoExecutor.Element("artifactItems", new MojoExecutor.Element[]{artifactItemElement});
            Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{artifactItemsItem});
            if (this.downloadBinaries) {
                MojoExecutor.ExecutionEnvironment environment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
                Plugin dependencyPlugin = MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"2.8");
                MojoExecutor.executeMojo((Plugin)dependencyPlugin, (String)"unpack", (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)environment);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new File(cmakeDir, this.cmakeChildDir).getAbsolutePath(), "-G", this.generator).directory(this.targetPath);
            if (this.options != null) {
                processBuilder.command().addAll(this.options);
            }
            processBuilder.command().add(this.sourcePath.getAbsolutePath());
            Map<String, String> env = processBuilder.environment();
            if (this.environmentVariables != null) {
                env.putAll(this.environmentVariables);
            }
            if ((log = this.getLog()).isDebugEnabled()) {
                log.debug((CharSequence)("sourcePath: " + this.sourcePath));
                log.debug((CharSequence)("targetPath: " + this.targetPath));
                log.debug((CharSequence)("environment: " + processBuilder.environment()));
                log.debug((CharSequence)("command-line: " + processBuilder.command()));
            }
            if ((returnCode = Mojos.waitFor(processBuilder)) == 0) return;
            throw new MojoExecutionException("Return code: " + returnCode);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private String getClassifier() {
        for (Profile profile : this.project.getActiveProfiles()) {
            String id = profile.getId();
            if (!id.equals("linux32") && !id.equals("linux64") && !id.equals("mac64") && !id.equals("windows")) continue;
            return id;
        }
        return null;
    }
}

