/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Mojos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends AbstractMojo {
    @Parameter(property="ctest.build.dir", required=true)
    private File buildDirectory;
    @Component
    private MavenProject project;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(property="ctest.skip.tests", defaultValue="false")
    private boolean ctestSkip;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="threadCount", defaultValue="0")
    private int threadCount;
    @Parameter(property="dashboard")
    private String dashboard;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private List<String> options;
    @Parameter(property="download.cmake", defaultValue="true")
    private boolean downloadBinaries;
    @Parameter(property="cmake.root.dir", defaultValue="/usr", required=false)
    private String cmakeRootDir;
    @Parameter(property="cmake.child.dir", defaultValue="bin/cmake", required=false)
    private String cmakeChildDir;
    @Parameter(property="cmake.ctest.dir", defaultValue="/", required=false)
    private String ctestChildDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skipTests || this.ctestSkip) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)"Tests are skipped.");
            }
            return;
        }
        if (this.threadCount == 0) {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
        try {
            ArrayList<String> args;
            String threadCountString = Integer.toString(this.threadCount);
            String projBuildDir = this.project.getBuild().getDirectory();
            String buildDir = this.buildDirectory.getAbsolutePath();
            if (!this.buildDirectory.exists()) {
                throw new MojoExecutionException(buildDir + " does not exist");
            }
            if (!this.buildDirectory.isDirectory()) {
                throw new MojoExecutionException(buildDir + " isn't directory");
            }
            if (this.downloadBinaries) {
                File path = new File(projBuildDir, "dependency/cmake").getAbsoluteFile();
                args = new ArrayList<String>(Arrays.asList(new File(new File(projBuildDir, "dependency/cmake").getAbsoluteFile(), "bin/ctest").getAbsolutePath(), "-T", "Test", "-j", threadCountString));
            } else {
                File path = new File(this.cmakeRootDir, this.cmakeChildDir).getAbsoluteFile();
                args = new ArrayList<String>(Arrays.asList(new File(new File(this.cmakeRootDir, this.ctestChildDir).getAbsoluteFile(), "bin/ctest").getAbsolutePath(), "-T", "Test", "-j", threadCountString));
            }
            if (this.dashboard != null) {
                args.addAll(Arrays.asList("-D", this.dashboard));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.directory(this.buildDirectory);
            if (this.options != null) {
                processBuilder.command().addAll(this.options);
            }
            Map<String, String> env = processBuilder.environment();
            if (this.environmentVariables != null) {
                env.putAll(this.environmentVariables);
            }
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("CTest build directory: " + buildDir));
                log.debug((CharSequence)("Number of threads used: " + this.threadCount));
                log.debug((CharSequence)("Environment: " + processBuilder.environment()));
                log.debug((CharSequence)("Command-line: " + processBuilder.command()));
            }
            int returnCode = Mojos.waitFor(processBuilder);
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/ct2ju.xslt");
            TransformerFactory tf = TransformerFactory.newInstance();
            StreamSource xsltSource = new StreamSource(stream);
            Transformer transformer = tf.newTransformer(xsltSource);
            File tagFile = new File(this.buildDirectory, "/Testing/TAG");
            Charset charset = Charset.defaultCharset();
            FileInputStream fis = new FileInputStream(tagFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
            BufferedReader tagReader = new BufferedReader(isr);
            String tag = tagReader.readLine();
            tagReader.close();
            if (tag == null || tag.trim().length() == 0) {
                throw new IOException("Couldn't read ctest TAG file");
            }
            String xmlTestFilePath = "/Testing/" + tag + "/Test.xml";
            File xmlSource = new File(this.buildDirectory, xmlTestFilePath);
            StreamSource source = new StreamSource(xmlSource);
            File reportsDir = new File(projBuildDir, "surefire-reports");
            File xmlReport = new File(reportsDir, "CTestResults.xml");
            StreamResult result = new StreamResult(xmlReport);
            if (!reportsDir.exists() && !reportsDir.mkdirs()) {
                throw new IOException("Couldn't create " + reportsDir);
            }
            transformer.transform(source, result);
            if (returnCode != 0 && !this.testFailureIgnore) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

