/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.crowdin.maven;

import com.googlecode.crowdin.maven.tool.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AggregateCrowdinMojo
extends AbstractMojo {
    private static final String DEFAULT_LANG = "en";
    public static final String COMMENT = "This file is automatically generated. Please do not edit this file. If you'd like to change the content please use crowdin";
    private MavenProject project;
    private File resourceAggregatedOutputDirectory;
    protected File messagesOutputDirectory;

    public void setResourceAggregatedOutputDirectory(File resourceAggregatedOutputDirectory) {
        this.resourceAggregatedOutputDirectory = resourceAggregatedOutputDirectory;
    }

    public void setMessagesOutputDirectory(File messagesOutputDirectory) {
        this.messagesOutputDirectory = messagesOutputDirectory;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.messagesOutputDirectory.exists()) {
            File langFold;
            this.getLog().info((CharSequence)"Aggregating all message properties from dependencies");
            String[] langFolders = this.messagesOutputDirectory.list();
            SortedProperties defaultProperties = new SortedProperties();
            for (String langFolder : langFolders) {
                if (!langFolder.equals(DEFAULT_LANG)) continue;
                langFold = new File(this.messagesOutputDirectory, langFolder);
                defaultProperties.putAll((Map<?, ?>)this.aggregatePropertiesFolder(langFold, langFolder, null));
            }
            for (String langFolder : langFolders) {
                if (langFolder.startsWith(".") || langFolder.equals(DEFAULT_LANG) || !(langFold = new File(this.messagesOutputDirectory, langFolder)).isDirectory()) continue;
                this.aggregatePropertiesFolder(langFold, langFolder, defaultProperties);
            }
            Resource resource = new Resource();
            resource.setDirectory(this.resourceAggregatedOutputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        } else {
            this.getLog().info((CharSequence)("Crowdin folder does not exist (" + this.messagesOutputDirectory + "). Call pull before."));
        }
    }

    private SortedProperties aggregatePropertiesFolder(File langFolder, String lang, SortedProperties defaultProperties) throws MojoExecutionException {
        SortedProperties properties = new SortedProperties();
        if (defaultProperties != null) {
            properties.putAll((Map<?, ?>)defaultProperties);
        }
        this.getLog().info((CharSequence)("Aggregate properties for lang " + lang));
        this.addAllProperties(properties, langFolder);
        File propertiesFile = new File(this.resourceAggregatedOutputDirectory, "messages_" + lang + ".properties");
        try {
            propertiesFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(propertiesFile);
            properties.store(out, COMMENT);
            out.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save " + propertiesFile, (Exception)e);
        }
        return properties;
    }

    private void addAllProperties(SortedProperties properties, File folder) throws MojoExecutionException {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                this.addAllProperties(properties, file);
                continue;
            }
            this.getLog().info((CharSequence)("Adding " + file));
            SortedProperties someProperties = new SortedProperties();
            try {
                FileInputStream inStream = new FileInputStream(file);
                someProperties.load(inStream);
                ((InputStream)inStream).close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load " + file, (Exception)e);
            }
            properties.putAll((Map<?, ?>)someProperties);
        }
    }
}

