/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.crowdin.maven;

import com.googlecode.crowdin.maven.AbstractCrowdinMojo;
import com.googlecode.crowdin.maven.tool.SortedProperties;
import com.googlecode.crowdin.maven.tool.SpecialArtifact;
import com.googlecode.crowdin.maven.tool.TranslationFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullCrowdinMojo
extends AbstractCrowdinMojo {
    private DependencyTreeBuilder treeBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;

    private void cleanFolders(Set<TranslationFile> translationFiles) {
        if (this.messagesOutputDirectory.exists()) {
            File[] languageFolders;
            for (File languageFolder : languageFolders = this.messagesOutputDirectory.listFiles()) {
                if (languageFolder.getName().startsWith(".") || !languageFolder.isDirectory()) continue;
                if (!this.containsLanguage(translationFiles, languageFolder.getName())) {
                    this.deleteFolder(languageFolder, true);
                    continue;
                }
                this.cleanLanguageFolder(languageFolder, translationFiles);
            }
        }
    }

    private void cleanLanguageFolder(File languageFolder, Set<TranslationFile> translationFiles) {
        File[] mavenIds;
        for (File mavenId : mavenIds = languageFolder.listFiles()) {
            if (mavenId.getName().startsWith(".") || !mavenId.isDirectory()) continue;
            if (!this.containsMavenId(translationFiles, mavenId.getName())) {
                this.deleteFolder(mavenId, true);
                continue;
            }
            this.deleteFolder(mavenId, false);
        }
    }

    private boolean containsLanguage(Set<TranslationFile> translationFiles, String language) {
        for (TranslationFile translationFile : translationFiles) {
            if (!translationFile.getLanguage().equals(language)) continue;
            return true;
        }
        return false;
    }

    private boolean containsMavenId(Set<TranslationFile> translationFiles, String mavenId) {
        for (TranslationFile translationFile : translationFiles) {
            if (!translationFile.getMavenId().equals(mavenId)) continue;
            return true;
        }
        return false;
    }

    private boolean deleteFolder(File folder, boolean deleteRoot) {
        File[] listFiles = folder.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.getName().startsWith(".") && !deleteRoot) continue;
                if (file.isDirectory()) {
                    this.deleteFolder(file, true);
                }
                if (!file.delete()) {
                    return false;
                }
                this.getLog().debug((CharSequence)("Deleted " + file));
            }
        }
        if (deleteRoot) {
            boolean deleted = folder.delete();
            this.getLog().debug((CharSequence)("Deleted " + folder));
            return deleted;
        }
        return true;
    }

    private Map<TranslationFile, byte[]> downloadTranslations() throws MojoExecutionException {
        try {
            String uri = "http://api.crowdin.net/api/project/" + this.authenticationInfo.getUserName() + "/download/all.zip?key=" + this.authenticationInfo.getPassword();
            this.getLog().debug((CharSequence)("Calling " + uri));
            GetMethod getMethod = new GetMethod(uri);
            int returnCode = this.client.executeMethod((HttpMethod)getMethod);
            this.getLog().debug((CharSequence)("Return code : " + returnCode));
            if (returnCode == 200) {
                ZipEntry entry;
                HashMap<TranslationFile, byte[]> translations = new HashMap<TranslationFile, byte[]>();
                InputStream responseBodyAsStream = getMethod.getResponseBodyAsStream();
                ZipInputStream zis = new ZipInputStream(responseBodyAsStream);
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    String name = entry.getName();
                    this.getLog().debug((CharSequence)("Processing " + name));
                    int slash = name.indexOf(47);
                    String language = name.substring(0, slash);
                    if ((slash = (name = name.substring(slash + 1)).indexOf(47)) <= 0) continue;
                    String mavenId = name.substring(0, slash);
                    name = name.substring(slash + 1);
                    TranslationFile translationFile = new TranslationFile(language, mavenId, name);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while (zis.available() > 0) {
                        int read = zis.read();
                        if (read == -1) continue;
                        bos.write(read);
                    }
                    bos.close();
                    translations.put(translationFile, bos.toByteArray());
                }
                return translations;
            }
            throw new MojoExecutionException("Failed to get translations from crowdin");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to call API", e);
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.messagesInputDirectory.exists()) {
            this.getLog().info((CharSequence)"Downloading translations from crowdin.");
            Map<TranslationFile, byte[]> translations = this.downloadTranslations();
            Set<Artifact> dependencyArtifacts = this.getAllDependencies();
            HashSet<String> mavenIds = new HashSet<String>();
            for (Artifact artifact : dependencyArtifacts) {
                String mavenId = this.getMavenId(artifact);
                mavenIds.add(mavenId);
            }
            HashMap<TranslationFile, byte[]> usedTranslations = new HashMap<TranslationFile, byte[]>();
            usedTranslations.putAll(translations);
            for (TranslationFile translationFile : translations.keySet()) {
                if (!mavenIds.contains(translationFile.getMavenId())) {
                    this.getLog().debug((CharSequence)(translationFile.getMavenId() + " is not a dependency"));
                    usedTranslations.remove(translationFile);
                    continue;
                }
                this.getLog().debug((CharSequence)(translationFile.getMavenId() + " is a dependency"));
            }
            translations = usedTranslations;
            if (translations.size() == 0) {
                this.getLog().info((CharSequence)"No translations available for this project!");
            } else {
                this.getLog().info((CharSequence)"Cleaning crowdin folder.");
                this.cleanFolders(translations.keySet());
                this.getLog().info((CharSequence)"Copying translations to crowdin folder.");
                try {
                    this.copyTranslations(translations);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to write file", (Exception)e);
                }
            }
        } else {
            this.getLog().info((CharSequence)(this.messagesInputDirectory.getPath() + " not found - skipping pull"));
        }
    }

    private void copyTranslations(Map<TranslationFile, byte[]> translations) throws IOException {
        Set<Map.Entry<TranslationFile, byte[]>> entrySet = translations.entrySet();
        for (Map.Entry<TranslationFile, byte[]> entry : entrySet) {
            File mavenIdFolder;
            TranslationFile translationFile = entry.getKey();
            byte[] bytes = entry.getValue();
            SortedProperties properties = new SortedProperties();
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
            properties.load(inStream);
            ((InputStream)inStream).close();
            File languageFolder = new File(this.messagesOutputDirectory, translationFile.getLanguage());
            if (!languageFolder.exists()) {
                languageFolder.mkdirs();
            }
            if (!(mavenIdFolder = new File(languageFolder, translationFile.getMavenId())).exists()) {
                mavenIdFolder.mkdirs();
            }
            File targetFile = new File(mavenIdFolder, translationFile.getName());
            this.getLog().info((CharSequence)("Importing from crowdin " + translationFile.getLanguage() + "/" + translationFile.getMavenId() + "/" + translationFile.getName()));
            FileOutputStream out = new FileOutputStream(targetFile);
            properties.store(out, "This file is automatically generated. Please do not edit this file. If you'd like to change the content please use crowdin");
            out.close();
        }
    }

    private Set<Artifact> getAllDependencies() throws MojoExecutionException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(null);
            DependencyNode rootNode = this.treeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            List nodes = visitor.getNodes();
            for (DependencyNode dependencyNode : nodes) {
                int state = dependencyNode.getState();
                Artifact artifact = dependencyNode.getArtifact();
                if (state != 0) continue;
                result.add(new SpecialArtifact(artifact));
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Failed to get dependencies", (Exception)((Object)e));
        }
        return result;
    }
}

