/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.crowdin.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    protected static final SAXBuilder saxBuilder = new SAXBuilder();
    protected MavenProject project;
    protected WagonManager wagonManager;
    protected MavenProjectHelper projectHelper;
    protected String crowdinServerId;
    protected File messagesInputDirectory;
    protected File messagesOutputDirectory;
    protected HttpClient client;
    protected AuthenticationInfo authenticationInfo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.authenticationInfo = this.wagonManager.getAuthenticationInfo(this.crowdinServerId);
        if (this.authenticationInfo == null) {
            throw new MojoExecutionException("Failed to find server with id " + this.crowdinServerId + " in Maven settings (~/.m2/settings.xml)");
        }
        this.client = new HttpClient();
    }

    protected boolean crowdinContainsFile(Element files, String fileName, boolean folder) {
        this.getLog().debug((CharSequence)("Check that crowdin project contains " + fileName));
        List items = files.getChildren("item");
        int slash = fileName.indexOf(47);
        if (slash == -1) {
            if (folder) {
                Element folderElement = this.crowdinGetFolder(items, fileName);
                if (folderElement != null) {
                    this.getLog().debug((CharSequence)("Crowdin project contains " + fileName));
                    return true;
                }
            } else {
                for (Element item : items) {
                    if (!fileName.equals(item.getChildTextNormalize("name"))) continue;
                    this.getLog().debug((CharSequence)("Crowdin project contains " + fileName));
                    return true;
                }
            }
        } else {
            String folderName = fileName.substring(0, slash);
            String subPath = fileName.substring(slash + 1);
            Element folderElement = this.crowdinGetFolder(items, folderName);
            if (folderElement != null) {
                Element subFiles = folderElement.getChild("files");
                return this.crowdinContainsFile(subFiles, subPath, folder);
            }
        }
        this.getLog().debug((CharSequence)("Crowdin project does not contain " + fileName));
        return false;
    }

    protected Element crowdinGetFolder(List<Element> items, String fileName) {
        for (Element item : items) {
            if (!fileName.equals(item.getChildTextNormalize("name")) || !this.crowdinIsFolder(item)) continue;
            return item;
        }
        return null;
    }

    protected boolean crowdinIsFolder(Element item) {
        return item.getChild("node_type") != null && "directory".equals(item.getChildTextNormalize("node_type"));
    }

    protected Document crowdinRequestAPI(String method, Map<String, String> parameters, Map<String, File> files, boolean shallSuccess) throws MojoExecutionException {
        try {
            String uri = "http://api.crowdin.net/api/project/" + this.authenticationInfo.getUserName() + "/" + method + "?key=" + this.authenticationInfo.getPassword();
            this.getLog().debug((CharSequence)("Calling " + uri));
            PostMethod postMethod = new PostMethod(uri);
            ArrayList<Object> parts = new ArrayList<Object>();
            if (parameters != null) {
                Set<Map.Entry<String, String>> entrySetParameters = parameters.entrySet();
                for (Map.Entry<String, Object> entry : entrySetParameters) {
                    parts.add(new StringPart(entry.getKey(), (String)entry.getValue()));
                }
            }
            if (files != null) {
                Set<Map.Entry<String, File>> entrySetFiles = files.entrySet();
                for (Map.Entry<String, Object> entry : entrySetFiles) {
                    String key = "files[" + entry.getKey() + "]";
                    parts.add(new FilePart(key, (File)entry.getValue()));
                }
            }
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), postMethod.getParams()));
            this.getLog().debug((CharSequence)"Sent request : ");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            postMethod.getRequestEntity().writeRequest((OutputStream)bos);
            this.getLog().debug((CharSequence)bos.toString());
            int returnCode = this.client.executeMethod((HttpMethod)postMethod);
            this.getLog().debug((CharSequence)("Return code : " + returnCode));
            this.getLog().debug((CharSequence)("Response : " + postMethod.getResponseBodyAsString()));
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            Document document = saxBuilder.build(inputStream);
            if (shallSuccess && document.getRootElement().getName().equals("error")) {
                String code = document.getRootElement().getChildTextNormalize("code");
                String message = document.getRootElement().getChildTextNormalize("message");
                throw new MojoExecutionException("Failed to call API - " + code + " - " + message);
            }
            return document;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to call API", e);
        }
    }

    protected String getMavenId(Artifact artifact) {
        return artifact.getGroupId() + "." + artifact.getArtifactId();
    }
}

