/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.crowdin.maven;

import com.googlecode.crowdin.maven.AbstractCrowdinMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushCrowdinMojo
extends AbstractCrowdinMojo {
    private void crowdinCreateFolder(String folderName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Creating " + folderName + " folder on crowdin"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", folderName);
        this.crowdinRequestAPI("add-directory", parameters, null, true);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.messagesInputDirectory.exists()) {
            HashMap<String, File> newFiles = new HashMap<String, File>();
            HashMap<String, File> toUpdateFiles = new HashMap<String, File>();
            ArrayList<String> toDeleteFiles = new ArrayList<String>();
            this.getLog().info((CharSequence)"Retrieving project informations");
            Document projectDetails = this.crowdinRequestAPI("info", null, null, false);
            Element filesElement = projectDetails.getRootElement().getChild("files");
            String folderName = this.getMavenId(this.project.getArtifact());
            this.getLog().debug((CharSequence)"Retrieving message files from this project");
            Map<String, File> files = this.getMessageFiles(folderName);
            if (!this.crowdinContainsFile(filesElement, folderName, true)) {
                this.crowdinCreateFolder(folderName);
            } else {
                List items = filesElement.getChildren("item");
                Element projectFolder = this.crowdinGetFolder(items, folderName);
                Element subFiles = projectFolder.getChild("files");
                List subItems = subFiles.getChildren("item");
                for (Element subItem : subItems) {
                    if (this.crowdinIsFolder(subItem)) continue;
                    String name = subItem.getChildTextNormalize("name");
                    String mapName = folderName + "/" + name;
                    if (files.containsKey(mapName)) continue;
                    this.getLog().debug((CharSequence)(mapName + " is in crowdin project but not in this project, delete it later"));
                    toDeleteFiles.add(mapName);
                }
            }
            Set<Map.Entry<String, File>> entrySet = files.entrySet();
            for (Map.Entry<String, File> entry : entrySet) {
                if (this.crowdinContainsFile(filesElement, entry.getKey(), false)) {
                    this.getLog().debug((CharSequence)(entry.getKey() + " has to be updated"));
                    toUpdateFiles.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.getLog().debug((CharSequence)(entry.getKey() + " has to be added"));
                newFiles.put(entry.getKey(), entry.getValue());
            }
            if (toUpdateFiles.size() != 0) {
                this.getLog().info((CharSequence)"Updating files on crowdin :");
                for (String toUpdateFile : toUpdateFiles.keySet()) {
                    this.getLog().info((CharSequence)toUpdateFile);
                }
                this.crowdinRequestAPI("update-file", null, toUpdateFiles, true);
            }
            if (newFiles.size() != 0) {
                this.getLog().info((CharSequence)"Adding files on crowdin :");
                for (String newFile : newFiles.keySet()) {
                    this.getLog().info((CharSequence)newFile);
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("type", "properties");
                this.crowdinRequestAPI("add-file", parameters, newFiles, true);
            }
            for (String toDeleteFile : toDeleteFiles) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("file", toDeleteFile);
                this.getLog().info((CharSequence)("Deleting " + toDeleteFile + " on crowdin"));
                this.crowdinRequestAPI("delete-file", parameters, null, true);
            }
        } else {
            this.getLog().info((CharSequence)(this.messagesInputDirectory.getPath() + " not found"));
        }
    }

    private Map<String, File> getMessageFiles(String folderName) {
        File[] listFiles;
        HashMap<String, File> result = new HashMap<String, File>();
        for (File file : listFiles = this.messagesInputDirectory.listFiles()) {
            if (file.isDirectory() || file.getName().startsWith(".") || !file.getName().endsWith(".properties")) continue;
            String crowdinPath = folderName + "/" + file.getName();
            this.getLog().debug((CharSequence)("Found " + crowdinPath));
            result.put(crowdinPath, file);
        }
        return result;
    }
}

