/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WorkHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class WorkProcessor<T>
implements EventProcessor {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Sequence sequence = new Sequence(-1L);
    private final RingBuffer<T> ringBuffer;
    private final SequenceBarrier sequenceBarrier;
    private final WorkHandler<T> workHandler;
    private final ExceptionHandler exceptionHandler;
    private final AtomicLong workSequence;

    public WorkProcessor(RingBuffer<T> ringBuffer, SequenceBarrier sequenceBarrier, WorkHandler<T> workHandler, ExceptionHandler exceptionHandler, AtomicLong workSequence) {
        this.ringBuffer = ringBuffer;
        this.sequenceBarrier = sequenceBarrier;
        this.workHandler = workHandler;
        this.exceptionHandler = exceptionHandler;
        this.workSequence = workSequence;
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void halt() {
        this.running.set(false);
        this.sequenceBarrier.alert();
    }

    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Thread is already running");
        }
        this.sequenceBarrier.clearAlert();
        this.notifyStart();
        boolean processedSequence = true;
        long nextSequence = this.sequence.get();
        Object event = null;
        while (true) {
            try {
                while (true) {
                    if (processedSequence) {
                        processedSequence = false;
                        nextSequence = this.workSequence.incrementAndGet();
                        this.sequence.set(nextSequence - 1L);
                    }
                    this.sequenceBarrier.waitFor(nextSequence);
                    event = this.ringBuffer.get(nextSequence);
                    this.workHandler.onEvent(event);
                    processedSequence = true;
                }
            }
            catch (AlertException ex) {
                if (this.running.get()) continue;
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleEventException(ex, nextSequence, event);
                processedSequence = true;
                continue;
            }
            break;
        }
        this.notifyShutdown();
        this.running.set(false);
    }

    private void notifyStart() {
        if (this.workHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.workHandler)).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.workHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.workHandler)).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

