/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.collections;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

public final class Histogram {
    private final long[] upperBounds;
    private final long[] counts;
    private long minValue = Long.MAX_VALUE;
    private long maxValue = 0L;

    public Histogram(long[] upperBounds) {
        this.validateBounds(upperBounds);
        this.upperBounds = Arrays.copyOf(upperBounds, upperBounds.length);
        this.counts = new long[upperBounds.length];
    }

    private void validateBounds(long[] upperBounds) {
        long lastBound = -1L;
        for (long bound : upperBounds) {
            if (bound <= 0L) {
                throw new IllegalArgumentException("Bounds must be positive values");
            }
            if (bound <= lastBound) {
                throw new IllegalArgumentException("bound " + bound + " is not greater than " + lastBound);
            }
            lastBound = bound;
        }
    }

    public int getSize() {
        return this.upperBounds.length;
    }

    public long getUpperBoundAt(int index) {
        return this.upperBounds[index];
    }

    public long getCountAt(int index) {
        return this.counts[index];
    }

    public boolean addObservation(long value) {
        int low = 0;
        int high = this.upperBounds.length - 1;
        while (low < high) {
            int mid = low + (high - low >> 1);
            if (this.upperBounds[mid] < value) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        if (value <= this.upperBounds[high]) {
            int n = high;
            this.counts[n] = this.counts[n] + 1L;
            this.trackRange(value);
            return true;
        }
        return false;
    }

    private void trackRange(long value) {
        if (value < this.minValue) {
            this.minValue = value;
        } else if (value > this.maxValue) {
            this.maxValue = value;
        }
    }

    public void addObservations(Histogram histogram) {
        int i;
        if (this.upperBounds.length != histogram.upperBounds.length) {
            throw new IllegalArgumentException("Histograms must have matching intervals");
        }
        int size = this.upperBounds.length;
        for (i = 0; i < size; ++i) {
            if (this.upperBounds[i] == histogram.upperBounds[i]) continue;
            throw new IllegalArgumentException("Histograms must have matching intervals");
        }
        size = this.counts.length;
        for (i = 0; i < size; ++i) {
            int n = i;
            this.counts[n] = this.counts[n] + histogram.counts[i];
        }
        this.trackRange(histogram.minValue);
        this.trackRange(histogram.maxValue);
    }

    public void clear() {
        this.maxValue = 0L;
        this.minValue = Long.MAX_VALUE;
        int size = this.counts.length;
        for (int i = 0; i < size; ++i) {
            this.counts[i] = 0L;
        }
    }

    public long getCount() {
        long count = 0L;
        int size = this.counts.length;
        for (int i = 0; i < size; ++i) {
            count += this.counts[i];
        }
        return count;
    }

    public long getMin() {
        return this.minValue;
    }

    public long getMax() {
        return this.maxValue;
    }

    public BigDecimal getMean() {
        if (0L == this.getCount()) {
            return BigDecimal.ZERO;
        }
        long lowerBound = this.counts[0] > 0L ? this.minValue : 0L;
        BigDecimal total = BigDecimal.ZERO;
        int size = this.upperBounds.length;
        for (int i = 0; i < size; ++i) {
            if (0L != this.counts[i]) {
                long upperBound = Math.min(this.upperBounds[i], this.maxValue);
                long midPoint = lowerBound + (upperBound - lowerBound) / 2L;
                BigDecimal intervalTotal = new BigDecimal(midPoint).multiply(new BigDecimal(this.counts[i]));
                total = total.add(intervalTotal);
            }
            lowerBound = Math.max(this.upperBounds[i] + 1L, this.minValue);
        }
        return total.divide(new BigDecimal(this.getCount()), 2, RoundingMode.HALF_UP);
    }

    public long getTwoNinesUpperBound() {
        return this.getUpperBoundForFactor(0.99);
    }

    public long getFourNinesUpperBound() {
        return this.getUpperBoundForFactor(0.9999);
    }

    public long getUpperBoundForFactor(double factor) {
        if (0.0 >= factor || factor >= 1.0) {
            throw new IllegalArgumentException("factor must be >= 0.0 and <= 1.0");
        }
        long totalCount = this.getCount();
        long tailTotal = totalCount - Math.round((double)totalCount * factor);
        long tailCount = 0L;
        for (int i = this.counts.length - 1; i >= 0; --i) {
            if (0L == this.counts[i] || (tailCount += this.counts[i]) < tailTotal) continue;
            return this.upperBounds[i];
        }
        return 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Histogram{");
        sb.append("min=").append(this.getMin()).append(", ");
        sb.append("max=").append(this.getMax()).append(", ");
        sb.append("mean=").append(this.getMean()).append(", ");
        sb.append("99%=").append(this.getTwoNinesUpperBound()).append(", ");
        sb.append("99.99%=").append(this.getFourNinesUpperBound()).append(", ");
        sb.append('[');
        int size = this.counts.length;
        for (int i = 0; i < size; ++i) {
            sb.append(this.upperBounds[i]).append('=').append(this.counts[i]).append(", ");
        }
        if (this.counts.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        sb.append('}');
        return sb.toString();
    }
}

