/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.EventPublisher;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import com.lmax.disruptor.dsl.EventProcessorInfo;
import com.lmax.disruptor.dsl.EventProcessorRepository;
import com.lmax.disruptor.dsl.ExceptionHandlerSetting;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class Disruptor<T> {
    private final RingBuffer<T> ringBuffer;
    private final Executor executor;
    private final EventProcessorRepository<T> eventProcessorRepository = new EventProcessorRepository();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final EventPublisher<T> eventPublisher;
    private ExceptionHandler exceptionHandler;

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, Executor executor) {
        this(new RingBuffer<T>(eventFactory, ringBufferSize), executor);
    }

    public Disruptor(EventFactory<T> eventFactory, Executor executor, ClaimStrategy claimStrategy, WaitStrategy waitStrategy) {
        this(new RingBuffer<T>(eventFactory, claimStrategy, waitStrategy), executor);
    }

    private Disruptor(RingBuffer<T> ringBuffer, Executor executor) {
        this.ringBuffer = ringBuffer;
        this.executor = executor;
        this.eventPublisher = new EventPublisher<T>(ringBuffer);
    }

    public EventHandlerGroup<T> handleEventsWith(EventHandler<T> ... handlers) {
        return this.createEventProcessors(new EventProcessor[0], handlers);
    }

    public EventHandlerGroup<T> handleEventsWith(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.eventProcessorRepository.add(processor);
        }
        return new EventHandlerGroup<T>(this, this.eventProcessorRepository, processors);
    }

    public void handleExceptionsWith(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandlerSetting handleExceptionsFor(EventHandler<T> eventHandler) {
        return new ExceptionHandlerSetting<T>(eventHandler, this.eventProcessorRepository);
    }

    public EventHandlerGroup<T> after(EventHandler<T> ... handlers) {
        EventProcessor[] selectedEventProcessors = new EventProcessor[handlers.length];
        int handlersLength = handlers.length;
        for (int i = 0; i < handlersLength; ++i) {
            selectedEventProcessors[i] = this.eventProcessorRepository.getEventProcessorFor(handlers[i]);
        }
        return new EventHandlerGroup<T>(this, this.eventProcessorRepository, selectedEventProcessors);
    }

    public EventHandlerGroup<T> after(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.eventProcessorRepository.add(processor);
        }
        return new EventHandlerGroup<T>(this, this.eventProcessorRepository, processors);
    }

    public void publishEvent(EventTranslator<T> eventTranslator) {
        this.eventPublisher.publishEvent(eventTranslator);
    }

    public RingBuffer<T> start() {
        EventProcessor[] gatingProcessors = this.eventProcessorRepository.getLastEventProcessorsInChain();
        this.ringBuffer.setGatingSequences(Util.getSequencesFor(gatingProcessors));
        this.checkOnlyStartedOnce();
        for (EventProcessorInfo<T> eventProcessorInfo : this.eventProcessorRepository) {
            this.executor.execute(eventProcessorInfo.getEventProcessor());
        }
        return this.ringBuffer;
    }

    public void halt() {
        for (EventProcessorInfo<T> eventprocessorInfo : this.eventProcessorRepository) {
            eventprocessorInfo.getEventProcessor().halt();
        }
    }

    public void shutdown() {
        while (this.hasBacklog()) {
        }
        this.halt();
    }

    public RingBuffer<T> getRingBuffer() {
        return this.ringBuffer;
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        return this.eventProcessorRepository.getBarrierFor(handler);
    }

    private boolean hasBacklog() {
        long cursor = this.ringBuffer.getCursor();
        for (EventProcessor consumer : this.eventProcessorRepository.getLastEventProcessorsInChain()) {
            if (cursor == consumer.getSequence().get()) continue;
            return true;
        }
        return false;
    }

    EventHandlerGroup<T> createEventProcessors(EventProcessor[] barrierEventProcessors, EventHandler<T>[] eventHandlers) {
        this.checkNotStarted();
        EventProcessor[] createdEventProcessors = new EventProcessor[eventHandlers.length];
        SequenceBarrier barrier = this.ringBuffer.newBarrier(Util.getSequencesFor(barrierEventProcessors));
        for (EventHandler<T> eventHandler : eventHandlers) {
            BatchEventProcessor<T> batchEventProcessor = new BatchEventProcessor<T>(this.ringBuffer, barrier, eventHandler);
            if (this.exceptionHandler != null) {
                batchEventProcessor.setExceptionHandler(this.exceptionHandler);
            }
            this.eventProcessorRepository.add(batchEventProcessor, eventHandler, barrier);
            createdEventProcessors[i] = batchEventProcessor;
        }
        if (createdEventProcessors.length > 0) {
            this.eventProcessorRepository.unMarkEventProcessorsAsEndOfChain(barrierEventProcessors);
        }
        return new EventHandlerGroup<T>(this, this.eventProcessorRepository, createdEventProcessors);
    }

    private void checkNotStarted() {
        if (this.started.get()) {
            throw new IllegalStateException("All event handlers must be added before calling starts.");
        }
    }

    private void checkOnlyStartedOnce() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Disruptor.start() must only be called once.");
        }
    }
}

