/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao.hibernate;

import com.googlecode.genericdao.search.ExampleOptions;
import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.SearchResult;
import com.googlecode.genericdao.search.hibernate.HibernateMetadataUtil;
import com.googlecode.genericdao.search.hibernate.HibernateSearchProcessor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBaseDAO {
    private HibernateSearchProcessor searchProcessor;
    private SessionFactory sessionFactory;
    private HibernateMetadataUtil metadataUtil;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)sessionFactory);
        this.metadataUtil = HibernateMetadataUtil.getInstanceForSessionFactory((SessionFactory)sessionFactory);
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected HibernateMetadataUtil getMetadataUtil() {
        return this.metadataUtil;
    }

    protected HibernateSearchProcessor getSearchProcessor() {
        return this.searchProcessor;
    }

    protected Serializable _save(Object entity) {
        return this.getSession().save(entity);
    }

    protected void _save(Object ... entities) {
        for (Object entity : entities) {
            this._save(entity);
        }
    }

    protected void _saveOrUpdate(Object entity) {
        this.getSession().saveOrUpdate(entity);
    }

    protected boolean _saveOrUpdateIsNew(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("attempt to saveOrUpdate with null entity");
        }
        Serializable id = this.getMetadataUtil().getId(entity);
        if (this.getSession().contains(entity)) {
            return false;
        }
        if (id == null || new Long(0L).equals(id) || !this._exists(entity)) {
            this._save(entity);
            return true;
        }
        this._update(entity);
        return false;
    }

    protected boolean[] _saveOrUpdateIsNew(Object ... entities) {
        Boolean[] exists = new Boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) {
                throw new IllegalArgumentException("attempt to saveOrUpdate with null entity");
            }
            if (this.getSession().contains(entities[i])) {
                exists[i] = true;
                continue;
            }
            Serializable id = this.getMetadataUtil().getId(entities[i]);
            if (id != null && !new Long(0L).equals(id)) continue;
            exists[i] = false;
        }
        HashMap<Class, ArrayList<Integer>> mayExist = new HashMap<Class, ArrayList<Integer>>();
        for (int i = 0; i < entities.length; ++i) {
            if (exists[i] != null) continue;
            Class entityClass = this.metadataUtil.getUnproxiedClass(entities[i]);
            ArrayList<Integer> l = (ArrayList<Integer>)mayExist.get(entityClass);
            if (l == null) {
                l = new ArrayList<Integer>();
                mayExist.put(entityClass, l);
            }
            l.add(i);
        }
        for (Map.Entry entry : mayExist.entrySet()) {
            Serializable[] ids = new Serializable[((List)entry.getValue()).size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = this.getMetadataUtil().getId(entities[(Integer)((List)entry.getValue()).get(i)]);
            }
            boolean[] exists2 = this._exists((Class)entry.getKey(), ids);
            for (int i = 0; i < ids.length; ++i) {
                exists[((Integer)((List)entry.getValue()).get((int)i)).intValue()] = exists2[i];
            }
        }
        boolean[] isNew = new boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            if (exists[i].booleanValue()) {
                this._update(entities[i]);
                isNew[i] = false;
                continue;
            }
            this._save(entities[i]);
            isNew[i] = true;
        }
        return isNew;
    }

    protected void _persist(Object ... entities) {
        for (Object entity : entities) {
            this.getSession().persist(entity);
        }
    }

    protected boolean _deleteById(Class<?> type, Serializable id) {
        if (id != null) {
            type = this.metadataUtil.getUnproxiedClass(type);
            Object entity = this.getSession().get(type, id);
            if (entity != null) {
                this.getSession().delete(entity);
                return true;
            }
        }
        return false;
    }

    protected void _deleteById(Class<?> type, Serializable ... ids) {
        type = this.metadataUtil.getUnproxiedClass(type);
        Criteria c = this.getSession().createCriteria(type);
        c.add(Restrictions.in((String)"id", (Object[])ids));
        for (Object entity : c.list()) {
            this.getSession().delete(entity);
        }
    }

    protected boolean _deleteEntity(Object entity) {
        Serializable id;
        if (entity != null && (id = this.getMetadataUtil().getId(entity)) != null && (entity = this.getSession().get(this.metadataUtil.getUnproxiedClass(entity), id)) != null) {
            this.getSession().delete(entity);
            return true;
        }
        return false;
    }

    protected void _deleteEntities(Object ... entities) {
        for (Object entity : entities) {
            if (entity == null) continue;
            this.getSession().delete(entity);
        }
    }

    protected <T> T _get(Class<T> type, Serializable id) {
        type = this.metadataUtil.getUnproxiedClass(type);
        return (T)this.getSession().get(type, id);
    }

    protected <T> T[] _get(Class<T> type, Serializable ... ids) {
        type = this.metadataUtil.getUnproxiedClass(type);
        Criteria c = this.getSession().createCriteria(type);
        c.add(Restrictions.in((String)"id", (Object[])ids));
        Object[] retVal = (Object[])Array.newInstance(type, ids.length);
        block0: for (Object entity : c.list()) {
            Serializable id = this.getMetadataUtil().getId(entity);
            for (int i = 0; i < ids.length; ++i) {
                if (!id.equals(ids[i])) continue;
                retVal[i] = entity;
                continue block0;
            }
        }
        return retVal;
    }

    protected <T> T _load(Class<T> type, Serializable id) {
        type = this.metadataUtil.getUnproxiedClass(type);
        return (T)this.getSession().load(type, id);
    }

    protected <T> T[] _load(Class<T> type, Serializable ... ids) {
        type = this.metadataUtil.getUnproxiedClass(type);
        Object[] retVal = (Object[])Array.newInstance(type, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            retVal[i] = this._load((Class<T>)type, ids[i]);
        }
        return retVal;
    }

    protected void _load(Object transientEntity, Serializable id) {
        this.getSession().load(transientEntity, id);
    }

    protected <T> List<T> _all(Class<T> type) {
        type = this.metadataUtil.getUnproxiedClass(type);
        return this.getSession().createCriteria(type).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
    }

    protected void _update(Object ... transientEntities) {
        for (Object entity : transientEntities) {
            this.getSession().update(entity);
        }
    }

    protected <T> T _merge(T entity) {
        return (T)this.getSession().merge(entity);
    }

    protected List _search(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().search(this.getSession(), search);
    }

    protected List _search(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().search(this.getSession(), searchClass, search);
    }

    protected int _count(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().count(this.getSession(), search);
    }

    protected int _count(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().count(this.getSession(), searchClass, search);
    }

    protected int _count(Class<?> type) {
        List counts = this.getSession().createQuery("select count(_it_) from " + this.getMetadataUtil().get(type).getEntityName() + " _it_").list();
        int sum = 0;
        for (Object count : counts) {
            sum += ((Long)count).intValue();
        }
        return sum;
    }

    protected SearchResult _searchAndCount(ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().searchAndCount(this.getSession(), search);
    }

    protected SearchResult _searchAndCount(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().searchAndCount(this.getSession(), searchClass, search);
    }

    protected Object _searchUnique(ISearch search) throws NonUniqueResultException {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (search.getSearchClass() == null) {
            throw new NullPointerException("Search class is null.");
        }
        return this.getSearchProcessor().searchUnique(this.getSession(), search);
    }

    protected Object _searchUnique(Class<?> searchClass, ISearch search) {
        if (search == null) {
            throw new NullPointerException("Search is null.");
        }
        if (searchClass == null) {
            throw new NullPointerException("Search class is null.");
        }
        if (search.getSearchClass() != null && !search.getSearchClass().equals(searchClass)) {
            throw new IllegalArgumentException("Search class does not match expected type: " + searchClass.getName());
        }
        return this.getSearchProcessor().searchUnique(this.getSession(), searchClass, search);
    }

    protected boolean _sessionContains(Object o) {
        return this.getSession().contains(o);
    }

    protected void _flush() {
        this.getSession().flush();
    }

    protected void _refresh(Object ... entities) {
        for (Object entity : entities) {
            this.getSession().refresh(entity);
        }
    }

    protected boolean _exists(Object entity) {
        if (this.getSession().contains(entity)) {
            return true;
        }
        return this._exists(entity.getClass(), this.getMetadataUtil().getId(entity));
    }

    protected boolean _exists(Class<?> type, Serializable id) {
        if (type == null) {
            throw new NullPointerException("Type is null.");
        }
        if (id == null) {
            return false;
        }
        type = this.metadataUtil.getUnproxiedClass(type);
        Query query = this.getSession().createQuery("select id from " + this.getMetadataUtil().get(type).getEntityName() + " where id = :id");
        query.setParameter("id", (Object)id);
        return query.list().size() == 1;
    }

    protected boolean[] _exists(Class<?> type, Serializable ... ids) {
        if (type == null) {
            throw new NullPointerException("Type is null.");
        }
        type = this.metadataUtil.getUnproxiedClass(type);
        boolean[] ret = new boolean[ids.length];
        StringBuilder sb = new StringBuilder("select id from " + this.getMetadataUtil().get(type).getEntityName() + " where");
        boolean first = true;
        for (int i = 0; i < ids.length; ++i) {
            if (first) {
                first = false;
                sb.append(" id = :id");
            } else {
                sb.append(" or id = :id");
            }
            sb.append(i);
        }
        Query query = this.getSession().createQuery(sb.toString());
        for (int i = 0; i < ids.length; ++i) {
            query.setParameter("id" + i, (Object)ids[i]);
        }
        for (Serializable id : query.list()) {
            for (int i = 0; i < ids.length; ++i) {
                if (!id.equals(ids[i])) continue;
                ret[i] = true;
            }
        }
        return ret;
    }

    protected Filter _getFilterFromExample(Object example) {
        return this.searchProcessor.getFilterFromExample(example);
    }

    protected Filter _getFilterFromExample(Object example, ExampleOptions options) {
        return this.searchProcessor.getFilterFromExample(example, options);
    }
}

