/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.maven.gettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.xnap.commons.maven.gettext.AbstractGettextMojo;
import org.xnap.commons.maven.gettext.LoggerStreamConsumer;

public class GettextMojo
extends AbstractGettextMojo {
    protected String encoding;
    protected String keywords;
    protected String xgettextCmd;
    protected FileSet extraSourceFiles;

    public void execute() throws MojoExecutionException {
        File file;
        this.getLog().info((CharSequence)("Invoking xgettext for Java files in '" + this.sourceDirectory.getAbsolutePath() + "'."));
        Commandline cl = new Commandline();
        cl.setExecutable(this.xgettextCmd);
        cl.createArgument().setValue("--from-code=" + this.encoding);
        cl.createArgument().setValue("--output=" + new File(this.poDirectory, this.keysFile).getAbsolutePath());
        cl.createArgument().setValue("--language=Java");
        cl.createArgument().setLine(this.keywords);
        cl.setWorkingDirectory(this.sourceDirectory.getAbsolutePath());
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.sourceDirectory);
        ds.setIncludes(new String[]{"**/*.java"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        List fileNameList = Collections.emptyList();
        if (this.extraSourceFiles.getDirectory() != null) {
            try {
                fileNameList = FileUtils.getFileNames((File)new File(this.extraSourceFiles.getDirectory()), (String)StringUtils.join(this.extraSourceFiles.getIncludes().iterator(), (String)","), (String)StringUtils.join(this.extraSourceFiles.getExcludes().iterator(), (String)","), (boolean)false);
            }
            catch (IOException e) {
                throw new MojoExecutionException("error finding extra source files", (Exception)e);
            }
        }
        if ((file = this.createListFile(files, fileNameList)) != null) {
            cl.createArgument().setValue("--files-from=" + file.getAbsolutePath());
        } else {
            for (int i = 0; i < files.length; ++i) {
                cl.createArgument().setValue(this.getAbsolutePath(files[i]));
            }
        }
        this.getLog().debug((CharSequence)("Executing: " + cl.toString()));
        LoggerStreamConsumer out = new LoggerStreamConsumer(this.getLog(), 1);
        LoggerStreamConsumer err = new LoggerStreamConsumer(this.getLog(), 2);
        try {
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().error((CharSequence)("Could not execute " + this.xgettextCmd + "."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createListFile(String[] files, List fileList) {
        try {
            File listFile = File.createTempFile("maven", null);
            listFile.deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(listFile));
            try {
                for (int i = 0; i < files.length; ++i) {
                    writer.write(this.toUnixPath(files[i]));
                    writer.newLine();
                }
                Iterator i = fileList.iterator();
                while (i.hasNext()) {
                    writer.write(this.toUnixPath((String)i.next()));
                    writer.newLine();
                }
            }
            finally {
                writer.close();
            }
            return listFile;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Could not create list file.", (Throwable)e);
            return null;
        }
    }

    private String getAbsolutePath(String path) {
        return this.sourceDirectory.getAbsolutePath() + File.separator + path;
    }

    private String toUnixPath(String path) {
        if (File.separatorChar != '/') {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }
}

