/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.maven.gettext;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

public class ReportMojo
extends AbstractMavenReport {
    private File outputDirectory;
    private MavenProject project;
    private SiteRenderer siteRenderer;
    protected File poDirectory;
    protected String msgfmtCmd;

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text("Gettext Statistics Report");
        sink.title_();
        sink.head_();
        sink.body();
        Stats stats = this.gatherStats();
        this.createReport(sink, stats);
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void createReport(Sink sink, Stats stats) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Gettext Statistics");
        sink.sectionTitle1_();
        sink.section1_();
        sink.table();
        sink.tableCaption();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text("Locale");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Translated");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Untranslated");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Fuzzy");
        sink.tableHeaderCell_();
        sink.tableRow_();
        List items = stats.getItems();
        Collections.sort(items);
        for (StatsEntry item : items) {
            sink.tableRow();
            sink.tableCell();
            sink.text(item.getLocale().getDisplayName());
            sink.tableCell_();
            sink.tableCell();
            sink.text(item.getTranslated() + "");
            sink.tableCell_();
            sink.tableCell();
            sink.text(item.getUntranslated() + "");
            sink.tableCell_();
            sink.tableCell();
            sink.text(item.getFuzzy() + "");
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
    }

    public String getDescription(Locale locale) {
        return "Statistics about po files.";
    }

    public String getName(Locale locale) {
        return "Gettext";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public String getOutputName() {
        return "gettext-report";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public Stats gatherStats() {
        this.getLog().info((CharSequence)("Gathering statistics for po files in '" + this.poDirectory.getAbsolutePath() + "'."));
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.poDirectory);
        ds.setIncludes(new String[]{"**/*.po"});
        ds.scan();
        Stats stats = new Stats();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.poDirectory, files[i]);
            this.getLog().info((CharSequence)("Processing " + file.getAbsolutePath()));
            Commandline cl = new Commandline();
            cl.addEnvironment("LC_ALL", "C");
            cl.setExecutable(this.msgfmtCmd);
            cl.createArgument().setValue("--statistics");
            cl.createArgument().setValue(file.getAbsolutePath());
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            try {
                int ret = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)new WriterStreamConsumer((Writer)out), (StreamConsumer)new WriterStreamConsumer((Writer)err));
                if (ret == 0) {
                    stats.parseOutput(file, ((Object)err).toString());
                    continue;
                }
                this.getLog().info((CharSequence)((Object)err).toString());
                continue;
            }
            catch (CommandLineException e) {
                this.getLog().error((CharSequence)("Could not execute msgfmt: " + ((Object)err).toString()), (Throwable)e);
            }
        }
        return stats;
    }

    public static Locale getLocale(File file) {
        String basename = file.getName().substring(0, file.getName().lastIndexOf(46));
        if (basename.contains("_")) {
            StringTokenizer t = new StringTokenizer(basename, "_");
            return new Locale(t.nextToken(), t.nextToken());
        }
        return new Locale(basename);
    }

    private class StatsEntry
    implements Comparable {
        private File file;
        private Locale locale;
        private int untranslated;
        private int fuzzy;
        private int translated;

        public StatsEntry(File file) {
            this.file = file;
            this.locale = ReportMojo.getLocale(file);
        }

        public int compareTo(Object o) {
            return this.getLocale().getDisplayName().compareTo(((StatsEntry)o).getLocale().getDisplayName());
        }

        public Locale getLocale() {
            return this.locale;
        }

        public File getFile() {
            return this.file;
        }

        public int getTotal() {
            return this.getUntranslated() + this.getTotal() + this.getTranslated();
        }

        public int getUntranslated() {
            return this.untranslated;
        }

        public int getFuzzy() {
            return this.fuzzy;
        }

        public int getTranslated() {
            return this.translated;
        }

        public void setTranslated(int translated) {
            this.translated = translated;
        }

        public void setFuzzy(int fuzzy) {
            this.fuzzy = fuzzy;
        }

        public void setUntranslated(int untranslated) {
            this.untranslated = untranslated;
        }
    }

    private class Stats {
        private List items = new ArrayList();

        private Stats() {
        }

        public void parseOutput(File file, String line) {
            StatsEntry entry = new StatsEntry(file);
            this.items.add(entry);
            StringTokenizer t = new StringTokenizer(line, ",");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.endsWith(".")) {
                    token = token.substring(0, token.length() - 1);
                }
                if (token.endsWith("untranslated messages")) {
                    entry.setUntranslated(this.extractNumber(token));
                    continue;
                }
                if (token.endsWith("translated messages")) {
                    entry.setTranslated(this.extractNumber(token));
                    continue;
                }
                if (!token.endsWith("fuzzy translations")) continue;
                entry.setFuzzy(this.extractNumber(token));
            }
        }

        private int extractNumber(String token) {
            StringTokenizer t = new StringTokenizer(token, " ");
            if (t.hasMoreTokens()) {
                try {
                    return Integer.parseInt(t.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ReportMojo.this.getLog().warn((CharSequence)("Could not parse token: " + token));
            return 0;
        }

        public List getItems() {
            return this.items;
        }
    }
}

