/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 /*
  * This file is based on code from the Apache Harmony Project.
  * http://svn.apache.org/repos/asf/harmony/enhanced/classlib/trunk/modules/luni/src/main/java/java/io/IOException.java
  */

package java.io;

/**
 * This IO exception is thrown when a program encounters some sort I/O error.
 * Details may be specified in the constructor or by one of the subclasses.
 */
public class IOException extends Exception {

    private static final long serialVersionUID = 7818375828146090155L;

    /**
     * Constructs a new instance of this class with its walkback filled in.
     */
    public IOException() {
        super();
    }

    /**
     * Constructs a new instance of this class with its walkback and message
     * filled in.
     *
     * @param detailMessage
     *            The detail message for the exception.
     */
    public IOException(String detailMessage) {
        super(detailMessage);
    }
}
