/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached;

import com.googlecode.hibernate.memcached.PropertiesHelper;
import com.googlecode.hibernate.memcached.Sha1KeyStrategy;

public class Config {
    public static final String PROP_PREFIX = "hibernate.memcached.";
    private static final String CACHE_TIME_SECONDS = "cacheTimeSeconds";
    public static final String PROP_CACHE_TIME_SECONDS = "hibernate.memcached.cacheTimeSeconds";
    private static final String CLEAR_SUPPORTED = "clearSupported";
    public static final String PROP_CLEAR_SUPPORTED = "hibernate.memcached.clearSupported";
    private static final String MEMCACHE_CLIENT_FACTORY = "memcacheClientFactory";
    public static final String PROP_MEMCACHE_CLIENT_FACTORY = "hibernate.memcached.memcacheClientFactory";
    private static final String DOGPILE_PREVENTION = "dogpilePrevention";
    public static final String PROP_DOGPILE_PREVENTION = "hibernate.memcached.dogpilePrevention";
    private static final String DOGPILE_PREVENTION_EXPIRATION_FACTOR = "dogpilePrevention.expirationFactor";
    public static final String PROP_DOGPILE_PREVENTION_EXPIRATION_FACTOR = "hibernate.memcached.dogpilePrevention.expirationFactor";
    private static final String KEY_STRATEGY = "keyStrategy";
    public static final int DEFAULT_CACHE_TIME_SECONDS = 300;
    public static final boolean DEFAULT_CLEAR_SUPPORTED = false;
    public static final boolean DEFAULT_DOGPILE_PREVENTION = false;
    public static final String DEFAULT_MEMCACHE_CLIENT_FACTORY = "com.googlecode.hibernate.memcached.spymemcached.SpyMemcacheClientFactory";
    private PropertiesHelper props;
    private static final int DEFAULT_DOGPILE_EXPIRATION_FACTOR = 2;

    public Config(PropertiesHelper props) {
        this.props = props;
    }

    public int getCacheTimeSeconds(String cacheRegion) {
        int globalCacheTimeSeconds = this.props.getInt(PROP_CACHE_TIME_SECONDS, 300);
        return this.props.getInt(this.cacheRegionPrefix(cacheRegion) + CACHE_TIME_SECONDS, globalCacheTimeSeconds);
    }

    public String getKeyStrategyName(String cacheRegion) {
        String globalKeyStrategy = this.props.get("hibernate.memcached.keyStrategy", Sha1KeyStrategy.class.getName());
        return this.props.get(this.cacheRegionPrefix(cacheRegion) + KEY_STRATEGY, globalKeyStrategy);
    }

    public boolean isClearSupported(String cacheRegion) {
        boolean globalClearSupported = this.props.getBoolean(PROP_CLEAR_SUPPORTED, false);
        return this.props.getBoolean(this.cacheRegionPrefix(cacheRegion) + CLEAR_SUPPORTED, globalClearSupported);
    }

    public boolean isDogpilePreventionEnabled(String cacheRegion) {
        boolean globalDogpilePrevention = this.props.getBoolean(PROP_DOGPILE_PREVENTION, false);
        return this.props.getBoolean(this.cacheRegionPrefix(cacheRegion) + DOGPILE_PREVENTION, globalDogpilePrevention);
    }

    public double getDogpilePreventionExpirationFactor(String cacheRegion) {
        double globalFactor = this.props.getDouble(PROP_DOGPILE_PREVENTION_EXPIRATION_FACTOR, 2.0);
        return this.props.getDouble(this.cacheRegionPrefix(cacheRegion) + DOGPILE_PREVENTION_EXPIRATION_FACTOR, globalFactor);
    }

    public String getMemcachedClientFactoryName() {
        return this.props.get(PROP_MEMCACHE_CLIENT_FACTORY, DEFAULT_MEMCACHE_CLIENT_FACTORY);
    }

    private String cacheRegionPrefix(String cacheRegion) {
        return PROP_PREFIX + cacheRegion + ".";
    }

    public PropertiesHelper getPropertiesHelper() {
        return this.props;
    }
}

