/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached;

import com.googlecode.hibernate.memcached.KeyStrategy;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.Sha1KeyStrategy;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedCache
implements Cache {
    private final Logger log = LoggerFactory.getLogger(MemcachedCache.class);
    private final String regionName;
    private final Memcache memcache;
    private final String clearIndexKey;
    private int cacheTimeSeconds = 300;
    private boolean clearSupported = false;
    private KeyStrategy keyStrategy = new Sha1KeyStrategy();
    private boolean dogpilePreventionEnabled = false;
    private double dogpilePreventionExpirationFactor = 2.0;
    public static final Integer DOGPILE_TOKEN = 0;

    public MemcachedCache(String regionName, Memcache memcachedClient) {
        this.regionName = regionName != null ? regionName : "default";
        this.memcache = memcachedClient;
        this.clearIndexKey = this.regionName.replaceAll("\\s", "") + ":index_key";
    }

    public int getCacheTimeSeconds() {
        return this.cacheTimeSeconds;
    }

    public void setCacheTimeSeconds(int cacheTimeSeconds) {
        this.cacheTimeSeconds = cacheTimeSeconds;
    }

    public boolean isClearSupported() {
        return this.clearSupported;
    }

    public void setClearSupported(boolean clearSupported) {
        this.clearSupported = clearSupported;
    }

    public boolean isDogpilePreventionEnabled() {
        return this.dogpilePreventionEnabled;
    }

    public void setDogpilePreventionEnabled(boolean dogpilePreventionEnabled) {
        this.dogpilePreventionEnabled = dogpilePreventionEnabled;
    }

    public double getDogpilePreventionExpirationFactor() {
        return this.dogpilePreventionExpirationFactor;
    }

    public void setDogpilePreventionExpirationFactor(double dogpilePreventionExpirationFactor) {
        if (dogpilePreventionExpirationFactor < 1.0) {
            throw new IllegalArgumentException("dogpilePreventionExpirationFactor must be greater than 1.0");
        }
        this.dogpilePreventionExpirationFactor = dogpilePreventionExpirationFactor;
    }

    private String dogpileTokenKey(String objectKey) {
        return objectKey + ".dogpileTokenKey";
    }

    private Object memcacheGet(Object key) {
        String objectKey = this.toKey(key);
        if (this.dogpilePreventionEnabled) {
            return this.getUsingDogpilePrevention(objectKey);
        }
        this.log.debug("Memcache.get({})", (Object)objectKey);
        return this.memcache.get(objectKey);
    }

    private Object getUsingDogpilePrevention(String objectKey) {
        String dogpileKey = this.dogpileTokenKey(objectKey);
        this.log.debug("Checking dogpile key: [{}]", (Object)dogpileKey);
        this.log.debug("Memcache.getMulti({}, {})", (Object)objectKey, (Object)dogpileKey);
        Map<String, Object> multi = this.memcache.getMulti(dogpileKey, objectKey);
        if (multi == null || multi.get(dogpileKey) == null) {
            this.log.debug("Dogpile key ({}) not found updating token and returning null", (Object)dogpileKey);
            this.memcache.set(dogpileKey, this.cacheTimeSeconds, DOGPILE_TOKEN);
            return null;
        }
        return multi.get(objectKey);
    }

    private void memcacheSet(Object key, Object o) {
        String objectKey = this.toKey(key);
        int cacheTime = this.cacheTimeSeconds;
        if (this.dogpilePreventionEnabled) {
            String dogpileKey = this.dogpileTokenKey(objectKey);
            this.log.debug("Dogpile prevention enabled, setting token and adjusting object cache time. Key: [{}]", (Object)dogpileKey);
            this.memcache.set(dogpileKey, this.cacheTimeSeconds, DOGPILE_TOKEN);
            cacheTime = (int)((double)this.cacheTimeSeconds * this.dogpilePreventionExpirationFactor);
        }
        this.log.debug("Memcache.set({})", (Object)objectKey);
        this.memcache.set(objectKey, cacheTime, o);
    }

    private String toKey(Object key) {
        return this.keyStrategy.toKey(this.regionName, this.getClearIndex(), key);
    }

    public Object read(Object key) throws CacheException {
        return this.memcacheGet(key);
    }

    public Object get(Object key) throws CacheException {
        return this.memcacheGet(key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.memcacheSet(key, value);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        this.memcache.delete(this.toKey(key));
    }

    public void clear() throws CacheException {
        if (this.clearSupported) {
            this.memcache.incr(this.clearIndexKey, 1, 1);
        }
    }

    public void destroy() throws CacheException {
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return this.cacheTimeSeconds;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map<?, ?> toMap() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Memcached (" + this.regionName + ")";
    }

    private long getClearIndex() {
        Long index = null;
        if (this.clearSupported) {
            Object value = this.memcache.get(this.clearIndexKey);
            if (value != null) {
                if (value instanceof String) {
                    index = Long.valueOf((String)value);
                } else if (value instanceof Long) {
                    index = (Long)value;
                } else {
                    throw new IllegalArgumentException("Unsupported type [" + value.getClass() + "] found for clear index at cache key [" + this.clearIndexKey + "]");
                }
            }
            if (index != null) {
                return index;
            }
        }
        return 0L;
    }

    public KeyStrategy getKeyStrategy() {
        return this.keyStrategy;
    }

    public void setKeyStrategy(KeyStrategy keyStrategy) {
        this.keyStrategy = keyStrategy;
    }
}

