/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached.dangamemcached;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.googlecode.hibernate.memcached.LoggingMemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.utils.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DangaMemcache
implements Memcache {
    private static final Logger log = LoggerFactory.getLogger(DangaMemcache.class);
    private final MemCachedClient memcachedClient;
    private final String poolName;
    private MemcacheExceptionHandler exceptionHandler = new LoggingMemcacheExceptionHandler();

    public DangaMemcache(MemCachedClient memcachedClient, String poolName) {
        this.memcachedClient = memcachedClient;
        this.poolName = poolName;
    }

    @Override
    public Object get(String key) {
        try {
            log.debug("MemCachedClient.get({})", (Object)key);
            return this.memcachedClient.get(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(key, e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getMulti(String ... keys) {
        try {
            return this.memcachedClient.getMulti(keys);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(StringUtils.join(keys, ", "), e);
            return null;
        }
    }

    @Override
    public void set(String key, int cacheTimeSeconds, Object o) {
        log.debug("MemCachedClient.set({})", (Object)key);
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(13, cacheTimeSeconds);
            this.memcachedClient.set(key, o, calendar.getTime());
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnSet(key, cacheTimeSeconds, o, e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.memcachedClient.delete(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnDelete(key, e);
        }
    }

    @Override
    public void incr(String key, int factor, int startingValue) {
        try {
            long rv = this.memcachedClient.incr(key, (long)factor);
            if (-1L == rv) {
                this.memcachedClient.addOrIncr(key, (long)startingValue);
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnIncr(key, factor, startingValue, e);
        }
    }

    @Override
    public void shutdown() {
        log.debug("Shutting down danga MemCachedClient");
        SockIOPool.getInstance((String)this.poolName).shutDown();
    }

    public void setExceptionHandler(MemcacheExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

