/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached.dangamemcached;

import com.danga.MemCached.ErrorHandler;
import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheClientFactory;
import com.googlecode.hibernate.memcached.PropertiesHelper;
import com.googlecode.hibernate.memcached.dangamemcached.DangaMemcache;
import org.hibernate.cache.CacheException;

public class DangaMemcacheClientFactory
implements MemcacheClientFactory {
    public static final String PROP_PREFIX = "hibernate.memcached.";
    public static final String PROP_COMPRESS_ENABLE = "hibernate.memcached.compressEnable";
    public static final String PROP_DEFAULT_ENCODING = "hibernate.memcached.defaultEncoding";
    public static final String PROP_POOL_NAME = "hibernate.memcached.poolName";
    public static final String PROP_ERROR_HANDLER = "hibernate.memcached.errorHandler";
    public static final String PROP_SERVERS = "hibernate.memcached.servers";
    public static final String PROP_WEIGHTS = "hibernate.memcached.weights";
    public static final String PROP_INIT_CONN = "hibernate.memcached.initConn";
    public static final String PROP_MIN_CONN = "hibernate.memcached.minConn";
    public static final String PROP_MAX_CONN = "hibernate.memcached.maxConn";
    public static final String PROP_MAX_IDLE = "hibernate.memcached.maxIdle";
    public static final String PROP_MAINT_SLEEP = "hibernate.memcached.maintSleep";
    public static final String PROP_SOCKET_TIMEOUT = "hibernate.memcached.socketTimeout";
    public static final String PROP_SOCKET_CONNECT_TIMEOUT = "hibernate.memcached.socketConnectTimeout";
    public static final boolean DEFAULT_COMPRESS_ENABLE = true;
    public static final String DEFAULT_DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_POOL_NAME = "default";
    public static final String DEFAULT_ERROR_HANDLER = "com.googlecode.hibernate.memcached.dangamemcached.SimpleErrorHandler";
    public static final String DEFAULT_SERVERS = "localhost:11211";
    public static final int DEFAULT_INIT_CONN = 1;
    public static final int DEFAULT_MIN_CONN = 1;
    public static final int DEFAULT_MAX_CONN = 10;
    public static final int DEFAULT_MAX_IDLE = 300000;
    public static final int DEFAULT_MAINT_SLEEP = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 3000;
    private PropertiesHelper properties;

    public DangaMemcacheClientFactory(PropertiesHelper properties) {
        this.properties = properties;
    }

    public Memcache createMemcacheClient() throws Exception {
        String poolName = this.getPoolName();
        SockIOPool pool = SockIOPool.getInstance((String)poolName);
        pool.setServers(this.getServers());
        pool.setWeights(this.getWeights());
        pool.setInitConn(this.getInitConn());
        pool.setMinConn(this.getMinConn());
        pool.setMaxConn(this.getMaxConn());
        pool.setMaxIdle((long)this.getMaxIdle());
        pool.setMaintSleep((long)this.getMaintSleep());
        pool.setNagle(false);
        pool.setSocketTO(this.getSocketTimeout());
        pool.setSocketConnectTO(this.getSocketConnectTimeout());
        pool.initialize();
        MemCachedClient client = new MemCachedClient(this.getClassLoader(), this.getErrorHandler(), poolName);
        client.setCompressEnable(this.isCompressEnable());
        client.setDefaultEncoding(this.getDefaultEncoding());
        return new DangaMemcache(client, poolName);
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean isCompressEnable() {
        return this.properties.getBoolean(PROP_COMPRESS_ENABLE, true);
    }

    public String getDefaultEncoding() {
        return this.properties.get(PROP_DEFAULT_ENCODING, DEFAULT_DEFAULT_ENCODING);
    }

    public String getPoolName() {
        return this.properties.get(PROP_POOL_NAME, DEFAULT_POOL_NAME);
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler;
        String errorHandlerName = this.properties.get(PROP_ERROR_HANDLER, DEFAULT_ERROR_HANDLER);
        try {
            errorHandler = (ErrorHandler)Class.forName(errorHandlerName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Unable to find error handler class [" + errorHandlerName + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Illegally accessed error handler class [" + errorHandlerName + "]", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CacheException("Failed to instantiate error handler class [" + errorHandlerName + "]", (Throwable)e);
        }
        return errorHandler;
    }

    public String[] getServers() {
        return this.properties.get(PROP_SERVERS, DEFAULT_SERVERS).split(" ");
    }

    public Integer[] getWeights() {
        String[] servers = this.getServers();
        Integer[] weights = new Integer[servers.length];
        String weightsValue = this.properties.get(PROP_WEIGHTS);
        if (weightsValue == null || "".equals(weightsValue)) {
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = 1;
            }
        } else {
            String[] weightsStrings = weightsValue.split(" ");
            if (weightsStrings.length == servers.length) {
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = new Integer(weightsStrings[i]);
                }
            } else {
                throw new CacheException("Count of weight number mismatch count of server");
            }
        }
        return weights;
    }

    public int getInitConn() {
        return this.properties.getInt(PROP_INIT_CONN, 1);
    }

    public int getMinConn() {
        return this.properties.getInt(PROP_MIN_CONN, 1);
    }

    public int getMaxConn() {
        return this.properties.getInt(PROP_MAX_CONN, 10);
    }

    public int getMaxIdle() {
        return this.properties.getInt(PROP_MAX_IDLE, 300000);
    }

    public int getMaintSleep() {
        return this.properties.getInt(PROP_MAINT_SLEEP, 30000);
    }

    public int getSocketTimeout() {
        return this.properties.getInt(PROP_SOCKET_TIMEOUT, 30000);
    }

    public int getSocketConnectTimeout() {
        return this.properties.getInt(PROP_SOCKET_CONNECT_TIMEOUT, 3000);
    }
}

