/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached.spymemcached;

import com.googlecode.hibernate.memcached.LoggingMemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.utils.StringUtils;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyMemcache
implements Memcache {
    private static final Logger log = LoggerFactory.getLogger(SpyMemcache.class);
    private MemcacheExceptionHandler exceptionHandler = new LoggingMemcacheExceptionHandler();
    private final MemcachedClient memcachedClient;

    public SpyMemcache(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    @Override
    public Object get(String key) {
        try {
            log.debug("MemcachedClient.get({})", (Object)key);
            return this.memcachedClient.get(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(key, e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getMulti(String ... keys) {
        try {
            return this.memcachedClient.getBulk(keys);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(StringUtils.join(keys, ", "), e);
            return null;
        }
    }

    @Override
    public void set(String key, int cacheTimeSeconds, Object o) {
        log.debug("MemcachedClient.set({})", (Object)key);
        try {
            this.memcachedClient.set(key, cacheTimeSeconds, o);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnSet(key, cacheTimeSeconds, o, e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.memcachedClient.delete(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnDelete(key, e);
        }
    }

    @Override
    public void incr(String key, int factor, int startingValue) {
        try {
            this.memcachedClient.incr(key, factor, (long)startingValue);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnIncr(key, factor, startingValue, e);
        }
    }

    @Override
    public void shutdown() {
        log.debug("Shutting down spy MemcachedClient");
        this.memcachedClient.shutdown();
    }

    public void setExceptionHandler(MemcacheExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

