/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.Frame;
import au.com.southsky.jfreesane.SaneDevice;
import au.com.southsky.jfreesane.SaneException;
import au.com.southsky.jfreesane.SaneParameters;
import au.com.southsky.jfreesane.SaneStatus;
import au.com.southsky.jfreesane.ScanListener;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedInteger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class FrameReader {
    private static final Logger log = Logger.getLogger(FrameReader.class.getName());
    private final SaneDevice device;
    private final SaneParameters parameters;
    private final InputStream underlyingStream;
    private final boolean bigEndian;
    private final ScanListener listener;

    FrameReader(SaneDevice device, SaneParameters parameters, InputStream underlyingStream, boolean bigEndian, ScanListener listener) {
        this.device = device;
        this.parameters = parameters;
        this.underlyingStream = underlyingStream;
        this.bigEndian = bigEndian;
        this.listener = listener;
    }

    public Frame readFrame() throws IOException, SaneException {
        int bytesRead;
        log.log(Level.FINE, "Reading frame: {0}", this);
        int imageSize = this.parameters.getBytesPerLine() * this.parameters.getLineCount();
        int reportedImageSize = this.parameters.getLineCount() == -1 ? -1 : imageSize;
        ByteArrayOutputStream bigArray = this.parameters.getLineCount() > 0 ? new ByteArrayOutputStream(imageSize) : new ByteArrayOutputStream(256);
        int totalBytesRead = 0;
        while ((bytesRead = this.readRecord(bigArray)) >= 0) {
            this.listener.recordRead(this.device, totalBytesRead += bytesRead, reportedImageSize);
        }
        if (imageSize > 0 && bigArray.size() < imageSize) {
            int difference = imageSize - bigArray.size();
            log.log(Level.WARNING, "truncated read (got {0}, expected {1} bytes)", new Object[]{bigArray.size(), imageSize});
            bigArray.write(new byte[difference]);
            log.log(Level.WARNING, "padded image with {0} null bytes", difference);
        }
        byte[] outputArray = bigArray.toByteArray();
        if (this.parameters.getDepthPerPixel() == 16 && !this.bigEndian) {
            if (outputArray.length % 2 != 0) {
                throw new IOException("expected a multiple of 2 frame length");
            }
            for (int i = 0; i < outputArray.length; i += 2) {
                byte swap = outputArray[i];
                outputArray[i] = outputArray[i + 1];
                outputArray[i + 1] = swap;
            }
        }
        if (this.parameters.getLineCount() <= 0) {
            this.parameters.setLineCount(outputArray.length / this.parameters.getBytesPerLine());
            log.log(Level.FINE, "Detected new frame line count: {0}", this.parameters.getLineCount());
        }
        return new Frame(this.parameters, outputArray);
    }

    private int readRecord(OutputStream destination) throws IOException, SaneException {
        DataInputStream inputStream = new DataInputStream(this.underlyingStream);
        int length = inputStream.readInt();
        if (length == -1) {
            SaneStatus saneStatus;
            log.fine("Reached end of records");
            int status = inputStream.read();
            if (status != -1 && (saneStatus = SaneStatus.fromWireValue(status)) != null && saneStatus != SaneStatus.STATUS_EOF) {
                throw new SaneException(saneStatus);
            }
            return -1;
        }
        if (UnsignedInteger.fromIntBits((int)length).longValue() > Integer.MAX_VALUE) {
            throw new IllegalStateException("TODO: support massive records");
        }
        int bytesRead = (int)ByteStreams.copy((InputStream)ByteStreams.limit((InputStream)inputStream, (long)length), (OutputStream)destination);
        log.log(Level.FINE, "Read a record of {0} bytes", bytesRead);
        return bytesRead;
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrameReader.class).add("isBigEndian", this.bigEndian).add("parameters", (Object)this.parameters).toString();
    }
}

