/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.OptionValueType;
import au.com.southsky.jfreesane.SaneOption;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class OptionGroup {
    private final String title;
    private List<SaneOption> options = Lists.newArrayList();

    public OptionGroup(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public OptionValueType getValueType() {
        return OptionValueType.GROUP;
    }

    public List<SaneOption> getOptions() {
        return ImmutableList.copyOf(this.options);
    }

    void addOption(SaneOption option) {
        Preconditions.checkState((option.getGroup() == this ? 1 : 0) != 0);
        this.options.add(option);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.title).add("options", this.options).toString();
    }
}

