/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.SaneDevice;
import au.com.southsky.jfreesane.SaneParameters;
import au.com.southsky.jfreesane.ScanListener;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class RateLimitingScanListeners {
    private RateLimitingScanListeners() {
    }

    public static ScanListener noMoreFrequentlyThan(final ScanListener listener, final long time, final TimeUnit timeUnit) {
        return new ScanListener(){
            private Map<SaneDevice, Long> lastSentTime = Maps.newHashMapWithExpectedSize((int)1);

            @Override
            public void scanningStarted(SaneDevice device) {
                listener.scanningStarted(device);
            }

            @Override
            public void frameAcquisitionStarted(SaneDevice device, SaneParameters parameters, int currentFrame, int likelyTotalFrames) {
                listener.frameAcquisitionStarted(device, parameters, currentFrame, likelyTotalFrames);
            }

            @Override
            public void recordRead(SaneDevice device, int totalBytesRead, int imageSizeBytes) {
                long currentTime = System.currentTimeMillis();
                if (!this.lastSentTime.containsKey(device)) {
                    this.lastSentTime.put(device, 0L);
                }
                if (currentTime - this.lastSentTime.get(device) > timeUnit.toMillis(time)) {
                    this.lastSentTime.put(device, currentTime);
                    listener.recordRead(device, totalBytesRead, imageSizeBytes);
                }
            }

            @Override
            public void scanningFinished(SaneDevice device) {
                listener.scanningFinished(device);
            }
        };
    }
}

