/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.SanePasswordProvider;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SaneClientAuthentication
extends SanePasswordProvider {
    private static final Logger logger = Logger.getLogger(SaneClientAuthentication.class.getName());
    public static final String MARKER_MD5 = "$MD5$";
    private static final String DEFAULT_CONFIGURATION_PATH = Joiner.on((String)File.separator).join((Object)System.getProperty("user.home"), (Object)".sane", new Object[]{"pass"});
    private final Table<String, String, String> credentials = HashBasedTable.create();
    private final CharSource configurationSource;
    private boolean initialized = false;

    public SaneClientAuthentication() {
        this(DEFAULT_CONFIGURATION_PATH);
    }

    public SaneClientAuthentication(final String path) {
        this(new CharSource(){

            public Reader openStream() throws IOException {
                return new InputStreamReader((InputStream)new FileInputStream(path), Charsets.US_ASCII);
            }
        });
    }

    public SaneClientAuthentication(CharSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    private synchronized void initializeIfRequired() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            CharStreams.readLines((Readable)this.configurationSource.openStream(), (LineProcessor)new LineProcessor<Void>(){
                private int lineNumber = 0;

                public boolean processLine(String line) throws IOException {
                    ++this.lineNumber;
                    ClientCredential credential = ClientCredential.fromAuthString(line);
                    if (credential == null) {
                        logger.log(Level.WARNING, "ignoring invalid configuration format (line {0}): {1}", new Object[]{this.lineNumber, line});
                    } else {
                        SaneClientAuthentication.this.credentials.put((Object)credential.backend, (Object)credential.username, (Object)credential.password);
                        if (SaneClientAuthentication.this.credentials.row((Object)credential.backend).size() > 1) {
                            logger.log(Level.WARNING, "ignoring line {0}, we already have a configuration for resource [{1}]", new Object[]{this.lineNumber, credential.backend});
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "could not read auth configuration due to IOException", e);
        }
    }

    @Override
    public boolean canAuthenticate(String resource) {
        if (resource == null) {
            return false;
        }
        ClientCredential credential = this.getCredentialForResource(resource);
        return credential != null;
    }

    public ClientCredential getCredentialForResource(String rc) {
        this.initializeIfRequired();
        String resource = rc.contains(MARKER_MD5) ? rc.substring(0, rc.indexOf(MARKER_MD5)) : rc;
        Map credentialsForResource = this.credentials.row((Object)resource);
        Iterator iterator = credentialsForResource.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry credential = iterator.next();
            return new ClientCredential(resource, (String)credential.getKey(), (String)credential.getValue());
        }
        return null;
    }

    @Override
    public String getUsername(String resource) {
        return this.getCredentialForResource(resource).username;
    }

    @Override
    public String getPassword(String resource) {
        return this.getCredentialForResource(resource).password;
    }

    public static class ClientCredential {
        private final String backend;
        private final String username;
        private final String password;

        protected ClientCredential(String backend, String username, String password) {
            this.backend = backend;
            this.username = username;
            this.password = password;
        }

        public static ClientCredential fromAuthString(String authString) {
            List fields = Splitter.on((String)":").splitToList((CharSequence)authString);
            if (fields.size() < 3) {
                return null;
            }
            return new ClientCredential((String)fields.get(2), (String)fields.get(0), (String)fields.get(1));
        }

        public String getBackend() {
            return this.backend;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

