/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.OptionGroup;
import au.com.southsky.jfreesane.SaneDeviceHandle;
import au.com.southsky.jfreesane.SaneException;
import au.com.southsky.jfreesane.SaneOption;
import au.com.southsky.jfreesane.SaneSession;
import au.com.southsky.jfreesane.ScanListener;
import au.com.southsky.jfreesane.ScanListenerAdapter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SaneDevice
implements Closeable {
    private final SaneSession session;
    private final String name;
    private final String vendor;
    private final String model;
    private final String type;
    private SaneDeviceHandle handle;
    private Map<String, SaneOption> optionTitleMap = null;
    private final List<OptionGroup> groups = Lists.newArrayList();

    SaneDevice(SaneSession session, String name, String vendor, String model, String type) {
        this.session = session;
        this.name = name;
        this.vendor = vendor;
        this.model = model;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    public void open() throws IOException, SaneException {
        Preconditions.checkState((!this.isOpen() ? 1 : 0) != 0, (Object)"device is already open");
        this.handle = this.session.openDevice(this);
    }

    public BufferedImage acquireImage() throws IOException, SaneException {
        return this.acquireImage(null);
    }

    public BufferedImage acquireImage(ScanListener listener) throws IOException, SaneException {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"device is not open");
        if (listener == null) {
            listener = new ScanListenerAdapter();
        }
        return this.session.acquireImage(this, listener);
    }

    public void cancel() throws IOException {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"device is not open");
        this.session.cancelDevice(this.handle);
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("device is already closed");
        }
        this.session.closeDevice(this.handle);
        this.handle = null;
    }

    public String toString() {
        return "SaneDevice [name=" + this.name + ", vendor=" + this.vendor + ", model=" + this.model + ", type=" + this.type + "]";
    }

    SaneDeviceHandle getHandle() {
        return this.handle;
    }

    public List<SaneOption> listOptions() throws IOException {
        if (this.optionTitleMap == null) {
            this.groups.clear();
            this.optionTitleMap = Maps.uniqueIndex(SaneOption.optionsFor(this), (Function)new Function<SaneOption, String>(){

                public String apply(SaneOption input) {
                    return input.getName();
                }
            });
        }
        return ImmutableList.copyOf(this.optionTitleMap.values());
    }

    void addOptionGroup(OptionGroup group) {
        this.groups.add(group);
    }

    public List<OptionGroup> getOptionGroups() throws IOException {
        this.listOptions();
        return ImmutableList.copyOf(this.groups);
    }

    public SaneOption getOption(String title) throws IOException {
        this.listOptions();
        return this.optionTitleMap.get(title);
    }

    SaneSession getSession() {
        return this.session;
    }

    void invalidateOptions() {
        this.optionTitleMap = null;
    }
}

