/*
 * Decompiled with CFR 0.152.
 */
package au.com.southsky.jfreesane;

import au.com.southsky.jfreesane.SaneEnum;
import au.com.southsky.jfreesane.SaneWord;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

final class SaneEnums {
    private static Map<Class<?>, Map<Integer, ?>> cachedTypeMaps = Maps.newHashMap();

    private SaneEnums() {
    }

    private static synchronized <T extends Enum<T>> Map<Integer, T> mapForType(Class<T> enumType) {
        if (cachedTypeMaps.containsKey(enumType)) {
            return cachedTypeMaps.get(enumType);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Enum value : (Enum[])enumType.getEnumConstants()) {
            mapBuilder.put((Object)((SaneEnum)((Object)value)).getWireValue(), (Object)value);
        }
        ImmutableMap result = mapBuilder.build();
        cachedTypeMaps.put(enumType, (Map<Integer, ?>)result);
        return result;
    }

    public static <T extends Enum<T>> Set<T> enumSet(Class<T> enumType, int wireValue) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        ArrayList values = Lists.newArrayListWithCapacity((int)enumConstants.length);
        for (Enum value : enumConstants) {
            if ((wireValue & ((SaneEnum)((Object)value)).getWireValue()) == 0) continue;
            values.add(value);
        }
        return Sets.immutableEnumSet((Iterable)values);
    }

    public static <T extends SaneEnum> int wireValue(Set<T> values) {
        int result = 0;
        for (SaneEnum value : values) {
            result |= value.getWireValue();
        }
        return result;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, int valueType) {
        return (T)((Enum)SaneEnums.mapForType(enumType).get(valueType));
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, SaneWord value) {
        return SaneEnums.valueOf(enumType, value.integerValue());
    }
}

